/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jd;

import org.appwork.storage.Storable;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.jdownloader.controlling.AggregatedCrawlerNumbers;
import org.jdownloader.controlling.AggregatedNumbers;

@StorableValidatorIgnoresMissingSetter
public class AggregatedNumbersAPIStorable
implements Storable {
    private AggregatedNumbers aggregated;
    private AggregatedCrawlerNumbers aggregatedCrawler;

    public AggregatedNumbersAPIStorable() {
    }

    public AggregatedNumbersAPIStorable(AggregatedNumbers aggregated, AggregatedCrawlerNumbers aggregatedCrawler) {
        this.aggregated = aggregated;
        this.aggregatedCrawler = aggregatedCrawler;
    }

    public Integer getPackageCount() {
        return this.aggregated.getPackageCount();
    }

    public Integer getLinksCount() {
        return this.aggregated.getLinkCount();
    }

    public Long getTotalBytes() {
        return this.aggregated.getTotalBytes();
    }

    public Long getDownloadSpeed() {
        return this.aggregated.getDownloadSpeed();
    }

    public Long getLoadedBytes() {
        return this.aggregated.getLoadedBytes();
    }

    public Long getETA() {
        Long ret = this.aggregated.getEta();
        if (ret == null || ret < 0L) {
            return 0L;
        }
        return (long)ret;
    }

    public Integer getRunning() {
        return this.aggregated.getRunning();
    }

    public Integer getConnections() {
        return this.aggregated.getConnections();
    }

    public Integer getCrawledPackageCount() {
        return this.aggregatedCrawler.getPackageCount();
    }

    public Integer getCrawledLinksCount() {
        return this.aggregatedCrawler.getLinkCount();
    }

    public Long getTotalCrawledBytes() {
        return this.aggregatedCrawler.getTotalBytes();
    }

    public Long getCrawledStatusOnline() {
        return this.aggregatedCrawler.getStatusOnline();
    }

    public Long getCrawledStatusOffline() {
        return this.aggregatedCrawler.getStatusOffline();
    }

    public Long getCrawledStatusUnknown() {
        return this.aggregatedCrawler.getStatusUnknown();
    }
}

