/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api;

import java.util.ArrayList;
import java.util.List;
import jd.controlling.captcha.SkipRequest;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.remoteapi.exceptions.RemoteAPIException;
import org.jdownloader.api.captcha.CaptchaAPISolver;
import org.jdownloader.api.jdanywhere.api.interfaces.CAPTCHA;
import org.jdownloader.api.jdanywhere.api.interfaces.ICaptchaApi;
import org.jdownloader.api.jdanywhere.api.storable.CaptchaJob;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.captcha.v2.solverjob.SolverJob;

public class CaptchaApi
implements ICaptchaApi {
    CaptchaAPISolver cpAPI = CaptchaAPISolver.getInstance();

    @Override
    public List<CaptchaJob> list() {
        ArrayList<CaptchaJob> ret = new ArrayList<CaptchaJob>();
        for (SolverJob entry : this.cpAPI.listJobs()) {
            if (entry.isDone() || !(entry.getChallenge() instanceof ImageCaptchaChallenge)) continue;
            ImageCaptchaChallenge challenge = (ImageCaptchaChallenge)entry.getChallenge();
            CaptchaJob apiJob = new CaptchaJob();
            if (challenge.getResultType().isAssignableFrom(String.class)) {
                apiJob.setType("Text");
            } else {
                apiJob.setType("Click");
            }
            apiJob.setID(challenge.getId().getID());
            apiJob.setHoster(challenge.getPlugin().getHost());
            apiJob.setCaptchaCategory(challenge.getExplain());
            ret.add(apiJob);
        }
        return ret;
    }

    @Override
    public void get(RemoteAPIRequest request, RemoteAPIResponse response, long id) throws InternalApiException, RemoteAPIException {
        this.cpAPI.get(request, response, id);
    }

    @Override
    public boolean solve(long id, String result) throws RemoteAPIException {
        return this.cpAPI.solve(id, result);
    }

    @Override
    public boolean abort(long id, CAPTCHA what) throws RemoteAPIException {
        return this.cpAPI.skip(id, SkipRequest.SINGLE);
    }
}

