/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.JSonStorage;
import org.jdownloader.api.downloads.DownloadsAPI;
import org.jdownloader.api.jdanywhere.api.Helper;
import org.jdownloader.api.jdanywhere.api.interfaces.IDownloadLinkApi;
import org.jdownloader.api.jdanywhere.api.storable.DownloadLinkInfoStorable;
import org.jdownloader.api.jdanywhere.api.storable.DownloadLinkStorable;
import org.jdownloader.controlling.Priority;

public class DownloadLinkApi
implements IDownloadLinkApi {
    private final DownloadsAPI dlAPI;

    public DownloadLinkApi(DownloadsAPI dlAPI) {
        this.dlAPI = dlAPI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadLinkStorable> list(long ID2) {
        DownloadController dlc = DownloadController.getInstance();
        for (FilePackage fpkg : dlc.getPackages()) {
            if (fpkg.getUniqueID().getID() != ID2) continue;
            FilePackage filePackage = fpkg;
            synchronized (filePackage) {
                ArrayList<DownloadLinkStorable> links = new ArrayList<DownloadLinkStorable>(fpkg.size());
                for (DownloadLink link : fpkg.getChildren()) {
                    links.add(new DownloadLinkStorable(link));
                }
                return links;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] listcompressed(long ID2) {
        DownloadController dlc = DownloadController.getInstance();
        for (FilePackage fpkg : dlc.getPackages()) {
            if (fpkg.getUniqueID().getID() != ID2) continue;
            FilePackage filePackage = fpkg;
            synchronized (filePackage) {
                ArrayList<DownloadLinkStorable> links = new ArrayList<DownloadLinkStorable>(fpkg.size());
                for (DownloadLink link : fpkg.getChildren()) {
                    links.add(new DownloadLinkStorable(link));
                }
                String returnValue = JSonStorage.serializeToJson(links);
                try {
                    return Helper.compress(returnValue);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public boolean remove(List<Long> linkIds) {
        return this.dlAPI.removeLinks(linkIds);
    }

    @Override
    public boolean setEnabled(List<Long> linkIds, boolean enabled) {
        if (enabled) {
            return this.dlAPI.enableLinks(linkIds);
        }
        return this.dlAPI.disableLinks(linkIds);
    }

    @Override
    public boolean reset(List<Long> linkIds) {
        List<DownloadLink> list = Helper.getFilteredDownloadLinks(linkIds);
        if (list != null && !list.isEmpty()) {
            DownloadWatchDog.getInstance().reset(list);
        }
        return true;
    }

    @Override
    public DownloadLinkInfoStorable getInformation(long ID2) {
        DownloadLink link = Helper.getDownloadLinkFromID(ID2);
        return new DownloadLinkInfoStorable(link);
    }

    @Override
    public DownloadLinkStorable getDownloadLink(long ID2) {
        DownloadLink link = Helper.getDownloadLinkFromID(ID2);
        return new DownloadLinkStorable(link);
    }

    @Override
    public boolean setPriority(List<Long> linkIds, int priority) {
        List<DownloadLink> list = Helper.getFilteredDownloadLinks(linkIds);
        if (list != null && !list.isEmpty()) {
            for (DownloadLink dl : list) {
                dl.setPriorityEnum(Priority.getPriority(priority));
            }
        }
        return true;
    }

    @Override
    public boolean forceDownload(List<Long> linkIds) {
        return this.dlAPI.forceDownload(linkIds);
    }
}

