/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.JSonStorage;
import org.jdownloader.api.jdanywhere.api.Helper;
import org.jdownloader.api.jdanywhere.api.interfaces.IFilePackageApi;
import org.jdownloader.api.jdanywhere.api.storable.FilePackageInfoStorable;
import org.jdownloader.api.jdanywhere.api.storable.FilePackageStorable;
import org.jdownloader.controlling.Priority;

public class FilePackageApi
implements IFilePackageApi {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FilePackageStorable> list() {
        DownloadController dlc = DownloadController.getInstance();
        boolean b = dlc.readLock();
        try {
            ArrayList<FilePackageStorable> ret = new ArrayList<FilePackageStorable>(dlc.size());
            for (FilePackage fpkg : dlc.getPackages()) {
                ret.add(new FilePackageStorable(fpkg));
            }
            ArrayList<FilePackageStorable> arrayList = ret;
            return arrayList;
        }
        finally {
            dlc.readUnlock(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] listcompressed() {
        DownloadController dlc = DownloadController.getInstance();
        boolean b = dlc.readLock();
        try {
            ArrayList<FilePackageStorable> ret = new ArrayList<FilePackageStorable>(dlc.size());
            for (FilePackage fpkg : dlc.getPackages()) {
                ret.add(new FilePackageStorable(fpkg));
            }
            String returnValue = JSonStorage.serializeToJson(ret);
            byte[] byArray = Helper.compress(returnValue);
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            dlc.readUnlock(b);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FilePackageStorable> listRanges(int startWith, int maxResults) {
        DownloadController dlc = DownloadController.getInstance();
        boolean b = dlc.readLock();
        try {
            ArrayList<FilePackageStorable> ret = new ArrayList<FilePackageStorable>(dlc.size());
            if (startWith > dlc.size() - 1) {
                ArrayList<FilePackageStorable> arrayList = ret;
                return arrayList;
            }
            if (startWith < 0) {
                startWith = 0;
            }
            if (maxResults < 0) {
                maxResults = dlc.size();
            }
            for (int i = startWith; i < Math.min(startWith + maxResults, dlc.size()); ++i) {
                FilePackage fpkg = dlc.getPackages().get(i);
                ret.add(new FilePackageStorable(fpkg));
            }
            ArrayList<FilePackageStorable> arrayList = ret;
            return arrayList;
        }
        finally {
            dlc.readUnlock(b);
        }
    }

    @Override
    public String getIDFromLinkID(long ID2) {
        DownloadLink dl = Helper.getDownloadLinkFromID(ID2);
        FilePackage fpk = dl.getFilePackage();
        return fpk.getUniqueID().toString();
    }

    @Override
    public boolean remove(long ID2) {
        FilePackage fpkg = Helper.getFilePackageFromID(ID2);
        if (fpkg != null) {
            DownloadController.getInstance().removePackage(fpkg);
        }
        return true;
    }

    @Override
    public boolean setEnabled(long ID2, boolean enabled) {
        FilePackage fpkg = Helper.getFilePackageFromID(ID2);
        for (DownloadLink link : fpkg.getChildren()) {
            link.setEnabled(enabled);
        }
        return true;
    }

    @Override
    public boolean priority(long ID2, int priority) {
        FilePackage fpkg = Helper.getFilePackageFromID(ID2);
        if (fpkg != null) {
            for (DownloadLink link : fpkg.getChildren()) {
                link.setPriorityEnum(Priority.getPriority(priority));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean reset(long ID2) {
        FilePackage fpkg = Helper.getFilePackageFromID(ID2);
        DownloadWatchDog.getInstance().reset(fpkg.getChildren());
        return true;
    }

    @Override
    public boolean forceDownload(long ID2) {
        FilePackage fpkg = Helper.getFilePackageFromID(ID2);
        if (fpkg != null) {
            DownloadWatchDog dwd = DownloadWatchDog.getInstance();
            List<DownloadLink> sdl = fpkg.getChildren();
            dwd.forceDownload(sdl);
            return true;
        }
        return false;
    }

    @Override
    public FilePackageInfoStorable getInformation(long ID2) {
        FilePackage fpkg = Helper.getFilePackageFromID(ID2);
        return new FilePackageInfoStorable(fpkg);
    }

    @Override
    public FilePackageStorable getFilePackage(long ID2) {
        FilePackage fpkg = Helper.getFilePackageFromID(ID2);
        return new FilePackageStorable(fpkg);
    }
}

