/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api.storable;

import jd.plugins.DownloadLink;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.jdownloader.api.jdanywhere.JDAnywhereAPI;
import org.jdownloader.api.jdanywhere.api.Helper;
import org.jdownloader.api.jdanywhere.api.storable.LinkStatusJobStorable;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.plugins.FinalLinkState;

@StorableValidatorIgnoresMissingSetter
public class DownloadLinkStorable
implements Storable {
    private boolean _messageIsCountdown = false;
    private DownloadLink link;
    private JsonMap infoMap = null;

    public long getId() {
        if (this.link == null) {
            return 0L;
        }
        return this.link.getUniqueID().getID();
    }

    public long getUUID() {
        if (this.link == null) {
            return 0L;
        }
        return this.link.getUniqueID().getID();
    }

    public String getName() {
        if (this.link == null) {
            return null;
        }
        return this.link.getView().getDisplayName();
    }

    public JsonMap getInfoMap() {
        return this.infoMap;
    }

    public String getHost() {
        if (this.link == null) {
            return null;
        }
        return this.link.getHost();
    }

    public DownloadLinkStorable() {
        this.link = null;
    }

    public String getOnlinestatus() {
        if (this.link == null) {
            return null;
        }
        return this.link.getAvailableStatus().toString();
    }

    public long getSize() {
        if (this.link == null) {
            return -1L;
        }
        return this.link.getView().getBytesTotal();
    }

    public long getDone() {
        if (this.link == null) {
            return -1L;
        }
        return this.link.getView().getBytesLoaded();
    }

    public boolean isEnabled() {
        if (this.link == null) {
            return true;
        }
        return this.link.isEnabled();
    }

    public long getSpeed() {
        if (this.link == null) {
            return 0L;
        }
        return this.link.getView().getSpeedBps();
    }

    public long getAdded() {
        if (this.link == null) {
            return -1L;
        }
        return this.link.getCreated();
    }

    public long getFinished() {
        if (this.link == null) {
            return -1L;
        }
        return this.link.getFinishedDate();
    }

    public int getPriority() {
        if (this.link == null) {
            return 0;
        }
        return this.link.getPriorityEnum().getId();
    }

    public int getChunks() {
        if (this.link == null) {
            return 0;
        }
        return this.link.getChunks();
    }

    public LinkStatusJobStorable getLinkStatus() {
        if (this.link == null) {
            return null;
        }
        LinkStatusJobStorable lsj = new LinkStatusJobStorable();
        lsj.setFinished(FinalLinkState.CheckFinished(this.link.getFinalLinkState()));
        lsj.setInProgress(this.link.getDownloadLinkController() != null);
        lsj.setLinkID(this.link.getUniqueID().toString());
        if (!JDAnywhereAPI.getInstance().events.CheckForProgressMsg(this.link)) {
            lsj.setStatusText(Helper.getMessage(this.link));
        } else {
            lsj.setStatusText("Countdown running");
            this._messageIsCountdown = true;
        }
        if (this.link.isEnabled()) {
            lsj.setStatus(1);
        } else {
            lsj.setStatus(0);
        }
        return lsj;
    }

    public DownloadLinkStorable(DownloadLink link) {
        this.link = link;
    }

    public boolean getMessageIsCountdown() {
        return this._messageIsCountdown;
    }
}

