/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api.storable;

import java.util.ArrayList;
import java.util.List;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;

@StorableValidatorIgnoresMissingSetter
public class FilePackageInfoStorable
implements Storable {
    private FilePackage pkg;

    public String getName() {
        return this.pkg.getName();
    }

    public String getComment() {
        String comment = this.pkg.getComment();
        if (comment == null || comment.length() == 0) {
            return "";
        }
        return comment;
    }

    public String getDirectory() {
        return this.pkg.getView().getDownloadDirectory();
    }

    public String getPassword() {
        String password = "---";
        for (DownloadLink link : this.pkg.getChildren()) {
            if (password == null || password.length() == 0 || password.equals("---")) {
                password = link.getDownloadPassword();
                continue;
            }
            if (link.getDownloadPassword().equals(password)) continue;
            return "";
        }
        if (password == null || password.length() == 0 || password.equals("---")) {
            return "";
        }
        return password;
    }

    public List<String> getHoster() {
        ArrayList<String> links = new ArrayList<String>(this.pkg.size());
        for (DownloadLink link : this.pkg.getChildren()) {
            if (links.contains(link.getHost())) continue;
            links.add(link.getHost());
        }
        return links;
    }

    @StorableAllowPrivateAccessModifier
    private FilePackageInfoStorable() {
    }

    public FilePackageInfoStorable(FilePackage pkg) {
        this.pkg = pkg;
    }
}

