/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.linkcollector.v2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.CrawledLinkModifiers;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.CrawledPackageView;
import jd.controlling.linkcrawler.modifier.CommentModifier;
import jd.controlling.linkcrawler.modifier.DownloadFolderModifier;
import jd.controlling.linkcrawler.modifier.PackageNameModifier;
import jd.plugins.DecrypterRetryException;
import jd.plugins.DownloadLink;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.content.v2.ContentAPIImplV2;
import org.jdownloader.api.linkcollector.v2.AddLinksQueryStorable;
import org.jdownloader.api.linkcollector.v2.CrawledLinkAPIStorableV2;
import org.jdownloader.api.linkcollector.v2.CrawledLinkQueryStorable;
import org.jdownloader.api.linkcollector.v2.CrawledPackageAPIStorableV2;
import org.jdownloader.api.linkcollector.v2.CrawledPackageQueryStorable;
import org.jdownloader.api.linkcollector.v2.JobLinkCrawlerAPIStorable;
import org.jdownloader.api.linkcollector.v2.LinkCollectingJobAPIStorable;
import org.jdownloader.api.linkcollector.v2.LinkCollectorAPIV2;
import org.jdownloader.api.linkcollector.v2.LinkCrawlerJobsQueryStorable;
import org.jdownloader.api.linkcollector.v2.LinkVariantStorableV2;
import org.jdownloader.api.utils.PackageControllerUtils;
import org.jdownloader.api.utils.SelectionInfoUtils;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.linkcrawler.LinkVariant;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.gui.packagehistorycontroller.DownloadPathHistoryManager;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.bindings.CleanupActionOptions;
import org.jdownloader.myjdownloader.client.bindings.PriorityStorable;
import org.jdownloader.myjdownloader.client.bindings.UrlDisplayTypeStorable;
import org.jdownloader.myjdownloader.client.bindings.interfaces.LinkgrabberInterface;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.settings.GeneralSettings;

public class LinkCollectorAPIImplV2
implements LinkCollectorAPIV2 {
    private LogSource logger;
    private final PackageControllerUtils<CrawledPackage, CrawledLink> packageControllerUtils;

    public LinkCollectorAPIImplV2() {
        RemoteAPIController.validateInterfaces(LinkCollectorAPIV2.class, LinkgrabberInterface.class);
        this.packageControllerUtils = new PackageControllerUtils<CrawledPackage, CrawledLink>(LinkCollector.getInstance());
        this.logger = LogController.getInstance().getLogger(LinkCollectorAPIImplV2.class.getName());
    }

    @Override
    public void setComment(long[] linkIds, long[] packageIds, boolean allPackageLinks, String comment) throws BadParameterException {
        this.packageControllerUtils.setComment(linkIds, packageIds, allPackageLinks, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<CrawledPackageAPIStorableV2> queryPackages(CrawledPackageQueryStorable queryParams) throws BadParameterException {
        ArrayList<CrawledPackageAPIStorableV2> result = new ArrayList<CrawledPackageAPIStorableV2>();
        LinkCollector lc = LinkCollector.getInstance();
        List<Object> packages = queryParams.getPackageUUIDs() != null && queryParams.getPackageUUIDs().length > 0 ? this.packageControllerUtils.getPackages(queryParams.getPackageUUIDs()) : lc.getPackagesCopy();
        if (packages.size() == 0) {
            return result;
        }
        int startWith = queryParams.getStartAt();
        int maxResults = queryParams.getMaxResults();
        if (startWith > packages.size() - 1) {
            return result;
        }
        if (startWith < 0) {
            startWith = 0;
        }
        if (maxResults < 0) {
            maxResults = packages.size();
        }
        for (int i = startWith; i < startWith + maxResults; ++i) {
            CrawledPackage pkg = (CrawledPackage)packages.get(i);
            boolean readL = pkg.getModifyLock().readLock();
            try {
                CrawledPackageAPIStorableV2 cps = new CrawledPackageAPIStorableV2(pkg);
                CrawledPackageView view = new CrawledPackageView(pkg);
                view.aggregate();
                if (queryParams.isSaveTo()) {
                    cps.setSaveTo(LinkTreeUtils.getDownloadDirectory(pkg).toString());
                }
                if (queryParams.isBytesTotal()) {
                    cps.setBytesTotal(view.getFileSize());
                }
                if (queryParams.isChildCount()) {
                    cps.setChildCount(view.size());
                }
                if (queryParams.isPriority()) {
                    cps.setPriority(PriorityStorable.get(pkg.getPriorityEnum().name()));
                }
                if (queryParams.isHosts()) {
                    HashSet<String> hosts = new HashSet<String>();
                    for (CrawledLink cl : pkg.getChildren()) {
                        hosts.add(cl.getHost());
                    }
                    cps.setHosts(hosts.toArray(new String[0]));
                }
                if (queryParams.isComment()) {
                    cps.setComment(pkg.getComment());
                }
                if (queryParams.isAvailableOfflineCount() || queryParams.isAvailableOnlineCount() || queryParams.isAvailableTempUnknownCount() || queryParams.isAvailableUnknownCount()) {
                    int onlineCount = 0;
                    int offlineCount = 0;
                    int tempUnknown = 0;
                    int unknown = 0;
                    for (CrawledLink cl : pkg.getChildren()) {
                        switch (cl.getLinkState()) {
                            case OFFLINE: {
                                ++offlineCount;
                                break;
                            }
                            case ONLINE: {
                                ++onlineCount;
                                break;
                            }
                            case TEMP_UNKNOWN: {
                                ++tempUnknown;
                                break;
                            }
                            case UNKNOWN: {
                                ++unknown;
                            }
                        }
                        if (queryParams.isAvailableOfflineCount()) {
                            cps.setOfflineCount(offlineCount);
                        }
                        if (queryParams.isAvailableOnlineCount()) {
                            cps.setOnlineCount(onlineCount);
                        }
                        if (queryParams.isAvailableTempUnknownCount()) {
                            cps.setTempUnknownCount(tempUnknown);
                        }
                        if (!queryParams.isAvailableUnknownCount()) continue;
                        cps.setUnknownCount(unknown);
                    }
                }
                if (queryParams.isEnabled()) {
                    boolean enabled = false;
                    for (CrawledLink dl : pkg.getChildren()) {
                        if (!dl.isEnabled()) continue;
                        enabled = true;
                        break;
                    }
                    cps.setEnabled(enabled);
                }
                result.add(cps);
                if (i != packages.size() - 1) continue;
                break;
            }
            finally {
                pkg.getModifyLock().readUnlock(readL);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ArrayList<CrawledLinkAPIStorableV2> queryLinks(CrawledLinkQueryStorable queryParams) throws BadParameterException {
        void var7_14;
        ArrayList<CrawledLinkAPIStorableV2> result = new ArrayList<CrawledLinkAPIStorableV2>();
        LinkCollector lc = LinkCollector.getInstance();
        ArrayList<CrawledLink> links = new ArrayList<CrawledLink>();
        if (queryParams.getLinkUUIDs() != null && queryParams.getLinkUUIDs().length > 0) {
            links.addAll(this.packageControllerUtils.getChildren(queryParams.getLinkUUIDs()));
        } else {
            List<Object> matched = queryParams.getPackageUUIDs() != null && queryParams.getPackageUUIDs().length > 0 ? this.packageControllerUtils.getPackages(queryParams.getPackageUUIDs()) : lc.getPackagesCopy();
            if (queryParams.getJobUUIDs() != null && queryParams.getJobUUIDs().length > 0) {
                HashSet jobUUIDs = new HashSet();
                for (long id : queryParams.getJobUUIDs()) {
                    jobUUIDs.add(id);
                }
                for (CrawledPackage pkg : matched) {
                    boolean readL = pkg.getModifyLock().readLock();
                    try {
                        for (CrawledLink link : pkg.getChildren()) {
                            if (!jobUUIDs.contains(link.getJobID())) continue;
                            links.add(link);
                        }
                    }
                    finally {
                        pkg.getModifyLock().readUnlock(readL);
                    }
                }
            } else {
                for (CrawledPackage crawledPackage : matched) {
                    boolean readL = crawledPackage.getModifyLock().readLock();
                    try {
                        links.addAll(crawledPackage.getChildren());
                    }
                    finally {
                        crawledPackage.getModifyLock().readUnlock(readL);
                    }
                }
            }
        }
        if (links.isEmpty()) {
            return result;
        }
        int startWith = queryParams.getStartAt();
        int maxResults = queryParams.getMaxResults();
        if (startWith > links.size() - 1) {
            return result;
        }
        if (startWith < 0) {
            startWith = 0;
        }
        if (maxResults < 0) {
            maxResults = links.size();
        }
        int n = startWith;
        while (var7_14 < Math.min(startWith + maxResults, links.size())) {
            CrawledLink cl = (CrawledLink)links.get((int)var7_14);
            CrawledLinkAPIStorableV2 cls = LinkCollectorAPIImplV2.toStorable(queryParams, cl, this);
            result.add(cls);
            ++var7_14;
        }
        return result;
    }

    public static CrawledLinkAPIStorableV2 setStatus(CrawledLinkAPIStorableV2 cls, CrawledLink link, Object caller) {
        JsonMap advancedStatus = new JsonMap();
        cls.setAdvancedStatus(advancedStatus);
        DownloadLink dl = link.getDownloadLink();
        DownloadLink.AvailableStatus availableStatus = dl != null ? dl.getAvailableStatus() : DownloadLink.AvailableStatus.UNCHECKED;
        HashMap<String, String> entry = new HashMap<String, String>();
        switch (availableStatus) {
            case FALSE: {
                entry.put("iconKey", "error");
                break;
            }
            case TRUE: {
                entry.put("iconKey", "true");
                break;
            }
            case UNCHECKABLE: 
            case UNCHECKED: {
                entry.put("iconKey", "help");
            }
        }
        entry.put("label", availableStatus.getExplanation());
        entry.put("id", availableStatus.name());
        advancedStatus.put("AvailableStatus", entry);
        if ("linkcrawlerretry".equals(link.getHost())) {
            dl = link.getDownloadLink();
            String reason = dl != null ? dl.getStringProperty("reason", null) : null;
            entry = new HashMap();
            try {
                if (reason != null) {
                    entry.put("id", reason);
                    entry.put("label", DecrypterRetryException.RetryReason.valueOf(reason).getExplanation(caller));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            advancedStatus.put("LinkCrawlerRetry", entry);
        }
        return cls;
    }

    public static CrawledLinkAPIStorableV2 toStorable(CrawledLinkQueryStorable queryParams, CrawledLink cl, Object caller) {
        CrawledLinkAPIStorableV2 cls = new CrawledLinkAPIStorableV2(cl);
        ContentAPIImplV2 contentAPI = RemoteAPIController.getInstance().getContentAPI();
        if (queryParams.isPassword() && cl.getDownloadLink() != null) {
            cls.setDownloadPassword(cl.getDownloadLink().getDownloadPassword());
        }
        if (queryParams.isPriority()) {
            cls.setPriority(PriorityStorable.get(cl.getPriority().name()));
        }
        if (queryParams.isVariantID() || queryParams.isVariantName() || queryParams.isVariantIcon() || queryParams.isVariants()) {
            try {
                if (cl.hasVariantSupport()) {
                    if (queryParams.isVariants()) {
                        cls.setVariants(true);
                    }
                    if (queryParams.isVariantID() || queryParams.isVariantName() || queryParams.isVariantIcon()) {
                        LinkVariant v = cl.getDownloadLink().getDefaultPlugin().getActiveVariantByLink(cl.getDownloadLink());
                        LinkVariantStorableV2 s = new LinkVariantStorableV2();
                        if (v != null) {
                            Icon icon;
                            if (queryParams.isVariantID()) {
                                s.setId(v._getUniqueId());
                            }
                            if (queryParams.isVariantName()) {
                                s.setName(v._getName(cl));
                            }
                            if (queryParams.isVariantIcon() && (icon = v._getIcon(cl)) != null) {
                                s.setIconKey(contentAPI.getIconKey(icon));
                            }
                        }
                        cls.setVariant(s);
                    }
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
        if (queryParams.isAdvancedStatus()) {
            LinkCollectorAPIImplV2.setStatus(cls, cl, caller);
        }
        if (queryParams.isJobUUID()) {
            cls.setJobUUID(cl.getJobID());
        }
        if (queryParams.isComment()) {
            cls.setComment(cl.getComment());
        }
        if (queryParams.isBytesTotal()) {
            cls.setBytesTotal(cl.getSize());
        }
        if (queryParams.isHost()) {
            cls.setHost(cl.getHost());
        }
        if (queryParams.isAvailability()) {
            cls.setAvailability(cl.getLinkState());
        }
        if (queryParams.isUrl()) {
            cls.setUrl(cl.getURL());
        }
        if (queryParams.isAddedDate()) {
            cls.setAddedDate(cl.getCreated());
        }
        if (queryParams.isEnabled()) {
            cls.setEnabled(cl.isEnabled());
        }
        cls.setPackageUUID(cl.getParentNode().getUniqueID().getID());
        return cls;
    }

    @Override
    public int getPackageCount() {
        return LinkCollector.getInstance().size();
    }

    @Override
    public LinkCollectingJobAPIStorable addLinks(AddLinksQueryStorable query) {
        return LinkCollectorAPIImplV2.add(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File probeZipFile(File zipFile) throws IOException {
        FileInputStream fis = new FileInputStream(zipFile);
        try {
            ZipEntry entry;
            boolean downloadList = false;
            boolean linkcollectorList = false;
            ZipInputStream zis = new ZipInputStream(fis);
            while ((entry = zis.getNextEntry()) != null) {
                Map map;
                if (!entry.getName().matches("^\\d+$") || (map = (Map)JSonStorage.restoreFromInputStream((InputStream)new FilterInputStream(zis){

                    @Override
                    public void close() throws IOException {
                    }
                }, (TypeRef)TypeRef.MAP)) == null) continue;
                Object probe = map.get("type");
                if (probe != null && probe instanceof String) {
                    try {
                        CrawledPackage.TYPE.valueOf(probe.toString());
                        linkcollectorList = true;
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if ((probe = map.get("priority")) != null && probe instanceof String) {
                    try {
                        Priority.valueOf(probe.toString());
                        linkcollectorList = true;
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                downloadList = true;
                break;
            }
            zis.close();
            File importFile = downloadList ? new File(zipFile.getParent(), "downloadList" + Time.getNanoSeconds() + ".zip") : (linkcollectorList ? new File(zipFile.getParent(), "linkcollector" + Time.getNanoSeconds() + ".zip") : null);
            if (importFile != null) {
                if (zipFile.renameTo(importFile)) {
                    File file = importFile;
                    return file;
                }
                throw new IOException("could not rename " + zipFile + " to " + importFile);
            }
        }
        finally {
            fis.close();
        }
        throw new IOException("Unsupported zip file:" + zipFile);
    }

    private static File probeDataURLFile(File file, String extension) throws IOException {
        if ("crawljob".equalsIgnoreCase(extension)) {
            return file;
        }
        if ("nzb".equalsIgnoreCase(extension)) {
            return file;
        }
        if ("ccf".equalsIgnoreCase(extension) || "dlc".equalsIgnoreCase(extension) || "rsdf".equalsIgnoreCase(extension) || "sft".equalsIgnoreCase(extension) || "sfdl".equalsIgnoreCase(extension)) {
            return file;
        }
        if ("metalink".equalsIgnoreCase(extension) || "meta4".equalsIgnoreCase(extension)) {
            return file;
        }
        if ("zip".equalsIgnoreCase(extension) || "backup".equalsIgnoreCase(extension)) {
            return LinkCollectorAPIImplV2.probeZipFile(file);
        }
        throw new IOException("Unsupported file extension:" + extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> processDataURLs(AddLinksQueryStorable query) {
        ArrayList<File> ret = new ArrayList<File>();
        String[] dataURLs = query.getDataURLs();
        if (dataURLs != null) {
            for (String dataURL : dataURLs) {
                String extension = new Regex(dataURL, "data:application/([a-z0-9A-Z]{1,4})").getMatch(0);
                if (extension == null) continue;
                File tmp = Application.getTempResource((String)("uploads/linkcollectorAPI" + System.nanoTime() + "." + extension));
                try {
                    if (tmp.exists() && !tmp.delete()) {
                        throw new IOException("Failed to delete tmp file:" + tmp);
                    }
                    if (!tmp.getParentFile().exists() && !tmp.getParentFile().mkdirs()) {
                        throw new IOException("Failed to create tmp folder:" + tmp.getParentFile());
                    }
                    InputStream is = IO.dataUrlToInputStream((String)dataURL);
                    FileOutputStream fos = new FileOutputStream(tmp);
                    try {
                        byte[] buf = new byte[8192];
                        int read = 0;
                        while ((read = is.read(buf)) != -1) {
                            fos.write(buf, 0, read);
                        }
                    }
                    finally {
                        fos.close();
                    }
                    File dataURLFile = LinkCollectorAPIImplV2.probeDataURLFile(tmp, extension);
                    if (dataURLFile != null) {
                        ret.add(dataURLFile);
                        continue;
                    }
                    tmp.delete();
                }
                catch (IOException e) {
                    tmp.delete();
                    LogController.getInstance().getLogger(LinkCollectorAPIImplV2.class.getName()).log((Throwable)e);
                }
            }
            query.setDataURLs(null);
        }
        return ret;
    }

    public static LinkCollectingJobAPIStorable add(final AddLinksQueryStorable query) {
        ArrayList<String> finalExtPws;
        List<File> files;
        Priority p = Priority.DEFAULT;
        try {
            p = Priority.valueOf(query.getPriority().name());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        final Priority fp = p;
        StringBuilder sb = new StringBuilder();
        if (query.getLinks() != null) {
            sb.append(query.getLinks());
            query.setLinks(null);
        }
        if ((files = LinkCollectorAPIImplV2.processDataURLs(query)) != null) {
            for (File file : files) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(file.toURI().toString());
            }
        }
        LinkCollectingJob job = new LinkCollectingJob(LinkOrigin.MYJD.getLinkOriginDetails(), sb.toString());
        job.setCustomSourceUrl(query.getSourceUrl());
        job.setAssignJobID(Boolean.TRUE.equals(query.isAssignJobID()));
        boolean overwritePackagizerRules = Boolean.TRUE.equals(query.isOverwritePackagizerRules());
        if (StringUtils.isNotEmpty((String)query.getExtractPassword())) {
            finalExtPws = new ArrayList<String>();
            finalExtPws.add(query.getExtractPassword());
        } else {
            finalExtPws = null;
        }
        ArrayList<CrawledLinkModifier> modifiers = new ArrayList<CrawledLinkModifier>();
        ArrayList<CrawledLinkModifier> requiredPreModifiers = new ArrayList<CrawledLinkModifier>();
        if (StringUtils.isNotEmpty((String)query.getComment())) {
            modifiers.add(new CommentModifier(query.getComment()));
        }
        if (StringUtils.isNotEmpty((String)query.getPackageName())) {
            PackageNameModifier mod = new PackageNameModifier(query.getPackageName(), overwritePackagizerRules);
            modifiers.add(mod);
            requiredPreModifiers.add(mod);
        }
        if (StringUtils.isNotEmpty((String)query.getDestinationFolder())) {
            modifiers.add(new DownloadFolderModifier(query.getDestinationFolder(), overwritePackagizerRules));
        }
        if (StringUtils.isNotEmpty((String)query.getDownloadPassword())) {
            modifiers.add(new CrawledLinkModifier(){
                final String downloadPassword;
                {
                    this.downloadPassword = query.getDownloadPassword();
                }

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    DownloadLink dlLink = link.getDownloadLink();
                    if (dlLink != null) {
                        dlLink.setDownloadPassword(this.downloadPassword);
                        return true;
                    }
                    return false;
                }
            });
        }
        if (query.isAutostart() != null) {
            final boolean autostart = Boolean.TRUE.equals(query.isAutostart());
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.setAutoConfirmEnabled(autostart);
                    link.setAutoStartEnabled(autostart);
                    return true;
                }
            });
        }
        if (finalExtPws != null && finalExtPws.size() > 0) {
            job.setArchivPasswords(finalExtPws);
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.getArchiveInfo().getExtractionPasswords().addAll(finalExtPws);
                    return true;
                }
            });
        }
        if (query.isAutoExtract() != null) {
            modifiers.add(new CrawledLinkModifier(){
                final BooleanStatus autoExtract;
                {
                    this.autoExtract = BooleanStatus.convert((Boolean)query.isAutoExtract());
                }

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.getArchiveInfo().setAutoExtract(this.autoExtract);
                    return true;
                }
            });
        }
        if (!Priority.DEFAULT.equals((Object)fp)) {
            modifiers.add(new CrawledLinkModifier(){

                @Override
                public boolean modifyCrawledLink(CrawledLink link) {
                    link.setPriority(fp);
                    return true;
                }
            });
        }
        switch (BooleanStatus.convert((Boolean)query.isDeepDecrypt())) {
            case TRUE: {
                job.setDeepAnalyse(true);
                break;
            }
            case FALSE: {
                job.setDeepAnalyse(false);
                break;
            }
        }
        if (modifiers.size() > 0) {
            if (overwritePackagizerRules) {
                job.addPrePackagizerModifier(new CrawledLinkModifiers(requiredPreModifiers));
                job.addPostPackagizerModifier(new CrawledLinkModifiers(modifiers));
            } else {
                job.addPrePackagizerModifier(new CrawledLinkModifiers(modifiers));
            }
        }
        LinkCollector.getInstance().getAddLinksThread(job, null).start();
        return new LinkCollectingJobAPIStorable(job);
    }

    @Override
    public long getChildrenChanged(long structureWatermark) {
        return this.packageControllerUtils.getChildrenChanged(structureWatermark);
    }

    @Override
    public void moveToDownloadlist(long[] linkIds, long[] packageIds) throws BadParameterException {
        SelectionInfo<CrawledPackage, CrawledLink> selectionInfo = this.packageControllerUtils.getSelectionInfo(linkIds, packageIds);
        LinkCollector.getInstance().moveLinksToDownloadList(selectionInfo, new LinkCollector.ConfirmLinksSettings(LinkCollector.MoveLinksMode.MANUAL));
    }

    @Override
    public void removeLinks(long[] linkIds, long[] packageIds) throws BadParameterException {
        this.packageControllerUtils.remove(linkIds, packageIds);
    }

    @Override
    public void renameLink(long linkId, String newName) throws BadParameterException {
        List<CrawledLink> children = this.packageControllerUtils.getChildren(linkId);
        if (children.size() > 0) {
            children.get(0).setName(newName);
        }
    }

    @Override
    public void renamePackage(long packageId, String newName) throws BadParameterException {
        CrawledPackage lc;
        List<CrawledPackage> selectionInfo = this.packageControllerUtils.getPackages(packageId);
        if (selectionInfo.size() > 0 && (lc = selectionInfo.get(0)) != null) {
            lc.setName(newName);
        }
    }

    @Override
    public void setEnabled(boolean enabled, long[] linkIds, long[] packageIds) throws BadParameterException {
        this.packageControllerUtils.setEnabled(enabled, linkIds, packageIds);
    }

    @Override
    public void movePackages(long[] packageIds, long afterDestPackageId) throws BadParameterException {
        this.packageControllerUtils.movePackages(packageIds, afterDestPackageId);
    }

    @Override
    public void moveLinks(long[] linkIds, long afterLinkID, long destPackageID) throws BadParameterException {
        this.packageControllerUtils.moveChildren(linkIds, afterLinkID, destPackageID);
    }

    @Override
    public List<String> getDownloadFolderHistorySelectionBase() {
        return DownloadPathHistoryManager.getInstance().listPaths(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder());
    }

    @Override
    public List<LinkVariantStorableV2> getVariants(long linkid) throws BadParameterException {
        ArrayList<LinkVariantStorableV2> ret = new ArrayList<LinkVariantStorableV2>();
        List<CrawledLink> children = this.packageControllerUtils.getChildren(linkid);
        if (children.size() > 0) {
            CrawledLink cl = children.get(0);
            for (LinkVariant linkVariant : cl.getDownloadLink().getDefaultPlugin().getVariantsByLink(cl.getDownloadLink())) {
                ret.add(new LinkVariantStorableV2(linkVariant._getUniqueId(), linkVariant._getName(cl)));
            }
        }
        return ret;
    }

    @Override
    public void setVariant(long linkid, String variantID) throws BadParameterException {
        CrawledLink cl;
        List<CrawledLink> children = this.packageControllerUtils.getChildren(linkid);
        if (children.size() > 0 && (cl = children.get(0)) != null) {
            for (LinkVariant linkVariant : cl.getDownloadLink().getDefaultPlugin().getVariantsByLink(cl.getDownloadLink())) {
                if (!linkVariant._getUniqueId().equals(variantID)) continue;
                LinkCollector.getInstance().setActiveVariantForLink(cl, linkVariant);
                return;
            }
            throw new BadParameterException("Unknown variantID");
        }
    }

    @Override
    public void addVariantCopy(long linkid, final long destinationAfterLinkID, final long destinationPackageID, final String variantID) throws BadParameterException {
        CrawledLink link;
        List<CrawledLink> children = this.packageControllerUtils.getChildren(linkid);
        if (children.size() > 0 && (link = children.get(0)) != null) {
            LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Void, BadParameterException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void run() throws BadParameterException {
                    LinkVariant v = null;
                    for (LinkVariant linkVariant : link.getDownloadLink().getDefaultPlugin().getVariantsByLink(link.getDownloadLink())) {
                        if (!linkVariant._getUniqueId().equals(variantID)) continue;
                        v = linkVariant;
                        break;
                    }
                    if (v == null) {
                        throw new BadParameterException("Unknown variantID");
                    }
                    DownloadLink dllink = new DownloadLink(link.getDownloadLink().getDefaultPlugin(), link.getDownloadLink().getView().getDisplayName(), link.getDownloadLink().getHost(), link.getDownloadLink().getPluginPatternMatcher(), true);
                    dllink.setProperties(link.getDownloadLink().getProperties());
                    CrawledLink crawledLink = new CrawledLink(dllink);
                    ArrayList<CrawledLink> list = new ArrayList<CrawledLink>();
                    list.add(crawledLink);
                    crawledLink.getDownloadLink().getDefaultPlugin().setActiveVariantByLink(crawledLink.getDownloadLink(), v);
                    boolean readL = link.getParentNode().getModifyLock().readLock();
                    try {
                        for (CrawledLink cLink : link.getParentNode().getChildren()) {
                            if (!dllink.getLinkID().equals(cLink.getLinkID())) continue;
                            throw new BadParameterException("Variant is already in this package");
                        }
                    }
                    finally {
                        link.getParentNode().getModifyLock().readUnlock(readL);
                    }
                    if (destinationPackageID < 0L) {
                        LinkCollector.getInstance().moveOrAddAt(link.getParentNode(), list, link.getParentNode().indexOf(link) + 1);
                    } else {
                        List packages;
                        List children;
                        LinkCollector dlc = LinkCollector.getInstance();
                        CrawledLink afterLink = null;
                        CrawledPackage destpackage = null;
                        if (destinationAfterLinkID > 0L && (children = LinkCollectorAPIImplV2.this.packageControllerUtils.getChildren(destinationAfterLinkID)).size() > 0) {
                            afterLink = (CrawledLink)children.get(0);
                        }
                        if (destinationPackageID > 0L && (packages = LinkCollectorAPIImplV2.this.packageControllerUtils.getPackages(destinationPackageID)).size() > 0) {
                            destpackage = (CrawledPackage)packages.get(0);
                        }
                        dlc.move(list, destpackage, afterLink);
                    }
                    ArrayList<CrawledLink> checkableLinks = new ArrayList<CrawledLink>(1);
                    checkableLinks.add(crawledLink);
                    LinkChecker<ArrayList<CrawledLink>> linkChecker = new LinkChecker<ArrayList<CrawledLink>>(true);
                    linkChecker.check(checkableLinks);
                    return null;
                }
            });
        }
    }

    @Override
    public LinkCollectingJobAPIStorable addContainer(String type, String content) {
        return LinkCollectorAPIImplV2.loadContainer(type, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkCollectingJobAPIStorable loadContainer(String type, String content) {
        if (type != null) {
            File tmp = Application.getTempResource((String)("uploads/linkcollectorAPI" + System.nanoTime() + "." + type));
            try {
                if (tmp.exists() && !tmp.delete()) {
                    throw new IOException("Failed to delete tmp file:" + tmp);
                }
                if (!tmp.getParentFile().exists() && !tmp.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create tmp folder:" + tmp.getParentFile());
                }
                InputStream is = IO.dataUrlToInputStream((String)content);
                FileOutputStream fos = new FileOutputStream(tmp);
                try {
                    byte[] buf = new byte[8192];
                    int read = 0;
                    while ((read = is.read(buf)) != -1) {
                        fos.write(buf, 0, read);
                    }
                }
                finally {
                    fos.close();
                }
                File dataURLFile = LinkCollectorAPIImplV2.probeDataURLFile(tmp, type);
                if (dataURLFile != null) {
                    tmp = dataURLFile;
                    LinkCollectingJob job = new LinkCollectingJob(LinkOrigin.MYJD.getLinkOriginDetails(), dataURLFile.toURI().toString());
                    LinkCollector.getInstance().getAddLinksThread(job, null).start();
                    return new LinkCollectingJobAPIStorable(job);
                }
                tmp.delete();
            }
            catch (IOException e) {
                tmp.delete();
                LogController.getInstance().getLogger(LinkCollectorAPIImplV2.class.getName()).log((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setPriority(PriorityStorable priority, long[] linkIds, long[] packageIds) throws BadParameterException {
        Priority jdPriority = Priority.valueOf(priority.name());
        List<CrawledLink> children = this.packageControllerUtils.getChildren(linkIds);
        List<CrawledPackage> pkgs = this.packageControllerUtils.getPackages(packageIds);
        for (CrawledLink dl : children) {
            dl.setPriority(jdPriority);
        }
        for (CrawledPackage pkg : pkgs) {
            pkg.setPriorityEnum(jdPriority);
        }
    }

    @Override
    public void startOnlineStatusCheck(long[] linkIds, long[] packageIds) throws BadParameterException {
        this.packageControllerUtils.startOnlineStatusCheck(linkIds, packageIds);
    }

    @Override
    public Map<String, List<Long>> getDownloadUrls(long[] linkIds, long[] packageIds, UrlDisplayTypeStorable[] urlDisplayTypes) throws BadParameterException {
        return SelectionInfoUtils.getURLs(this.packageControllerUtils.getSelectionInfo(linkIds, packageIds), SelectionInfoUtils.parse(urlDisplayTypes));
    }

    @Override
    public void movetoNewPackage(long[] linkIds, long[] pkgIds, String newPkgName, String downloadPath) throws BadParameterException {
        this.packageControllerUtils.movetoNewPackage(linkIds, pkgIds, newPkgName, downloadPath);
    }

    @Override
    public void setDownloadDirectory(String directory, long[] packageIds) throws BadParameterException {
        if (StringUtils.isEmpty((String)directory)) {
            throw new BadParameterException("invalid dir");
        }
        this.packageControllerUtils.setDownloadDirectory(directory, packageIds);
    }

    @Override
    public void splitPackageByHoster(long[] linkIds, long[] pkgIds) {
        this.packageControllerUtils.splitPackageByHoster(linkIds, pkgIds);
    }

    @Override
    public void cleanup(long[] linkIds, long[] packageIds, CleanupActionOptions.Action action, CleanupActionOptions.Mode mode, CleanupActionOptions.SelectionType selectionType) throws BadParameterException {
        this.packageControllerUtils.cleanup(linkIds, packageIds, action, mode, selectionType);
    }

    @Override
    public boolean clearList() {
        LinkCollector.getInstance().clear();
        return true;
    }

    @Override
    public boolean setDownloadPassword(long[] linkIds, long[] packageIds, String pass) throws BadParameterException {
        return this.packageControllerUtils.setDownloadPassword(linkIds, packageIds, pass);
    }

    @Override
    public boolean abort() {
        LinkCollector.getInstance().abort();
        return true;
    }

    @Override
    public boolean abort(long jobId) {
        List<LinkCollector.JobLinkCrawler> jobs = LinkCollector.getInstance().getJobLinkCrawlerByJobId(jobId);
        boolean ret = false;
        for (LinkCollector.JobLinkCrawler job : jobs) {
            if (!job.abort()) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean isCollecting() {
        return LinkCollector.getInstance().isCollecting();
    }

    @Override
    public List<JobLinkCrawlerAPIStorable> queryLinkCrawlerJobs(LinkCrawlerJobsQueryStorable query) {
        ArrayList<JobLinkCrawlerAPIStorable> result = new ArrayList<JobLinkCrawlerAPIStorable>();
        if (query.getJobIds() != null) {
            List<LinkCollector.JobLinkCrawler> jobs = LinkCollector.getInstance().getJobLinkCrawlerByJobId(query.getJobIds());
            for (LinkCollector.JobLinkCrawler job : jobs) {
                result.add(new JobLinkCrawlerAPIStorable(query, job));
            }
        }
        return result;
    }
}

