/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.myjdownloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jd.controlling.reconnect.pluginsinc.upnp.cling.StreamClientImpl;
import jd.controlling.reconnect.pluginsinc.upnp.cling.UPNPDeviceScanner;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.utils.Time;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxyUtils;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.fourthline.cling.DefaultUpnpServiceConfiguration;
import org.fourthline.cling.UpnpServiceConfiguration;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.controlpoint.ActionCallback;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.header.UDAServiceTypeHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDAServiceType;
import org.fourthline.cling.model.types.UnsignedIntegerTwoBytes;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.registry.RegistryListener;
import org.fourthline.cling.support.igd.callback.PortMappingAdd;
import org.fourthline.cling.support.igd.callback.PortMappingDelete;
import org.fourthline.cling.support.model.PortMapping;
import org.fourthline.cling.transport.impl.StreamClientConfigurationImpl;
import org.jdownloader.api.DeprecatedAPIServer;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectThread;
import org.jdownloader.api.myjdownloader.MyJDownloaderDirectHttpConnection;
import org.jdownloader.api.myjdownloader.MyJDownloaderSettings;
import org.jdownloader.api.myjdownloader.api.MyJDownloaderAPI;
import org.jdownloader.settings.staticreferences.CFG_MYJD;

public class MyJDownloaderDirectServer
extends Thread
implements ShutdownVetoListener {
    private final AtomicReference<ServerSocket> currentServerSocket = new AtomicReference<Object>(null);
    private final MyJDownloaderConnectThread connectThread;
    private final MyJDownloaderSettings.DIRECTMODE connectMode;
    private final LogSource logger;
    private volatile PortMapping upnpPortMapping = null;
    private volatile Service upnpPortMappingService = null;

    public MyJDownloaderDirectServer(MyJDownloaderConnectThread connectThread, MyJDownloaderSettings.DIRECTMODE connectMode) {
        this.connectThread = connectThread;
        this.connectMode = connectMode;
        this.logger = connectThread.getLogger();
        this.setName("MyJDownloaderDirectServer");
        this.setDaemon(true);
    }

    public MyJDownloaderSettings.DIRECTMODE getConnectMode() {
        return this.connectMode;
    }

    private ServerSocket createServerSocket(int wished) throws IOException {
        ServerSocket currentServerSocket;
        int lastPort = CFG_MYJD.CFG.getLastLocalPort();
        if (lastPort <= 0 || lastPort > 65000) {
            lastPort = 0;
        }
        if (wished > 0 && wished < 65000) {
            lastPort = wished;
        }
        try {
            currentServerSocket = new ServerSocket(lastPort);
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            currentServerSocket = new ServerSocket(0);
        }
        CFG_MYJD.CFG.setLastLocalPort(currentServerSocket.getLocalPort());
        this.currentServerSocket.set(currentServerSocket);
        return currentServerSocket;
    }

    public static boolean sameNetwork(String ip1, InetAddress ip2, InetAddress netMask) {
        try {
            byte[] ip1Bytes = HTTPConnectionUtils.resolvHostIP((String)ip1, (HTTPConnectionUtils.IPVERSION)HTTPConnectionUtils.IPVERSION.IPV4_ONLY)[0].getAddress();
            byte[] ip2Bytes = ip2.getAddress();
            if (ip1Bytes.length != ip2Bytes.length) {
                return false;
            }
            byte[] maskBytes = netMask.getAddress();
            for (int i = 0; i < ip1Bytes.length; ++i) {
                if ((ip1Bytes[i] & maskBytes[i]) == (ip2Bytes[i] & maskBytes[i])) continue;
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private static int randomPort() {
        int min = 1025;
        int max = 65000;
        return new Random().nextInt(63976) + 1025;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupUPNPPort() {
        udaServices = new UDAServiceType[]{new UDAServiceType("WANPPPConnection"), new UDAServiceType("WANIPConnection")};
        upnpService = null;
        try {
            config = new DefaultUpnpServiceConfiguration(){

                public Executor getMulticastReceiverExecutor() {
                    return super.getMulticastReceiverExecutor();
                }

                public Integer getRemoteDeviceMaxAgeSeconds() {
                    return super.getRemoteDeviceMaxAgeSeconds();
                }

                public StreamClientImpl createStreamClient() {
                    return new StreamClientImpl(new StreamClientConfigurationImpl(this.getSyncProtocolExecutorService()));
                }
            };
            upnpService = new UpnpServiceImpl((UpnpServiceConfiguration)config, new RegistryListener[0]);
            updateFlag = new AtomicInteger(0);
            upnpService.getControlPoint().getRegistry().addListener(new RegistryListener(){

                public void remoteDeviceUpdated(Registry var1, RemoteDevice var2) {
                }

                public void remoteDeviceRemoved(Registry var1, RemoteDevice var2) {
                }

                public void remoteDeviceDiscoveryStarted(Registry var1, RemoteDevice var2) {
                }

                public void remoteDeviceDiscoveryFailed(Registry var1, RemoteDevice var2, Exception var3) {
                }

                public void remoteDeviceAdded(Registry var1, RemoteDevice var2) {
                    updateFlag.incrementAndGet();
                }

                public void localDeviceRemoved(Registry var1, LocalDevice var2) {
                    updateFlag.incrementAndGet();
                }

                public void localDeviceAdded(Registry var1, LocalDevice var2) {
                }

                public void beforeShutdown(Registry var1) {
                }

                public void afterShutdown() {
                }
            });
            for (UDAServiceType udaService : udaServices) {
                upnpService.getControlPoint().search((UpnpHeader)new UDAServiceTypeHeader(udaService), 1);
            }
            localIPs = HTTPProxyUtils.getLocalIPs();
            netMask = InetAddress.getByAddress(new byte[]{-1, -1, -1, 0});
            start = Time.systemIndependentCurrentJVMTimeMillis();
            lastUpdate = -1;
lbl15:
            // 2 sources

            while (true) {
                if (this.getLocalPort() > 0 && Time.systemIndependentCurrentJVMTimeMillis() - start <= 300000L) {
                    if (lastUpdate == updateFlag.get()) break;
                    lastUpdate = updateFlag.get();
                    var10_13 = udaServices;
                    var11_14 = var10_13.length;
                } else {
                    UPNPDeviceScanner.shutdown(upnpService);
                    return;
                }
                block8: for (var12_15 = 0; var12_15 < var11_14; ++var12_15) {
                    udaService = var10_13[var12_15];
                    var14_17 = upnpService.getRegistry().getDevices((ServiceType)udaService).iterator();
                    while (true) {
                        if (!var14_17.hasNext()) continue block8;
                        device = (Device)var14_17.next();
                        service = device.findService((ServiceType)udaService);
                        if (service == null || service.getAction("AddPortMapping") == null) continue;
                        deviceIP = null;
                        details = device.getDetails();
                        if (details.getBaseURL() != null) {
                            deviceIP = details.getBaseURL().getHost();
                        } else {
                            identity = device.getIdentity();
                            if (identity instanceof RemoteDeviceIdentity) {
                                remoteIdentity = (RemoteDeviceIdentity)identity;
                                deviceIP = remoteIdentity.getDescriptorURL().getHost();
                            }
                        }
                        if (deviceIP == null) continue;
                        it = localIPs.iterator();
                        localIP = null;
                        while (it.hasNext()) {
                            checkIP = (InetAddress)it.next();
                            if (!(checkIP instanceof Inet4Address) || !MyJDownloaderDirectServer.sameNetwork(deviceIP, checkIP, netMask)) continue;
                            localIP = checkIP;
                            break;
                        }
                        if (localIP == null) continue;
                        this.logger.info("Found Router at '" + deviceIP + "' for " + localIP.getHostAddress());
                        upnpPort = CFG_MYJD.CFG.getLastUpnpPort();
                        portMappingTry = new AtomicInteger(0);
                        do {
                            if (portMappingTry.incrementAndGet() >= 6) ** break;
                            if (portMappingTry.get() > 1 || upnpPort <= 0) {
                                upnpPort = MyJDownloaderDirectServer.randomPort();
                            }
                            upnpPortMapping = new PortMapping(upnpPort, localIP.getHostAddress(), PortMapping.Protocol.TCP, "MyJDownloader");
                            upnpPortMapping.setInternalPort(new UnsignedIntegerTwoBytes((long)this.getLocalPort()));
                            action = new PortMappingAdd(service, upnpPortMapping){

                                public void success(ActionInvocation invocation) {
                                    MyJDownloaderDirectServer.this.upnpPortMapping = upnpPortMapping;
                                    MyJDownloaderDirectServer.this.upnpPortMappingService = service;
                                    MyJDownloaderDirectServer.this.logger.info("PortMappingAdd(" + upnpPortMapping + " successful");
                                    CFG_MYJD.CFG.setLastUpnpPort(upnpPortMapping.getExternalPort().getValue().intValue());
                                }

                                public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                                    MyJDownloaderDirectServer.this.logger.info("PortMappingAdd(" + upnpPortMapping + " failed");
                                }
                            };
                            result = upnpService.getControlPoint().execute((ActionCallback)action);
                            result.get(5L, TimeUnit.SECONDS);
                        } while (this.upnpPortMapping == null);
                        break;
                    }
                    UPNPDeviceScanner.shutdown(upnpService);
                    return;
                }
                break;
            }
        }
        catch (Throwable e) {
            try {
                this.logger.log(e);
                return;
            }
            catch (Throwable var26_30) {
                throw var26_30;
            }
            finally {
                UPNPDeviceScanner.shutdown(upnpService);
            }
        }
        Thread.sleep(1000L);
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ShutdownController.getInstance().addShutdownVetoListener((ShutdownVetoListener)this);
            int lastLocalPort = CFG_MYJD.CFG.getLastLocalPort();
            switch (this.connectMode) {
                case LAN: {
                    this.createServerSocket(-1);
                    this.logger.info("MyJDownloaderDirectConnectionServer: Mode=" + (Object)((Object)this.connectMode) + " LocalPort=" + this.getLocalPort() + "(" + lastLocalPort + ")");
                    break;
                }
                case LAN_WAN_MANUAL: {
                    this.createServerSocket(CFG_MYJD.CFG.getManualLocalPort());
                    this.logger.info("MyJDownloaderDirectConnectionServer: Mode=" + (Object)((Object)this.connectMode) + " RemotePort=" + CFG_MYJD.CFG.getManualRemotePort() + " LocalPort=" + this.getLocalPort() + "(" + lastLocalPort + "|" + CFG_MYJD.CFG.getManualLocalPort() + ")");
                    break;
                }
                case LAN_WAN_UPNP: {
                    this.createServerSocket(-1);
                    this.logger.info("MyJDownloaderDirectConnectionServer: Mode=" + (Object)((Object)this.connectMode) + " LocalPort=" + this.getLocalPort() + "(" + lastLocalPort + ")");
                    new Thread("MyJDownloaderDirectConnectionServer: setup UPNP"){
                        {
                            this.setDaemon(true);
                        }

                        @Override
                        public void run() {
                            MyJDownloaderDirectServer.this.setupUPNPPort();
                        }
                    }.start();
                    break;
                }
                default: {
                    return;
                }
            }
            ServerSocket serverSocket = null;
            while (this.connectThread.isAlive() && (serverSocket = this.currentServerSocket.get()) != null) {
                Socket clientSocket = null;
                try {
                    InetSocketAddress addr;
                    clientSocket = serverSocket.accept();
                    if (this.connectMode == MyJDownloaderSettings.DIRECTMODE.LAN && !(addr = (InetSocketAddress)clientSocket.getRemoteSocketAddress()).getAddress().isLoopbackAddress() && !addr.getAddress().isSiteLocalAddress()) {
                        clientSocket.close();
                        continue;
                    }
                    clientSocket.setReuseAddress(true);
                    clientSocket.setSoTimeout(180000);
                    clientSocket.setTcpNoDelay(true);
                    this.handleConnection(clientSocket);
                }
                catch (Throwable e) {
                    if (clientSocket != null) {
                        try {
                            clientSocket.close();
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        finally {
            this.close();
        }
    }

    protected void close() {
        ShutdownController.getInstance().removeShutdownVetoListener((ShutdownVetoListener)this);
        Thread thread = new Thread(this.getClass() + ":close()"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                try {
                    ServerSocket serverSocket = MyJDownloaderDirectServer.this.currentServerSocket.getAndSet(null);
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                }
                catch (Throwable serverSocket) {
                    // empty catch block
                }
                final PortMapping upnpPortMapping = MyJDownloaderDirectServer.this.upnpPortMapping;
                Service upnpPortMappingService = MyJDownloaderDirectServer.this.upnpPortMappingService;
                if (upnpPortMapping != null && upnpPortMappingService != null) {
                    DefaultUpnpServiceConfiguration config = new DefaultUpnpServiceConfiguration(){

                        public Executor getMulticastReceiverExecutor() {
                            return super.getMulticastReceiverExecutor();
                        }

                        public Integer getRemoteDeviceMaxAgeSeconds() {
                            return super.getRemoteDeviceMaxAgeSeconds();
                        }

                        public StreamClientImpl createStreamClient() {
                            return new StreamClientImpl(new StreamClientConfigurationImpl(this.getSyncProtocolExecutorService()));
                        }
                    };
                    UpnpServiceImpl upnpService = null;
                    try {
                        upnpService = new UpnpServiceImpl((UpnpServiceConfiguration)config, new RegistryListener[0]);
                        upnpService.getControlPoint().execute((ActionCallback)new PortMappingDelete(upnpPortMappingService, upnpPortMapping){

                            public void success(ActionInvocation var1) {
                                MyJDownloaderDirectServer.this.logger.info("PortMappingDelete(" + upnpPortMapping + " successful");
                                MyJDownloaderDirectServer.this.upnpPortMapping = null;
                                MyJDownloaderDirectServer.this.upnpPortMappingService = null;
                            }

                            public void failure(ActionInvocation var1, UpnpResponse var2, String var3) {
                                MyJDownloaderDirectServer.this.logger.info("PortMappingDelete(" + upnpPortMapping + " failed");
                            }
                        }).get(5L, TimeUnit.SECONDS);
                    }
                    catch (Exception exception) {
                        UPNPDeviceScanner.shutdown(upnpService);
                        catch (Throwable throwable) {
                            UPNPDeviceScanner.shutdown(upnpService);
                            throw throwable;
                        }
                    }
                    UPNPDeviceScanner.shutdown(upnpService);
                }
            }
        };
        thread.start();
        try {
            thread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void onShutdown(ShutdownRequest request) {
        this.close();
    }

    public int getLocalPort() {
        ServerSocket serverSocket = this.currentServerSocket.get();
        return serverSocket == null ? -1 : serverSocket.getLocalPort();
    }

    public int getRemotePort() {
        ServerSocket serverSocket = this.currentServerSocket.get();
        if (serverSocket == null) {
            return -1;
        }
        switch (this.connectMode) {
            case LAN_WAN_MANUAL: {
                return CFG_MYJD.CFG.getManualRemotePort();
            }
            case LAN_WAN_UPNP: {
                PortMapping upnpPortMapping = this.upnpPortMapping;
                return upnpPortMapping == null ? -1 : upnpPortMapping.getExternalPort().getValue().intValue();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleConnection(final Socket clientSocket) throws IOException {
        final MyJDownloaderAPI api = this.connectThread.getApi();
        if (api == null) {
            throw new IOException("api no longer available");
        }
        long requestNumber = this.connectThread.THREADCOUNTER.incrementAndGet();
        Thread connectionThread = new Thread("MyJDownloaderDirectConnection:" + requestNumber){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object httpConnection2;
                try {
                    httpConnection2 = DeprecatedAPIServer.autoWrapSSLConnection(clientSocket, new DeprecatedAPIServer.AutoSSLHttpConnectionFactory(){

                        @Override
                        public MyJDownloaderDirectHttpConnection create(Socket clientSocket, InputStream is, OutputStream os) throws IOException {
                            return new MyJDownloaderDirectHttpConnection(clientSocket, is, os, api);
                        }
                    });
                    if (httpConnection2 != null) {
                        httpConnection2.run();
                    }
                }
                catch (Throwable e) {
                    MyJDownloaderDirectServer.this.logger.log(e);
                }
                finally {
                    try {
                        clientSocket.close();
                    }
                    catch (Throwable httpConnection2) {}
                    httpConnection2 = MyJDownloaderConnectThread.getOpenconnections();
                    synchronized (httpConnection2) {
                        MyJDownloaderConnectThread.getOpenconnections().remove(Thread.currentThread());
                    }
                    MyJDownloaderDirectServer.this.connectThread.setEstablishedConnections(MyJDownloaderDirectServer.this.connectThread.getEstablishedConnections());
                }
            }
        };
        HashMap<Thread, SocketStreamInterface> hashMap = MyJDownloaderConnectThread.getOpenconnections();
        synchronized (hashMap) {
            MyJDownloaderConnectThread.getOpenconnections().put(connectionThread, new SocketStreamInterface(){

                public Socket getSocket() {
                    return clientSocket;
                }

                public OutputStream getOutputStream() throws IOException {
                    return clientSocket.getOutputStream();
                }

                public InputStream getInputStream() throws IOException {
                    return clientSocket.getInputStream();
                }

                public void close() throws IOException {
                    clientSocket.close();
                }
            });
        }
        this.connectThread.setEstablishedConnections(this.connectThread.getEstablishedConnections());
        connectionThread.setDaemon(true);
        connectionThread.start();
    }

    public void onShutdownVeto(ShutdownRequest request) {
    }

    public void onShutdownVetoRequest(ShutdownRequest request) throws ShutdownVetoException {
    }

    public long getShutdownVetoPriority() {
        return 0L;
    }
}

