/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.plugins;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import jd.config.ConfigContainer;
import jd.config.ConfigEntry;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;
import org.jdownloader.api.config.AdvancedConfigQueryStorable;
import org.jdownloader.api.plugins.PluginConfigEntryAPIStorable;
import org.jdownloader.myjdownloader.client.bindings.AdvancedConfigEntryDataStorable;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.advanced.AdvancedConfigEntry;

public class PluginConfigAdapter {
    private static final String OLD_CONFIG_PREFIX = "deprecated";
    private final LazyPlugin<?> lazyPlugin;
    private PluginConfigInterface config;
    private ConfigContainer oldConfig;
    private boolean initialized = false;

    public PluginConfigAdapter(LazyPlugin<?> lazyPlugin) throws ClassNotFoundException {
        if (lazyPlugin == null) {
            throw new ClassNotFoundException();
        }
        this.lazyPlugin = lazyPlugin;
    }

    public LazyPlugin<?> getLazyPlugin() {
        return this.lazyPlugin;
    }

    public PluginConfigAdapter(String interfaceName, String displayName) throws ClassNotFoundException {
        LazyPlugin lazyPlugin;
        this.lazyPlugin = interfaceName.contains("jd.plugins.hoster") ? HostPluginController.getInstance().get(displayName) : (interfaceName.contains("jd.plugins.decrypter") ? CrawlerPluginController.getInstance().get(displayName) : (interfaceName.startsWith("org.jdownloader.plugins.components") ? ((lazyPlugin = HostPluginController.getInstance().get(displayName)) != null && StringUtils.equals((String)((LazyHostPlugin)lazyPlugin).getConfigInterface(), (String)interfaceName) ? lazyPlugin : ((lazyPlugin = CrawlerPluginController.getInstance().get(displayName)) != null && StringUtils.equals((String)((LazyCrawlerPlugin)lazyPlugin).getConfigInterface(), (String)interfaceName) ? lazyPlugin : null)) : null));
        if (this.lazyPlugin == null) {
            throw new ClassNotFoundException("interfaceName:" + interfaceName + "|displayName:" + displayName);
        }
    }

    private synchronized void init() {
        if (!this.initialized) {
            try {
                String configInterfaceName = this.getConfigInterface();
                if (configInterfaceName == null) {
                    Object plugin = this.getLazyPlugin().getPrototype(null);
                    this.oldConfig = ((Plugin)plugin).getConfig();
                } else {
                    PluginClassLoader.PluginClassLoaderChild classLoader = PluginClassLoader.getInstance().getChild();
                    Class<?> configInterface = classLoader.loadClass(configInterfaceName);
                    this.config = PluginJsonConfig.get(this.getLazyPlugin(), configInterface);
                }
            }
            catch (Throwable e) {
                throw new WTFException(e);
            }
            finally {
                this.initialized = true;
            }
        }
    }

    private String getConfigInterface() {
        LazyPlugin<?> lazyPlugin = this.getLazyPlugin();
        if (this.isHostPlugin()) {
            return ((LazyHostPlugin)lazyPlugin).getConfigInterface();
        }
        if (this.isCrawlerPlugin()) {
            return ((LazyCrawlerPlugin)lazyPlugin).getConfigInterface();
        }
        return null;
    }

    public boolean isOldConfig() {
        return this.getConfigInterface() == null;
    }

    public boolean hasConfig() {
        LazyPlugin<?> lazyPlugin = this.getLazyPlugin();
        if (this.isHostPlugin()) {
            return ((LazyHostPlugin)lazyPlugin).isHasConfig() || ((LazyHostPlugin)lazyPlugin).getConfigInterface() != null;
        }
        if (this.isCrawlerPlugin()) {
            return ((LazyCrawlerPlugin)lazyPlugin).isHasConfig() || ((LazyCrawlerPlugin)lazyPlugin).getConfigInterface() != null;
        }
        return false;
    }

    public boolean isHostPlugin() {
        return this.getLazyPlugin() instanceof LazyHostPlugin;
    }

    public boolean isCrawlerPlugin() {
        return this.getLazyPlugin() instanceof LazyCrawlerPlugin;
    }

    private ConfigEntry getConfigEntry(String key) {
        if (this.oldConfig != null && this.oldConfig.getEntries().size() > 0) {
            for (ConfigEntry entry : this.oldConfig.getEntries()) {
                if (entry.getPropertyName() == null || !entry.getPropertyName().equals(key)) continue;
                return entry;
            }
        }
        return null;
    }

    public Object getValue(String key) throws BadParameterException {
        if (!StringUtils.isEmpty((String)key)) {
            KeyHandler kh;
            this.init();
            if (this.isOldConfig()) {
                ConfigEntry entry = this.getConfigEntry(key);
                if (entry != null) {
                    return this.getConfigEntryValue(entry);
                }
            } else if (this.config != null && (kh = this.config._getStorageHandler().getKeyHandler(key)) != null) {
                return kh.getValue();
            }
        }
        throw new BadParameterException("no matching config entry");
    }

    public Object getDefaultValue(String key) throws BadParameterException {
        if (!StringUtils.isEmpty((String)key)) {
            KeyHandler keyHandler;
            this.init();
            if (this.isOldConfig()) {
                ConfigEntry entry = this.getConfigEntry(key);
                if (entry != null) {
                    return this.getConfigEntryDefaultValue(entry);
                }
            } else if (this.config != null && (keyHandler = this.config._getStorageHandler().getKeyHandler(key)) != null) {
                return keyHandler.getDefaultValue();
            }
        }
        throw new BadParameterException("no matching config entry:" + key);
    }

    public boolean setValue(String key, Object value) {
        if (!StringUtils.isEmpty((String)key)) {
            KeyHandler keyHandler;
            if (value instanceof String) {
                value = StringUtils.nullify((String)((String)value));
            }
            this.init();
            if (this.isOldConfig()) {
                AdvancedConfigEntryDataStorable.AbstractType type;
                ConfigEntry entry = this.getConfigEntry(key);
                if (entry != null && (type = this.getAbstractTypeFromConfigType(entry.getType())) != null) {
                    switch (type) {
                        case ENUM: {
                            Object[] values = entry.getList();
                            if (values != null) {
                                int index = Arrays.asList(values).indexOf(value);
                                if (index != -1) {
                                    entry.getPropertyInstance().setProperty(key, index);
                                    return true;
                                }
                                if (value == null) {
                                    entry.getPropertyInstance().removeProperty(key);
                                    return true;
                                }
                            }
                            return false;
                        }
                        case LONG: {
                            if (value instanceof String) {
                                value = Long.parseLong((String)value);
                            }
                            if (value instanceof Number) {
                                long num = ((Number)value).longValue();
                                if (num < (long)entry.getStart()) {
                                    num = entry.getStart();
                                } else if (num > (long)entry.getEnd()) {
                                    num = entry.getEnd();
                                }
                                entry.getPropertyInstance().setProperty(key, num);
                            } else {
                                entry.getPropertyInstance().removeProperty(key);
                            }
                            return true;
                        }
                        case BOOLEAN: {
                            if (value instanceof Boolean) {
                                entry.getPropertyInstance().setProperty(key, value);
                            } else if (value instanceof String) {
                                entry.getPropertyInstance().setProperty(key, StringUtils.equalsIgnoreCase((String)"true", (String)((String)value)));
                            } else {
                                entry.getPropertyInstance().removeProperty(key);
                            }
                            return true;
                        }
                    }
                    entry.getPropertyInstance().setProperty(key, value);
                    return true;
                }
                return false;
            }
            if (this.config != null && (keyHandler = this.config._getStorageHandler().getKeyHandler(key)) != null) {
                Type rc = keyHandler.getRawType();
                String json = JSonStorage.serializeToJson((Object)value);
                TypeRef<Object> type = new TypeRef<Object>(rc){};
                Object v = JSonStorage.stringToObject((String)json, (TypeRef)type, null);
                keyHandler.setValue(v);
                return true;
            }
        }
        return false;
    }

    public List<PluginConfigEntryAPIStorable> listConfigEntries(AdvancedConfigQueryStorable query) throws UpdateRequiredClassNotFoundException {
        boolean configInterfaceMatch;
        ArrayList<PluginConfigEntryAPIStorable> result = new ArrayList<PluginConfigEntryAPIStorable>();
        if (!this.hasConfig()) {
            return result;
        }
        LazyPlugin<?> lazyPlugin = this.getLazyPlugin();
        boolean bl = configInterfaceMatch = query == null || query.getConfigInterface() == null || query.getConfigInterface().equals("deprecated." + lazyPlugin.getClassName()) || this.getConfigInterface() != null && query.getConfigInterface().equals(this.getConfigInterface());
        if (query == null) {
            query = new AdvancedConfigQueryStorable();
        }
        if (!configInterfaceMatch) {
            return result;
        }
        this.init();
        Pattern cPat = null;
        if (!StringUtils.isEmpty((String)query.getPattern())) {
            cPat = Pattern.compile(query.getPattern(), 34);
        }
        if (this.isOldConfig()) {
            for (ConfigEntry entry : this.oldConfig.getEntries()) {
                PluginConfigEntryAPIStorable storable;
                String check = lazyPlugin.getClassName() + "." + lazyPlugin.getDisplayName() + "." + entry.getPropertyName();
                if (cPat != null && !cPat.matcher(check).matches() || (storable = this.createAPIStorable(entry, query)) == null) continue;
                result.add(storable);
            }
        } else {
            for (KeyHandler keyHandler : this.config._getStorageHandler().getKeyHandler()) {
                AdvancedConfigEntry entry;
                PluginConfigEntryAPIStorable storable;
                String check = lazyPlugin.getClassName() + "." + lazyPlugin.getDisplayName() + "." + keyHandler.getKey();
                if (cPat != null && !cPat.matcher(check).matches() || (storable = this.createAPIStorable(entry = new AdvancedConfigEntry(this.config, keyHandler), query)) == null) continue;
                result.add(storable);
            }
        }
        return result;
    }

    public PluginConfigEntryAPIStorable createAPIStorable(AdvancedConfigEntry entry, AdvancedConfigQueryStorable query) {
        PluginConfigEntryAPIStorable storable = new PluginConfigEntryAPIStorable(entry, query);
        storable.setStorage(this.getLazyPlugin().getDisplayName());
        return storable;
    }

    private String getEnumDefault(ConfigEntry entry) {
        Object[] values = entry.getList();
        if (values != null && values.length > 0) {
            Object defaultValue = entry.getDefaultValue();
            if (defaultValue instanceof String && Arrays.asList(values).contains(defaultValue)) {
                return (String)defaultValue;
            }
            if (defaultValue instanceof Number && values.length > ((Number)defaultValue).intValue()) {
                return String.valueOf(values[((Number)defaultValue).intValue()]);
            }
            return String.valueOf(values[0]);
        }
        return null;
    }

    private String getEnumValue(ConfigEntry entry) {
        Object[] values = entry.getList();
        if (values != null && values.length > 0) {
            Object value = entry.getPropertyInstance().getProperty(entry.getPropertyName());
            if (value instanceof String && Arrays.asList(values).contains(value)) {
                return (String)value;
            }
            if (value instanceof Number && values.length > ((Number)value).intValue()) {
                return String.valueOf(values[((Number)value).intValue()]);
            }
            return this.getEnumDefault(entry);
        }
        return null;
    }

    private Object getConfigEntryValue(ConfigEntry entry) {
        AdvancedConfigEntryDataStorable.AbstractType type = this.getAbstractTypeFromConfigType(entry.getType());
        if (type != null) {
            String key = entry.getPropertyName();
            if (entry.getPropertyInstance().hasProperty(key)) {
                switch (type) {
                    case BOOLEAN: {
                        return entry.getPropertyInstance().getBooleanProperty(key);
                    }
                    case LONG: {
                        return entry.getPropertyInstance().getLongProperty(key, -1L);
                    }
                    case STRING: {
                        return entry.getPropertyInstance().getStringProperty(key);
                    }
                    case ENUM: {
                        return this.getEnumValue(entry);
                    }
                }
                return entry.getPropertyInstance().getProperty(key);
            }
            return this.getConfigEntryDefaultValue(entry);
        }
        return null;
    }

    private Object getConfigEntryDefaultValue(ConfigEntry entry) {
        AdvancedConfigEntryDataStorable.AbstractType type = this.getAbstractTypeFromConfigType(entry.getType());
        if (type != null) {
            switch (type) {
                case ENUM: {
                    return this.getEnumDefault(entry);
                }
            }
            return entry.getDefaultValue();
        }
        return null;
    }

    public PluginConfigEntryAPIStorable createAPIStorable(ConfigEntry entry, AdvancedConfigQueryStorable query) {
        LazyPlugin<?> lazyPlugin = this.getLazyPlugin();
        AdvancedConfigEntryDataStorable.AbstractType type = this.getAbstractTypeFromConfigType(entry.getType());
        if (type != null) {
            Object[] list;
            PluginConfigEntryAPIStorable storable = new PluginConfigEntryAPIStorable();
            storable.setInterfaceName("deprecated." + lazyPlugin.getClassName());
            storable.setKey(entry.getPropertyName());
            storable.setAbstractType(type);
            storable.setStorage(lazyPlugin.getDisplayName());
            if (query.isDescription()) {
                storable.setDocs(entry.getLabel());
            }
            if (query.isValues()) {
                storable.setValue(this.getConfigEntryValue(entry));
            }
            if (query.isDefaultValues()) {
                storable.setDefaultValue(this.getConfigEntryDefaultValue(entry));
            }
            if (query.isEnumInfo() && (list = entry.getList()) != null && list.length > 0) {
                String[][] options = new String[list.length][1];
                for (int i = 0; i < list.length; ++i) {
                    options[i][0] = String.valueOf(list[i]);
                }
                storable.setEnumOptions(options);
            }
            return storable;
        }
        return null;
    }

    public boolean resetValue(String key) throws BadParameterException {
        return this.setValue(key, this.getDefaultValue(key));
    }

    private AdvancedConfigEntryDataStorable.AbstractType getAbstractTypeFromConfigType(int configContainerType) {
        switch (configContainerType) {
            case 3: {
                return AdvancedConfigEntryDataStorable.AbstractType.BOOLEAN;
            }
            case 8: {
                return AdvancedConfigEntryDataStorable.AbstractType.LONG;
            }
            case 15: {
                return AdvancedConfigEntryDataStorable.AbstractType.ENUM;
            }
            case 0: 
            case 10: 
            case 11: {
                return AdvancedConfigEntryDataStorable.AbstractType.STRING;
            }
        }
        return null;
    }
}

