/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.useragent;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jd.controlling.TaskQueue;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.SessionRemoteAPIRequest;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.uio.UIOManager;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpserver.session.HttpSession;
import org.jdownloader.api.myjdownloader.MyJDownloaderController;
import org.jdownloader.api.useragent.ConnectedDevice;
import org.jdownloader.api.useragent.UserAgentEvent;
import org.jdownloader.api.useragent.UserAgentEventSender;
import org.jdownloader.api.useragent.UserAgentInfo;
import org.jdownloader.api.useragent.UserAgentListener;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.exceptions.MyJDownloaderException;

public class UserAgentController {
    private final ConcurrentHashMap<String, ConnectedDevice> map;
    private final UserAgentEventSender eventSender = new UserAgentEventSender();
    private final LogSource logger = LogController.getInstance().getLogger("UserAgentController");
    private final ConcurrentHashMap<ConnectedDevice, DelayedRunnable> timeoutcheck;
    private final ConcurrentHashMap<String, UserAgentInfo> uaCache;

    public UserAgentController() {
        this.map = new ConcurrentHashMap();
        this.timeoutcheck = new ConcurrentHashMap();
        this.uaCache = new ConcurrentHashMap();
    }

    protected void checkTimeouted() {
    }

    public UserAgentEventSender getEventSender() {
        return this.eventSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RemoteAPIRequest request) {
        UserAgentController userAgentController = this;
        synchronized (userAgentController) {
            String nuaID = this.createSessionUAID(request);
            ConnectedDevice ua = this.map.get(nuaID);
            if (ua == null) {
                ua = this.createNewUserAgent(request, nuaID);
                this.map.put(nuaID, ua);
                final String userAgent = ua.getUserAgentString();
                if (userAgent != null && StringUtils.isNotEmpty((String)userAgent) && !ConnectedDevice.isApp(userAgent)) {
                    UserAgentInfo cachedUA = this.uaCache.get(userAgent);
                    if (cachedUA != null) {
                        ua.setInfo(cachedUA);
                    } else {
                        final ConnectedDevice fua = ua;
                        new Thread("UserAgentCreater:" + userAgent){
                            {
                                super(x0);
                                this.setDaemon(true);
                            }

                            @Override
                            public void run() {
                                try {
                                    String json = new Browser().getPage("https://update3.jdownloader.org/jdserv/ua/get?" + Encoding.urlEncode((String)userAgent));
                                    UserAgentInfo info = (UserAgentInfo)JSonStorage.restoreFromString((String)json, (TypeRef)new TypeRef<UserAgentInfo>(){});
                                    if (info != null) {
                                        UserAgentController.this.uaCache.put(userAgent, info);
                                        fua.setInfo(info);
                                    }
                                }
                                catch (Throwable e) {
                                    UserAgentController.this.logger.log(e);
                                }
                            }
                        }.start();
                    }
                }
                final ConnectedDevice fua = ua;
                DelayedRunnable delayed = new DelayedRunnable(fua.getTimeout()){

                    public void delayedrun() {
                        UserAgentController.this.onTimeout(fua);
                    }
                };
                this.timeoutcheck.put(fua, delayed);
                delayed.resetAndStart();
                this.eventSender.fireEvent(new UserAgentEvent(){

                    @Override
                    public void fireTo(UserAgentListener listener) {
                        listener.onNewAPIUserAgent(fua);
                    }
                });
            } else {
                DelayedRunnable delayed = this.timeoutcheck.get(ua);
                if (delayed != null) {
                    delayed.resetAndStart();
                }
            }
            final ConnectedDevice fua = ua;
            ua.setLatestRequest(request);
            this.eventSender.fireEvent(new UserAgentEvent(){

                @Override
                public void fireTo(UserAgentListener listener) {
                    listener.onAPIUserAgentUpdate(fua);
                }
            });
        }
    }

    protected void onTimeout(final ConnectedDevice fua) {
        this.timeoutcheck.remove(fua);
        this.map.remove(fua.getId());
        this.eventSender.fireEvent(new UserAgentEvent(){

            @Override
            public void fireTo(UserAgentListener listener) {
                listener.onRemovedAPIUserAgent(fua);
            }
        });
    }

    private String createSessionUAID(RemoteAPIRequest request) {
        return request.getRequestHeaders().getValue("User-Agent") + "_Session: " + this.getSessionID(request);
    }

    private String getSessionID(RemoteAPIRequest request) {
        HttpSession session;
        if (request instanceof SessionRemoteAPIRequest && (session = ((SessionRemoteAPIRequest)request).getSession()) != null) {
            return session.getSessionID();
        }
        return null;
    }

    public List<ConnectedDevice> list() {
        ArrayList<ConnectedDevice> ret = new ArrayList<ConnectedDevice>();
        for (Map.Entry<String, ConnectedDevice> es : this.map.entrySet()) {
            ConnectedDevice ua = es.getValue();
            if (ua == null) continue;
            ret.add(ua);
        }
        return ret;
    }

    private ConnectedDevice createNewUserAgent(RemoteAPIRequest request, String nuaID) {
        ConnectedDevice ret = new ConnectedDevice(nuaID);
        String token = this.getSessionID(request);
        ret.setConnectToken(token);
        ret.setLatestRequest(request);
        return ret;
    }

    public void disconnectDecice(final ConnectedDevice device) {
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                try {
                    MyJDownloaderController.getInstance().terminateSession(device.getConnectToken());
                }
                catch (MyJDownloaderException e) {
                    UIOManager.I().showException(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        });
        this.onTimeout(device);
    }
}

