/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.auth;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import jd.http.Authentication;
import jd.http.AuthenticationFactory;
import jd.http.Browser;
import jd.http.CallbackAuthenticationFactory;
import jd.http.DefaultAuthenticanFactory;
import jd.http.Request;
import jd.http.URLUserInfoAuthentication;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.CloseReason;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeEventSender;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.dialog.LoginDialog;
import org.appwork.utils.swing.dialog.LoginDialogInterface;
import org.jdownloader.auth.AuthenticationControllerSettings;
import org.jdownloader.auth.AuthenticationInfo;
import org.jdownloader.auth.Login;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.translate._JDT;

public class AuthenticationController {
    private static final AuthenticationController INSTANCE = new AuthenticationController();
    private final AuthenticationControllerSettings config;
    private final CopyOnWriteArrayList<AuthenticationInfo> authenticationInfos;
    private final ChangeEventSender eventSender = new ChangeEventSender();
    private final LogSource logger = LogController.getInstance().getLogger(AuthenticationController.class.getName());

    public static AuthenticationController getInstance() {
        return INSTANCE;
    }

    private AuthenticationController() {
        this.config = (AuthenticationControllerSettings)JsonConfig.create(AuthenticationControllerSettings.class);
        CopyOnWriteArrayList<AuthenticationInfo> list = this.cleanup(this.config.getList());
        this.authenticationInfos = list == null ? new CopyOnWriteArrayList() : list;
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public void onShutdown(ShutdownRequest shutdownRequest) {
                AuthenticationController.this.save(AuthenticationController.this.authenticationInfos);
            }

            public long getMaxDuration() {
                return 0L;
            }

            public String toString() {
                return "ShutdownEvent: Save AuthController";
            }
        });
    }

    private void save(List<AuthenticationInfo> authenticationInfos) {
        this.config.setList(new ArrayList<AuthenticationInfo>(authenticationInfos));
    }

    public ChangeEventSender getEventSender() {
        return this.eventSender;
    }

    public List<AuthenticationInfo> list() {
        return this.authenticationInfos;
    }

    private CopyOnWriteArrayList<AuthenticationInfo> cleanup(List<AuthenticationInfo> infos) {
        CopyOnWriteArrayList<AuthenticationInfo> ret = new CopyOnWriteArrayList<AuthenticationInfo>();
        if (infos != null && infos.size() > 0) {
            for (AuthenticationInfo info : infos) {
                if (StringUtils.isEmpty((String)info.getHostmask()) || info.getType() == null || StringUtils.isAllEmpty((String[])new String[]{info.getUsername(), info.getPassword()})) continue;
                ret.add(info);
            }
        }
        return ret;
    }

    public boolean add(AuthenticationInfo a) {
        if (a != null && this.authenticationInfos.addIfAbsent(a)) {
            this.save(this.authenticationInfos);
            this.eventSender.fireEvent((DefaultEvent)new ChangeEvent((Object)this));
            return true;
        }
        return false;
    }

    public boolean remove(AuthenticationInfo a) {
        if (a != null && this.authenticationInfos.remove(a)) {
            this.save(this.authenticationInfos);
            this.eventSender.fireEvent((DefaultEvent)new ChangeEvent((Object)this));
            return true;
        }
        return false;
    }

    public boolean remove(List<AuthenticationInfo> selectedObjects) {
        if (selectedObjects != null && this.authenticationInfos.removeAll(selectedObjects)) {
            this.save(this.authenticationInfos);
            this.eventSender.fireEvent((DefaultEvent)new ChangeEvent((Object)this));
            return true;
        }
        return false;
    }

    public Login getBestLogin(URL url, String realm) {
        List<Login> ret = this.getSortedLoginsList(url, realm);
        if (ret != null && ret.size() > 0) {
            return ret.get(0);
        }
        return null;
    }

    public List<AuthenticationFactory> buildAuthenticationFactories(final URL url, String realm) {
        ArrayList<AuthenticationFactory> authenticationFactories = new ArrayList<AuthenticationFactory>();
        if (url.getUserInfo() != null) {
            authenticationFactories.add((AuthenticationFactory)new URLUserInfoAuthentication());
        }
        authenticationFactories.addAll(this.getSortedAuthenticationFactories(url, realm));
        authenticationFactories.add((AuthenticationFactory)new CallbackAuthenticationFactory(){
            protected Authentication remember = null;

            protected Authentication askAuthentication(Browser browser, Request request, String realm) {
                LoginDialog loginDialog = new LoginDialog(4, _JDT.T.Plugin_requestLogins_message(), _JDT.T.AuthExceptionGenericBan_toString(url.toExternalForm()), (Icon)new AbstractIcon("password", 32));
                loginDialog.setTimeout(60000);
                LoginDialogInterface handle = (LoginDialogInterface)UIOManager.I().show(LoginDialogInterface.class, (UserIODefinition)loginDialog);
                if (handle.getCloseReason() == CloseReason.OK) {
                    Authentication ret = new DefaultAuthenticanFactory(request.getURL().getHost(), realm, handle.getUsername(), handle.getPassword()).buildAuthentication(browser, request);
                    this.addAuthentication(ret);
                    if (handle.isRememberSelected()) {
                        this.remember = ret;
                    }
                    return ret;
                }
                return null;
            }

            public boolean retry(Authentication authentication, Browser browser, Request request) {
                if (this.containsAuthentication(authentication) && this.remember == authentication && request.getAuthentication() == authentication && !this.requiresAuthentication(request)) {
                    AuthenticationInfo auth = new AuthenticationInfo();
                    auth.setRealm(authentication.getRealm());
                    auth.setUsername(authentication.getUsername());
                    auth.setPassword(authentication.getPassword());
                    auth.setHostmask(authentication.getHost());
                    auth.setType(AuthenticationInfo.Type.HTTP);
                    AuthenticationController.getInstance().add(auth);
                }
                return super.retry(authentication, browser, request);
            }
        });
        return authenticationFactories;
    }

    public List<AuthenticationFactory> getSortedAuthenticationFactories(URL url, String realm) {
        ArrayList<AuthenticationFactory> ret = new ArrayList<AuthenticationFactory>();
        List<Login> logins = this.getSortedLoginsList(url, realm);
        if (logins != null && logins.size() > 0) {
            for (final Login login : logins) {
                ret.add((AuthenticationFactory)new DefaultAuthenticanFactory(login.getHost(), login.getRealm(), login.getUsername(), login.getPassword()){

                    protected boolean requiresAuthentication(Request request) {
                        if (login.isAlwaysFlag()) {
                            return this.getWWWAuthenticate(request) != null;
                        }
                        return super.requiresAuthentication(request);
                    }

                    public boolean retry(Authentication authentication, Browser browser, Request request) {
                        if (this.containsAuthentication(authentication) && request.getAuthentication() == authentication && !this.requiresAuthentication(request)) {
                            login.validate();
                        }
                        return super.retry(authentication, browser, request);
                    }
                });
            }
        }
        return ret;
    }

    public List<Login> getSortedLoginsList(URL url, String realm) {
        AuthenticationInfo.Type type;
        ArrayList<Login> ret = new ArrayList<Login>();
        String protocol = url.getProtocol();
        if (protocol != null && protocol.matches("(?i)^ftp$")) {
            type = AuthenticationInfo.Type.FTP;
        } else if (protocol != null && protocol.matches("(?i)^https?$")) {
            type = AuthenticationInfo.Type.HTTP;
        } else {
            LogController.getRebirthLogger((LogInterface)this.logger).info("Unknown Protocoll: " + url);
            return ret;
        }
        ArrayList<AuthenticationInfo> infos = new ArrayList<AuthenticationInfo>();
        String urlHost = url.getHost();
        for (final AuthenticationInfo info : this.authenticationInfos) {
            boolean contains;
            if (!info.isEnabled() || realm != null && !StringUtils.equalsIgnoreCase((String)realm, (String)info.getRealm())) continue;
            String hostMask = info.getHostmask();
            if (!info.getType().equals((Object)type) || StringUtils.isEmpty((String)hostMask)) continue;
            if (hostMask.matches(".*(\\*|\\[|\\(|\\||\\?|\\{).*")) {
                String pattern = hostMask;
                Boolean matches = null;
                try {
                    matches = Pattern.compile(pattern, 2).matcher(urlHost).matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
                if (!Boolean.TRUE.equals(matches)) {
                    try {
                        pattern = hostMask.replace("*", ".*");
                        matches = Pattern.compile(pattern, 2).matcher(urlHost).matches();
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
                contains = Boolean.TRUE.equals(matches);
            } else {
                contains = hostMask.length() > urlHost.length() ? StringUtils.containsIgnoreCase((String)hostMask, (String)urlHost) : StringUtils.containsIgnoreCase((String)urlHost, (String)hostMask);
            }
            if (!contains) continue;
            infos.add(info);
        }
        try {
            Collections.sort(infos, new Comparator<AuthenticationInfo>(){

                private String getRealm(AuthenticationInfo ai) {
                    String realm = ai.getRealm();
                    if (realm == null) {
                        return "";
                    }
                    return realm;
                }

                @Override
                private int compare(long x, long y) {
                    return x < y ? -1 : (x == y ? 0 : 1);
                }

                @Override
                private int compare(boolean x, boolean y) {
                    return x == y ? 0 : (x ? 1 : -1);
                }

                @Override
                public int compare(AuthenticationInfo o1, AuthenticationInfo o2) {
                    int ret = this.compare(this.getRealm(o2).length(), this.getRealm(o1).length());
                    if (ret == 0) {
                        ret = this.compare(o2.getHostmask().length(), o1.getHostmask().length());
                    }
                    if (ret == 0) {
                        ret = this.compare(o2.isAlwaysFlag(), o1.isAlwaysFlag());
                    }
                    if (ret == 0) {
                        ret = this.compare(o2.getLastValidated(), o1.getLastValidated());
                    }
                    if (ret == 0) {
                        ret = this.compare(o2.getCreated(), o1.getCreated());
                    }
                    return ret;
                }
            });
        }
        catch (Throwable e) {
            LogController.getRebirthLogger((LogInterface)this.logger).log(e);
        }
        for (final AuthenticationInfo info : infos) {
            ret.add(new Login(info.getType(), info.getHostmask(), info.getRealm(), info.getUsername(), info.getPassword(), info.isAlwaysFlag()){

                @Override
                public void validate() {
                    info.setLastValidated(System.currentTimeMillis());
                }
            });
        }
        return ret;
    }
}

