/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.blacklist;

import java.lang.ref.WeakReference;
import jd.controlling.captcha.SkipRequest;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import org.jdownloader.captcha.blacklist.BlacklistEntry;
import org.jdownloader.captcha.v2.Challenge;

public class BlockCrawlerCaptchasByHost
implements BlacklistEntry {
    private final WeakReference<LinkCrawler> crawler;
    private final String host;

    public String getHost() {
        return this.host;
    }

    public BlockCrawlerCaptchasByHost(LinkCrawler crawler, String host) {
        this.crawler = new WeakReference<LinkCrawler>(crawler);
        this.host = host;
    }

    @Override
    public boolean canCleanUp() {
        LinkCrawler lcrawler = this.getCrawler();
        return lcrawler == null || !lcrawler.isRunning();
    }

    public LinkCrawler getCrawler() {
        return (LinkCrawler)this.crawler.get();
    }

    public String toString() {
        LinkCrawler lcrawler = this.getCrawler();
        if (lcrawler != null) {
            return "BlockCrawlerCaptchasByHost:" + lcrawler.getCreated() + ":" + this.getHost();
        }
        return "BlockCrawlerCaptchasByHost:" + this.getHost();
    }

    public boolean matches(Challenge c) {
        Plugin plugin;
        LinkCrawler lcrawler = this.getCrawler();
        if (lcrawler != null && lcrawler.isRunning() && (plugin = c.getPlugin()) instanceof PluginForDecrypt) {
            PluginForDecrypt decrypt = (PluginForDecrypt)plugin;
            return decrypt.getCrawler() == lcrawler && decrypt.getHost().equalsIgnoreCase(this.getHost());
        }
        return false;
    }

    @Override
    public SkipRequest getSkipRequest() {
        return SkipRequest.BLOCK_HOSTER;
    }
}

