/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import jd.controlling.accountchecker.AccountCheckerThread;
import jd.controlling.captcha.SkipRequest;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.StringUtils;
import org.jdownloader.DomainInfo;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solverjob.ResponseList;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.controlling.UniqueAlltimeID;

public abstract class Challenge<T> {
    private final UniqueAlltimeID id = new UniqueAlltimeID();
    private final Class<T> resultType;
    private final long created;
    private volatile long lastActivity = this.created = System.currentTimeMillis();
    private int timeout = -1;
    private volatile boolean accountLogin = false;
    private final boolean createdInsideAccountChecker;
    private int round = -1;
    private String typeID;
    private String explain;
    private ResponseList<T> result;
    private SolverJob<T> job;

    public int getRound() {
        return this.round;
    }

    public Object getAPIStorable(String format) throws Exception {
        return null;
    }

    public boolean canBeSkippedBy(SkipRequest skipRequest, ChallengeSolver<?> solver, Challenge<?> challenge) {
        Plugin plg = this.getPlugin();
        if (plg != null) {
            if (plg instanceof PluginForHost) {
                return this.canBeSkippedByPluginforHost(skipRequest, solver, challenge, plg);
            }
            if (plg instanceof PluginForDecrypt) {
                return this.canBeSkippedByPluginforDecrypt(skipRequest, solver, challenge, plg);
            }
        }
        return false;
    }

    public boolean isCaptchaResponseValid() {
        return this.isSolved();
    }

    private boolean canBeSkippedByPluginforDecrypt(SkipRequest skipRequest, ChallengeSolver<?> solver, Challenge<?> challenge, Plugin plugin) {
        Plugin challengePlugin = challenge.getPlugin();
        if (challengePlugin == null || !(challengePlugin instanceof PluginForDecrypt)) {
            return false;
        }
        PluginForDecrypt currentPlugin = (PluginForDecrypt)plugin;
        LinkCrawler currentCrawler = currentPlugin.getCrawler();
        CrawledLink currentOrigin = currentPlugin.getCurrentLink().getOriginLink();
        PluginForDecrypt decrypt = (PluginForDecrypt)challengePlugin;
        if (currentCrawler != decrypt.getCrawler()) {
            return false;
        }
        switch (skipRequest) {
            case STOP_CURRENT_ACTION: {
                return true;
            }
            case BLOCK_ALL_CAPTCHAS: {
                return true;
            }
            case BLOCK_HOSTER: {
                return StringUtils.equals((String)currentPlugin.getHost(), (String)challengePlugin.getHost());
            }
            case BLOCK_PACKAGE: {
                CrawledLink crawledLink = decrypt.getCurrentLink();
                return crawledLink != null && crawledLink.getOriginLink() == currentOrigin;
            }
        }
        return false;
    }

    private boolean canBeSkippedByPluginforHost(SkipRequest skipRequest, ChallengeSolver<?> solver, Challenge<?> challenge, Plugin plugin) {
        if (this.isCreatedInsideAccountChecker() || this.isAccountLogin()) {
            return false;
        }
        DownloadLink challengeLink = challenge.getDownloadLink();
        if (challengeLink == null) {
            return false;
        }
        Plugin challengePlugin = challenge.getPlugin();
        if (challengePlugin != null && !(challengePlugin instanceof PluginForHost)) {
            return false;
        }
        PluginForHost currentPlugin = (PluginForHost)plugin;
        DownloadLink currentLink = currentPlugin.getDownloadLink();
        switch (skipRequest) {
            case BLOCK_ALL_CAPTCHAS: {
                return true;
            }
            case BLOCK_HOSTER: {
                return StringUtils.equals((String)currentPlugin.getHost(), (String)challengePlugin.getHost());
            }
            case BLOCK_PACKAGE: {
                if (challengeLink.getDefaultPlugin() == null) {
                    return false;
                }
                FilePackage currentFilePackage = currentLink.getFilePackage();
                return !FilePackage.isDefaultFilePackage(currentFilePackage) && challengeLink.getFilePackage() == currentLink.getFilePackage();
            }
        }
        return false;
    }

    public boolean isAccountLogin() {
        return this.accountLogin;
    }

    public boolean validateResponse(AbstractResponse<T> response) {
        return response.getPriority() > 0;
    }

    public void setAccountLogin(boolean accountLogin) {
        this.accountLogin = accountLogin;
    }

    public UniqueAlltimeID getId() {
        return this.id;
    }

    public Challenge(String method, String explain2) {
        this.typeID = method;
        this.explain = explain2;
        this.createdInsideAccountChecker = Thread.currentThread() instanceof AccountCheckerThread;
        Type superClass = this.getClass().getGenericSuperclass();
        while (superClass instanceof Class) {
            if ((superClass = ((Class)superClass).getGenericSuperclass()) != null) continue;
            throw new IllegalArgumentException("Wrong Construct");
        }
        this.resultType = (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    public boolean isCreatedInsideAccountChecker() {
        return this.createdInsideAccountChecker;
    }

    public int getTimeout() {
        return Math.max(-1, this.timeout);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public boolean isSolved() {
        ResponseList<T> results = this.getResult();
        return results != null && results.getValue() != null;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public boolean keepAlive() {
        Plugin plugin = this.getPlugin();
        if (plugin != null && plugin.keepAlive(this)) {
            this.lastActivity = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public long getValidUntil() {
        int timeout = this.getTimeout();
        if (timeout > 0) {
            return this.getLastActivity() + (long)timeout;
        }
        return -1L;
    }

    public int getRemainingTimeout() {
        long validUntil = this.getValidUntil();
        if (validUntil > 0L) {
            return (int)Math.max(0L, validUntil - System.currentTimeMillis());
        }
        return -1;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public String getExplain() {
        return this.explain;
    }

    public void setExplain(String explain) {
        this.explain = explain;
    }

    public ResponseList<T> getResult() {
        return this.result;
    }

    public void setResult(ResponseList<T> result) {
        this.result = result;
    }

    public String getHost() {
        Plugin plg = this.getPlugin();
        return plg == null ? null : plg.getHost();
    }

    public DownloadLink getDownloadLink() {
        Plugin plugin = this.getPlugin();
        if (plugin != null && plugin instanceof PluginForHost) {
            return ((PluginForHost)plugin).getDownloadLink();
        }
        return null;
    }

    public DomainInfo getDomainInfo() {
        DownloadLink dl;
        Plugin plugin = this.getPlugin();
        if (plugin == null) {
            throw new WTFException("no plugin for this challenge!?");
        }
        DomainInfo ret = null;
        if (plugin instanceof PluginForHost && (dl = ((PluginForHost)plugin).getDownloadLink()) != null) {
            ret = dl.getDomainInfo();
        }
        if (ret == null) {
            ret = DomainInfo.getInstance(plugin.getHost());
        }
        if (ret != null) {
            return ret;
        }
        throw new WTFException("no domaininfo for this challenge!?");
    }

    public Plugin getPlugin() {
        return null;
    }

    public T getRefreshTrigger() {
        if (this.getResultType() == String.class) {
            return (T)"";
        }
        return null;
    }

    public AbstractResponse<T> parseAPIAnswer(String result, String resultFormat, ChallengeSolver<?> solver) {
        return null;
    }

    public boolean isRefreshTrigger(String result) {
        return result == this.getRefreshTrigger();
    }

    public void initController(SolverJob<T> job) {
        this.job = job;
        Plugin plg = this.getPlugin();
        if (plg != null) {
            this.round = plg.addChallenge(this);
        }
    }

    public SolverJob<T> getJob() {
        return this.job;
    }

    public void cleanup() {
    }

    public void onHandled() {
    }

    public void sendStatsError(ChallengeSolver<?> solver, Throwable e) {
        if (e == null || e instanceof InterruptedException) {
            return;
        }
        if (solver == null || !(solver instanceof CESChallengeSolver)) {
            return;
        }
    }

    public void sendStatsSolving(ChallengeSolver<?> solver) {
        if (solver == null || !(solver instanceof CESChallengeSolver)) {
            return;
        }
    }

    public void sendStatsValidation(ChallengeSolver<?> solver, String status) {
        if (solver == null || !(solver instanceof CESChallengeSolver)) {
            return;
        }
    }

    public void poll(SolverJob<T> job2) {
    }
}

