/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.AccountController;
import jd.controlling.AccountFilter;
import jd.controlling.captcha.SkipException;
import jd.controlling.captcha.SkipRequest;
import jd.plugins.Account;
import org.appwork.timetracker.TimeTracker;
import org.appwork.timetracker.TimeTrackerController;
import org.appwork.timetracker.TrackerRule;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.api.captcha.CaptchaAPISolver;
import org.jdownloader.captcha.blacklist.BlacklistEntry;
import org.jdownloader.captcha.blacklist.CaptchaBlackList;
import org.jdownloader.captcha.event.ChallengeResponseEvent;
import org.jdownloader.captcha.event.ChallengeResponseEventSender;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.CaptchaQualityEnsuranceRule;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.PluginChallengeSolver;
import org.jdownloader.captcha.v2.SolverService;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CloudflareTurnstileChallenge;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaDialogSolver;
import org.jdownloader.captcha.v2.challenge.keycaptcha.jac.KeyCaptchaJACSolver;
import org.jdownloader.captcha.v2.challenge.oauth.AccountOAuthSolver;
import org.jdownloader.captcha.v2.challenge.oauth.OAuthDialogSolver;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.solver.antiCaptchaCom.AntiCaptchaComSolver;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserSolver;
import org.jdownloader.captcha.v2.solver.cheapcaptcha.CheapCaptchaSolver;
import org.jdownloader.captcha.v2.solver.dbc.DeathByCaptchaSolver;
import org.jdownloader.captcha.v2.solver.endcaptcha.EndCaptchaSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogBasicCaptchaSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogClickCaptchaSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogMultiClickCaptchaSolver;
import org.jdownloader.captcha.v2.solver.imagetyperz.ImageTyperzCaptchaSolver;
import org.jdownloader.captcha.v2.solver.jac.JACSolver;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolver;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolverClick;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolverMultiClick;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSolverPuzzle;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaSolver;
import org.jdownloader.captcha.v2.solverjob.ResponseList;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.captchasolver.abstractPluginForCaptchaSolver;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;
import org.jdownloader.updatev2.UpdateController;

public class ChallengeResponseController {
    private static final ChallengeResponseController INSTANCE = new ChallengeResponseController();
    private ChallengeResponseEventSender eventSender;
    private LogSource logger;
    private TimeTrackerController trackerCache;
    private final AtomicBoolean init = new AtomicBoolean(false);
    private final HashMap<String, SolverService> solverMap = new HashMap();
    private final List<SolverService> serviceList = new CopyOnWriteArrayList<SolverService>();
    private final List<ChallengeSolver<?>> solverList = new CopyOnWriteArrayList();
    private final List<SolverJob<?>> activeJobs = new ArrayList();
    private final HashMap<UniqueAlltimeID, SolverJob<?>> challengeIDToJobMap = new HashMap();

    public static ChallengeResponseController getInstance() {
        return INSTANCE;
    }

    public ChallengeResponseEventSender getEventSender() {
        return this.eventSender;
    }

    private ChallengeResponseController() {
        this.logger = LogController.getInstance().getLogger(this.getClass().getName());
        this.eventSender = new ChallengeResponseEventSender(this.logger);
        this.trackerCache = new TimeTrackerController();
        HashMap<String, ArrayList<CaptchaQualityEnsuranceRule>> rules = CFG_CAPTCHA.CFG.getQualityEnsuranceRules();
        if (rules == null) {
            rules = new HashMap();
        }
        boolean save = false;
        save = this.addDefaultRules(rules, "recaptchav2", new CaptchaQualityEnsuranceRule(60, 600000), new CaptchaQualityEnsuranceRule(6, 60000), new CaptchaQualityEnsuranceRule(3, 30000), new CaptchaQualityEnsuranceRule(2, 10000)) || save;
        boolean bl = save = this.addDefaultRules(rules, HCaptchaChallenge.getChallengeType(), new CaptchaQualityEnsuranceRule(60, 600000), new CaptchaQualityEnsuranceRule(6, 60000), new CaptchaQualityEnsuranceRule(3, 30000), new CaptchaQualityEnsuranceRule(2, 10000)) || save;
        if (save) {
            CFG_CAPTCHA.CFG.setQualityEnsuranceRules(rules);
        }
        for (Map.Entry<String, ArrayList<CaptchaQualityEnsuranceRule>> es : rules.entrySet()) {
            ArrayList<CaptchaQualityEnsuranceRule> rc = es.getValue();
            TimeTracker tracker = this.trackerCache.getTracker(es.getKey());
            for (CaptchaQualityEnsuranceRule r : rc) {
                this.logger.info("Add Captcha Limit Rule for " + es.getKey() + " " + r.getLimit() + " Reqs in " + TimeFormatter.formatMilliSeconds((long)r.getInterval(), (int)0));
                tracker.addRule(new TrackerRule(r.getLimit(), r.getInterval()));
            }
        }
    }

    private boolean addDefaultRules(HashMap<String, ArrayList<CaptchaQualityEnsuranceRule>> rules, String key, CaptchaQualityEnsuranceRule ... defList) {
        ArrayList<CaptchaQualityEnsuranceRule> rc = rules.get(key);
        if (rc == null || rc.size() == 0) {
            rc = new ArrayList();
            for (CaptchaQualityEnsuranceRule r : defList) {
                rc.add(r);
            }
            rules.put(key, rc);
            return true;
        }
        return false;
    }

    public void init() {
        if (!this.init.compareAndSet(false, true)) {
            return;
        }
        this.addSolver(JACSolver.getInstance());
        this.addSolver(DeathByCaptchaSolver.getInstance());
        this.addSolver(ImageTyperzCaptchaSolver.getInstance());
        this.addSolver(CheapCaptchaSolver.getInstance());
        this.addSolver(TwoCaptchaSolver.getInstance());
        this.addSolver(AntiCaptchaComSolver.getInstance());
        this.addSolver(EndCaptchaSolver.getInstance());
        this.addSolver(Captcha9kwSolver.getInstance());
        this.addSolver(Captcha9kwSolverClick.getInstance());
        this.addSolver(Captcha9kwSolverMultiClick.getInstance());
        this.addSolver(Captcha9kwSolverPuzzle.getInstance());
        if (!Application.isHeadless()) {
            this.addSolver(DialogBasicCaptchaSolver.getInstance());
            this.addSolver(DialogClickCaptchaSolver.getInstance());
            this.addSolver(DialogMultiClickCaptchaSolver.getInstance());
            this.addSolver(BrowserSolver.getInstance());
            this.addSolver(OAuthDialogSolver.getInstance());
        }
        this.addSolver(AccountOAuthSolver.getInstance());
        this.addSolver(KeyCaptchaJACSolver.getInstance());
        if (!Application.isHeadless()) {
            this.addSolver(KeyCaptchaDialogSolver.getInstance());
        }
        this.addSolver(CaptchaAPISolver.getInstance());
    }

    public List<ChallengeSolver<?>> listSolvers() {
        return new ArrayList(this.solverList);
    }

    private synchronized boolean addSolver(ChallengeSolver<?> solver) {
        if (this.solverMap.put(solver.getService().getID(), solver.getService()) == null) {
            this.serviceList.add(solver.getService());
        }
        return this.solverList.add(solver);
    }

    public <E> void fireNewAnswerEvent(SolverJob<E> job, AbstractResponse<E> abstractResponse) {
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.JOB_ANSWER, abstractResponse, job));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SolverJob<?>> listJobs() {
        List<SolverJob<?>> list = this.activeJobs;
        synchronized (list) {
            return new ArrayList(this.activeJobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingJobs() {
        List<SolverJob<?>> list = this.activeJobs;
        synchronized (list) {
            return this.activeJobs.size() > 0;
        }
    }

    public void fireBeforeSolveEvent(SolverJob<?> job, ChallengeSolver<?> solver) {
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.SOLVER_START, solver, job));
    }

    public void fireAfterSolveEvent(SolverJob<?> job, ChallengeSolver<?> solver) {
        job.getLogger().info("Solver " + solver + " finished job " + job);
        job._notifyAll();
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.SOLVER_END, solver, job));
    }

    private void fireNewJobEvent(SolverJob<?> job) {
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.NEW_JOB, job));
    }

    private void fireJobDone(SolverJob<?> job) {
        this.eventSender.fireEvent((DefaultEvent)new ChallengeResponseEvent(this, ChallengeResponseEvent.Type.JOB_DONE, job));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipRequest(SkipRequest skipRequest, ChallengeSolver<?> solver, Challenge<?> sourceChallenge) {
        List<SolverJob<?>> list = this.activeJobs;
        synchronized (list) {
            for (SolverJob<?> job : this.activeJobs) {
                if (job.getChallenge() == sourceChallenge) {
                    job.setSkipRequest(skipRequest);
                    continue;
                }
                if (!job.getChallenge().canBeSkippedBy(skipRequest, solver, sourceChallenge)) continue;
                job.setSkipRequest(skipRequest);
            }
        }
    }

    public void keepAlivePendingChallenges(Challenge<?> c) {
        for (SolverJob<?> job : this.activeJobs) {
            job.getChallenge().keepAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SolverJob<T> handle(Challenge<T> c) throws InterruptedException, SkipException {
        LogSource logger;
        if (c instanceof AbstractBrowserChallenge) {
            if (c instanceof RecaptchaV2Challenge) {
                UpdateController.getInstance().addFeedback(new String[]{"rc"});
            } else if (c instanceof HCaptchaChallenge) {
                UpdateController.getInstance().addFeedback(new String[]{"hc"});
            } else if (c instanceof CloudflareTurnstileChallenge) {
                UpdateController.getInstance().addFeedback(new String[]{"tc"});
            }
        }
        if ((logger = LogController.getInstance().getPreviousThreadLogSource()) == null) {
            logger = this.logger;
        }
        logger.info("Log to " + logger.getName());
        logger.info("Handle Challenge: " + c);
        List<ChallengeSolver<T>> solver = this.createList(c);
        logger.info("Solver: " + solver);
        if (solver.size() == 0) {
            logger.info("No solver available!");
            throw new SkipException(c, SkipRequest.BLOCK_HOSTER, "No solver available!");
        }
        SolverJob<T> job = new SolverJob<T>(this, c, solver);
        job.setLogger(logger);
        c.initController(job);
        UniqueAlltimeID challengeID = c.getId();
        List<SolverJob<?>> list = this.activeJobs;
        synchronized (list) {
            this.activeJobs.add(job);
            this.challengeIDToJobMap.put(challengeID, job);
        }
        try {
            for (ChallengeSolver challengeSolver : solver) {
                logger.info("Send to solver: " + challengeSolver + " " + job);
                challengeSolver.enqueue(job);
            }
            logger.info("Fire New Job Event");
            this.fireNewJobEvent(job);
            logger.info("Wait");
            boolean timeout = false;
            while (!job.isSolved() && !job.isDone()) {
                BlacklistEntry blacklistEntry = CaptchaBlackList.getInstance().matches(c);
                Challenge<T> challenge = job.getChallenge();
                challenge.poll(job);
                if (job.isSolved() || job.isDone()) break;
                long validUntil = challenge.getValidUntil();
                if (validUntil != -1L && System.currentTimeMillis() > validUntil) {
                    timeout = true;
                    break;
                }
                job._wait(1000);
                if (blacklistEntry == null || !job.setSkipRequest(SkipRequest.SINGLE)) continue;
                break;
            }
            if (timeout && job.setSkipRequest(SkipRequest.TIMEOUT)) {
                Challenge<T> challenge = job.getChallenge();
                long expired = System.currentTimeMillis() - challenge.getCreated();
                int jobTimeout = challenge.getTimeout();
                logger.info("Challenge Timeout detected|Job:" + job + "|Expired:" + expired + "|Timeout:" + jobTimeout);
            }
            if (!SkipRequest.TIMEOUT.equals((Object)job.getSkipRequest())) {
                this.keepAlivePendingChallenges(c);
            }
            if (job.getSkipRequest() != null) {
                throw new SkipException(c, job.getSkipRequest());
            }
            ResponseList<T> responseList = job.getResponseAndKill();
            logger.info("All Responses: " + job.getResponses());
            logger.info("Solving Done. Result: " + responseList);
            SolverJob<T> solverJob = job;
            return solverJob;
        }
        catch (InterruptedException e) {
            job.kill();
            throw e;
        }
        finally {
            try {
                List<SolverJob<?>> list2 = this.activeJobs;
                synchronized (list2) {
                    this.activeJobs.remove(job);
                    this.challengeIDToJobMap.remove((Object)challengeID);
                }
            }
            finally {
                this.fireJobDone(job);
            }
            c.onHandled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<ChallengeSolver<T>> createList(Challenge<T> c) {
        ArrayList<ChallengeSolver<T>> ret = new ArrayList<ChallengeSolver<T>>();
        for (ChallengeSolver<T> challengeSolver : this.solverList) {
            try {
                if (!challengeSolver.isEnabled() || !challengeSolver.validateLogins() || !challengeSolver.canHandle(c) || !challengeSolver.validateBlackWhite(c)) continue;
                ret.add(challengeSolver);
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            AccountFilter af = new AccountFilter().setEnabled(true).setValid(true).setFeature(LazyPlugin.FEATURE.CAPTCHA_SOLVER);
            ArrayList<Account> arrayList = AccountController.getInstance().listAccounts(af);
            HashSet<String> unavailableSolverDomains = new HashSet<String>();
            for (Account solverAccount : arrayList) {
                boolean success = false;
                try {
                    abstractPluginForCaptchaSolver plugin = (abstractPluginForCaptchaSolver)solverAccount.getPlugin();
                    PluginChallengeSolver<T> solver = plugin.getPluginChallengeSolver(c, solverAccount);
                    if (solver == null) continue;
                    ret.add(solver);
                    success = true;
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
                finally {
                    if (success) {
                        unavailableSolverDomains.remove(solverAccount.getHoster());
                        continue;
                    }
                    unavailableSolverDomains.add(solverAccount.getHoster());
                }
            }
            this.logger.info("Solver accounts that cannot be used for this challenge: " + unavailableSolverDomains);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolverJob<?> getJobByChallengeId(long id) {
        HashMap<UniqueAlltimeID, SolverJob<?>> hashMap = this.challengeIDToJobMap;
        synchronized (hashMap) {
            return this.challengeIDToJobMap.get((Object)new UniqueAlltimeID(id));
        }
    }

    public List<SolverService> listServices() {
        return new ArrayList<SolverService>(this.serviceList);
    }

    public SolverService getServiceByID(String key) {
        for (SolverService service : this.serviceList) {
            if (!service.getID().equals(key)) continue;
            return service;
        }
        return null;
    }

    public void resetTiming() {
        HashSet<SolverService> dupe = new HashSet<SolverService>();
        for (ChallengeSolver<?> s : this.solverList) {
            if (!dupe.add(s.getService())) continue;
            s.getService().getConfig().setWaitForMap(null);
        }
    }

    public TimeTracker getTracker(String method) {
        return this.trackerCache.getTracker(method);
    }
}

