/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.adscaptcha;

import java.net.URL;
import javax.swing.SwingUtilities;
import jd.http.Browser;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.PluginException;
import org.jdownloader.captcha.v2.challenge.adscaptcha.SliderCaptchaDialog;

public class AdsCaptcha {
    private final Browser br;
    public Browser acBr;
    private String challenge;
    private String publicKey;
    private String captchaAddress;
    private String captchaId;
    private String result;
    private int count = -1;

    public AdsCaptcha(Browser br) {
        this.br = br;
    }

    public Form getResult() throws Exception {
        try {
            this.load();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new PluginException(131072, e.getMessage());
        }
        finally {
            try {
                this.acBr.getHttpConnection().disconnect();
            }
            catch (Throwable throwable) {}
        }
        Form ret = new Form();
        if (this.result == null) {
            return null;
        }
        ret.put("aera", this.result);
        ret.put("adscaptcha_challenge_field", this.challenge);
        ret.put("adscaptcha_response_field", this.result);
        return ret;
    }

    private void load() throws Exception {
        this.acBr = this.br.cloneBrowser();
        if (!this.checkIfSupported()) {
            throw new Exception("AdsCaptcha: Captcha type not supported!");
        }
        this.acBr.getPage(this.captchaAddress);
        this.getChallenge();
        this.getPublicKey();
        this.getImageCount();
        if (this.challenge == null || this.publicKey == null) {
            throw new Exception("AdsCaptcha: challenge and/or publickey equal null!");
        }
        final URL[] images = this.imageUrls();
        if (this.count <= 0 && images.length == 1) {
            throw new Exception("AdsCaptcha modul broken!");
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                SliderCaptchaDialog sc = new SliderCaptchaDialog(0, "AdsCaptcha - " + AdsCaptcha.this.br.getHost(), images, AdsCaptcha.this.count);
                sc.displayDialog();
                AdsCaptcha.this.result = (String)sc.getReturnValue();
            }
        });
    }

    private void getChallenge() {
        this.challenge = this.acBr.getRegex("\"challenge\":\"([0-9a-f\\-]+)\"").getMatch(0);
    }

    private void getPublicKey() {
        this.publicKey = this.acBr.getRegex("\"publicKey\":\"([0-9a-f\\-]+)\"").getMatch(0);
        if (this.publicKey == null) {
            this.publicKey = new Regex(this.captchaAddress, "PublicKey=([0-9a-f\\-]+)&").getMatch(0);
        }
    }

    private void getImageCount() {
        String c = this.acBr.getRegex("\"count\":\"?(\\d+)\"?").getMatch(0);
        if (c != null) {
            this.count = Integer.parseInt(c);
        }
    }

    private boolean checkIfSupported() throws Exception {
        this.captchaAddress = this.acBr.getRegex("src='(https?://api\\.adscaptcha\\.com/Get\\.aspx\\?CaptchaId=\\d+&PublicKey=[^'<>]+)").getMatch(0);
        this.captchaId = new Regex(this.captchaAddress, "CaptchaId=(\\d+)\\&").getMatch(0);
        if (this.captchaAddress == null || this.captchaId == null) {
            throw new Exception("AdsCaptcha: Captcha address not found!");
        }
        return "3671".equals(this.captchaId);
    }

    private URL[] imageUrls() throws Exception {
        this.acBr.getPage("http://api.minteye.com/Slider/SliderData.ashx?cid=" + this.challenge + "&CaptchaId=" + this.captchaId + "&PublicKey=" + this.publicKey + "&w=180&h=150");
        String[] urls = this.acBr.getRegex("\\{'src':\\s'(https?://[^']+)'\\}").getColumn(0);
        if (urls == null || urls.length == 0) {
            urls = this.acBr.getRegex("\\{'src':\\s'(//[^']+)'\\}").getColumn(0);
        }
        if (urls == null || urls.length == 0) {
            urls = this.acBr.getRegex("('|\")spriteUrl\\1:\\s*('|\")(.*?)\\2").getColumn(2);
        }
        if (urls == null || urls.length == 0) {
            throw new Exception("AdsCaptcha: Image urls not found!");
        }
        URL[] out = new URL[urls.length];
        int i = 0;
        for (String u : urls) {
            if (u.startsWith("//")) {
                u = "http:" + u;
            }
            out[i++] = new URL(u);
        }
        return out;
    }

    public String getChallengeId() {
        return this.challenge;
    }

    public String getCaptchaUrl() {
        return this.captchaAddress;
    }

    public String getResultValue() {
        return this.result;
    }
}

