/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.confidentcaptcha;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.exceptions.BadRequestException;
import org.appwork.remoteapi.exceptions.RemoteAPIException;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.IO;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserReference;

public abstract class ConfidentCaptchaChallenge
extends AbstractBrowserChallenge {
    private String siteKey;

    public String getSiteKey() {
        return this.siteKey;
    }

    public ConfidentCaptchaChallenge(Plugin plugin, String siteKey) {
        super("confidentcaptcha", plugin);
        this.siteKey = siteKey;
        if (siteKey == null) {
            throw new WTFException("Bad SiteKey");
        }
    }

    @Override
    public boolean onPostRequest(BrowserReference browserReference, PostRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        List params = request.getPostParameter();
        ArrayList<String[]> t = new ArrayList<String[]>();
        if (params != null) {
            for (KeyValuePair param : params) {
                String[] tt = new String[]{param.key, param.value};
                t.add(tt);
            }
        }
        if (t.size() == 0) {
            throw new BadRequestException("Missing 'confidentcaptcha' values!");
        }
        String[][] output = new String[t.size()][2];
        for (int i = 0; i != t.size(); ++i) {
            output[i] = (String[])t.get(i);
        }
        browserReference.onResponse(JSonStorage.serializeToJson((Object)output));
        response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
        response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html; charset=utf-8"));
        response.getOutputStream(true).write("Please Close the Browser now".getBytes("UTF-8"));
        return true;
    }

    @Override
    protected String getCaptchaNameSpace() {
        return "confident";
    }

    @Override
    public boolean onRawPostRequest(BrowserReference browserReference, PostRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        if (request.getRequestedURL().endsWith("/confidentincludes/callback.php")) {
            Browser c = new Browser();
            c.getHeaders().put("Referer", this.getPluginBrowser().getURL());
            for (HTTPHeader header1 : this.getPluginBrowser().getRequest().getHeaders()) {
                String h1K = header1.getKey();
                String h1V = header1.getValue();
                c.getHeaders().put(h1K, h1V);
            }
            for (HTTPHeader header2 : request.getRequestHeaders()) {
                String h2K = header2.getKey();
                String h2V = header2.getValue();
                String hcV = c.getHeaders().get(h2K);
                if (h2V.contains("127.0.0.1") || h2K.equals("User-Agent") || h2K.equals("Connection") || h2K.equals("Content-Length") || h2K.equals(hcV)) continue;
                c.getHeaders().put(h2K, h2V);
            }
            for (HTTPHeader header3 : c.getHeaders()) {
                String h3K = header3.getKey();
                String r3V = request.getRequestHeaders().getValue(h3K);
                if (r3V != null) continue;
                c.getHeaders().remove(h3K);
            }
            String postargs = "";
            List params = request.getPostParameter();
            for (KeyValuePair param : params) {
                String key = param.key;
                String value = param.value;
                postargs = postargs + key + "=" + Encoding.urlEncode((String)value) + "&";
            }
            postargs = (String)postargs.subSequence(0, postargs.length() - 1);
            c.postPage(this.getPluginBrowser().getBaseURL() + "confidentincludes/callback.php", postargs);
            response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html; charset=utf-8"));
            response.getOutputStream(true).write(c.getRequest().getHtmlCode().getBytes("UTF-8"));
            return true;
        }
        return false;
    }

    @Override
    public String getHTML(HttpRequest request, String id) {
        try {
            URL url = ConfidentCaptchaChallenge.class.getResource("confidentcaptcha.html");
            String html = IO.readURLToString((URL)url);
            html = html.replace("%%%sitekey%%%", this.siteKey);
            return html;
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }
}

