/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.cutcaptcha;

import java.io.IOException;
import java.net.URL;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.exceptions.RemoteAPIException;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserReference;

public abstract class CutCaptchaChallenge
extends AbstractBrowserChallenge {
    private final String siteKey;
    private final String apiKey;

    public String getSiteKey() {
        return this.siteKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getSiteUrl() {
        return this.getPluginBrowser().getURL();
    }

    public CutCaptchaChallenge(Plugin plugin, String siteKey, String apiKey) {
        super("cutcaptcha", plugin);
        if (!CutCaptchaChallenge.looksLikeValidSiteKey(siteKey)) {
            throw new WTFException("Bad SiteKey:" + siteKey);
        }
        if (!CutCaptchaChallenge.looksLikeValidApiKey(apiKey)) {
            throw new WTFException("Bad APIKey:" + apiKey);
        }
        this.siteKey = siteKey;
        this.apiKey = apiKey;
    }

    private static boolean looksLikeValidSiteKey(String siteKey) {
        if (siteKey == null) {
            return false;
        }
        return siteKey.matches("^[a-f0-9]{40}$");
    }

    private static boolean looksLikeValidApiKey(String siteKey) {
        if (siteKey == null) {
            return false;
        }
        return siteKey.matches("^[\\w-]{5,}$");
    }

    @Override
    public boolean onGetRequest(BrowserReference browserReference, GetRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        String parameter = request.getParameterbyKey("response");
        if (StringUtils.isNotEmpty((String)parameter)) {
            browserReference.onResponse(parameter);
            response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html; charset=utf-8"));
            response.getOutputStream(true).write("Please Close the Browser now".getBytes("UTF-8"));
            return true;
        }
        return super.onGetRequest(browserReference, request, response);
    }

    @Override
    public boolean onPostRequest(BrowserReference browserReference, PostRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        return false;
    }

    @Override
    public String getHTML(HttpRequest request, String id) {
        try {
            URL url = CutCaptchaChallenge.class.getResource("cutcaptcha.html");
            String html = IO.readURLToString((URL)url);
            html = html.replace("%%%sitekey%%%", this.siteKey);
            return html;
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }

    @Override
    public boolean isCaptchaResponseValid() {
        return super.isCaptchaResponseValid() && CutCaptchaChallenge.looksLikeValidToken((String)this.getResult().getValue());
    }

    @Override
    protected String getCaptchaNameSpace() {
        return "cut";
    }

    public static boolean looksLikeValidToken(String str) {
        return str != null && str.matches("[\\w-]{10,}");
    }

    @Override
    public boolean validateResponse(AbstractResponse<String> response) {
        return super.validateResponse(response) && CutCaptchaChallenge.looksLikeValidToken(response.getValue());
    }
}

