/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.utils.JDUtilities;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptcha;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaImages;

class KeyCaptchaImageGetter {
    private Image[] IMAGE;
    private BufferedImage[] kcImages;
    private final LinkedHashMap<String, int[]> coordinates;
    private int kcSampleImg;
    private KeyCaptchaImages keyCaptchaImage;
    private KeyCaptcha helper;

    public KeyCaptchaImageGetter(KeyCaptcha keyCaptcha, String[] imageUrl, LinkedHashMap<String, int[]> coordinates, Browser br, String url) throws Exception {
        this.coordinates = coordinates;
        this.helper = keyCaptcha;
        this.loadImage(imageUrl);
        this.handleCoordinates();
        this.makePieces();
        this.makeBackground();
        LinkedList<BufferedImage> pieces = new LinkedList<BufferedImage>();
        BufferedImage sampleImg = null;
        for (int i = 1; i < this.kcImages.length; ++i) {
            if (this.kcImages[i] == null) continue;
            if (i == this.kcSampleImg) {
                sampleImg = this.kcImages[i];
                continue;
            }
            pieces.add(this.kcImages[i]);
        }
        this.keyCaptchaImage = new KeyCaptchaImages(this.kcImages[0], sampleImg, pieces);
    }

    public KeyCaptchaImages getKeyCaptchaImage() {
        return this.keyCaptchaImage;
    }

    public void handleCoordinates() {
        this.kcImages = new BufferedImage[this.coordinates.size()];
    }

    public void loadImage(String[] imagesUrl) {
        int i = 0;
        this.IMAGE = new Image[imagesUrl.length];
        Browser dlpic = new Browser();
        this.helper.prepareBrowser(dlpic, "image/png,image/*;q=0.8,*/*;q=0.5");
        MediaTracker mt = new MediaTracker(new JLabel());
        for (String imgUrl : imagesUrl) {
            try {
                File fragmentedPic = JDUtilities.getResourceFile("captchas/" + imgUrl.substring(imgUrl.lastIndexOf("/") + 1));
                fragmentedPic.deleteOnExit();
                Browser.download((File)fragmentedPic, (URLConnectionAdapter)dlpic.openGetConnection(imgUrl));
                this.IMAGE[i] = ImageIO.read(fragmentedPic);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            mt.addImage(this.IMAGE[i], i);
            ++i;
        }
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void makeBackground() {
        int curx = 0;
        this.kcImages[0] = new BufferedImage(450, 160, 1);
        Graphics go = this.kcImages[0].getGraphics();
        go.setColor(Color.WHITE);
        go.fillRect(0, 0, 450, 160);
        int[] bgCoord = this.coordinates.get("backGroundImage");
        for (int cik = 0; cik < bgCoord.length; cik += 4) {
            go.drawImage(this.IMAGE[1], bgCoord[cik], bgCoord[cik + 1], bgCoord[cik] + bgCoord[cik + 2], bgCoord[cik + 1] + bgCoord[cik + 3], curx, 0, curx + bgCoord[cik + 2], bgCoord[cik + 3], null);
            curx += bgCoord[cik + 2];
        }
    }

    private void makePieces() {
        Object[] key = this.coordinates.keySet().toArray();
        int pieces = 1;
        for (Object element : key) {
            if (element.equals("backGroundImage")) continue;
            int[] imgcs = this.coordinates.get(element);
            if (imgcs == null || imgcs.length == 0) break;
            int w = imgcs[1] + imgcs[5] + imgcs[9];
            int h = imgcs[3] + imgcs[15] + imgcs[27];
            int dX = 0;
            int dY = 0;
            this.kcImages[pieces] = new BufferedImage(w, h, 2);
            Graphics go = this.kcImages[pieces].getGraphics();
            if (element.equals("kc_sample_image")) {
                this.kcSampleImg = pieces;
            }
            int sX = 0;
            int sY = 0;
            int sW = 0;
            int sH = 0;
            dX = 0;
            dY = 0;
            for (int cik2 = 0; cik2 < 36; cik2 += 4) {
                sX = imgcs[cik2];
                sY = imgcs[cik2 + 2];
                sW = imgcs[cik2 + 1];
                sH = imgcs[cik2 + 3];
                if (sX + sW > this.IMAGE[0].getWidth(null) || sY + sH > this.IMAGE[0].getHeight(null) || dX + sW > w || dY + sH > h || sW == 0 || sH == 0) continue;
                go.drawImage(this.IMAGE[0], dX, dY, dX + sW, dY + sH, sX, sY, sX + sW, sY + sH, null);
                if ((dX += sW) < w) continue;
                dY += sH;
                dX = 0;
            }
            ++pieces;
        }
    }
}

