/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha;

import java.awt.image.BufferedImage;
import java.io.IOException;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.utils.images.IconIO;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptcha;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaApiResponse;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaResponse;

public class KeyCaptchaPuzzleChallenge
extends Challenge<String> {
    private final KeyCaptcha helper;
    private final boolean noAutoSolver;
    private final Plugin plugin;

    public KeyCaptcha getHelper() {
        return this.helper;
    }

    @Override
    public AbstractResponse<String> parseAPIAnswer(String result, String resultFormat, ChallengeSolver<?> solver) {
        String token;
        KeyCaptchaApiResponse response = (KeyCaptchaApiResponse)JSonStorage.restoreFromString((String)result, (TypeRef)new TypeRef<KeyCaptchaApiResponse>(){});
        try {
            token = this.helper.sendPuzzleResult(response.getMouseArray(), response.getOut());
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
        if (token != null) {
            return new KeyCaptchaResponse((Challenge<String>)this, solver, token, 100);
        }
        return null;
    }

    public Storable getAPIStorable(String format) throws Exception {
        APIData ret = new APIData();
        String[] pieces = new String[this.getHelper().getPuzzleData().getImages().pieces.size()];
        for (int i = 0; i < pieces.length; ++i) {
            pieces[i] = IconIO.toDataUrl((BufferedImage)this.getHelper().getPuzzleData().getImages().pieces.get(i), (IconIO.DataURLFormat)IconIO.DataURLFormat.PNG);
        }
        ret.setPieces(pieces);
        ret.setBackground(IconIO.toDataUrl((BufferedImage)this.getHelper().getPuzzleData().getImages().backgroundImage, (IconIO.DataURLFormat)IconIO.DataURLFormat.JPG));
        ret.setSample(IconIO.toDataUrl((BufferedImage)this.getHelper().getPuzzleData().getImages().sampleImage, (IconIO.DataURLFormat)IconIO.DataURLFormat.JPG));
        return ret;
    }

    public boolean isNoAutoSolver() {
        return this.noAutoSolver;
    }

    public KeyCaptchaPuzzleChallenge(KeyCaptcha keyCaptcha, Plugin plg, boolean noAutoSolver) {
        super("keyCaptchaPuzzle", null);
        this.helper = keyCaptcha;
        this.plugin = plg;
        this.noAutoSolver = noAutoSolver;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    public static class APIData
    implements Storable {
        private String[] pieces;
        private String sample;
        private String background;

        public String[] getPieces() {
            return this.pieces;
        }

        public void setPieces(String[] pieces) {
            this.pieces = pieces;
        }

        public String getBackground() {
            return this.background;
        }

        public void setBackground(String categories) {
            this.background = categories;
        }

        public String getSample() {
            return this.sample;
        }

        public void setSample(String sample) {
            this.sample = sample;
        }
    }
}

