/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha.dialog;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtIconColumn;
import org.jdownloader.captcha.v2.challenge.keycaptcha.CategoryData;
import org.jdownloader.captcha.v2.challenge.keycaptcha.dialog.CatOption;

public class CatModel
extends ExtTableModel<CatOption> {
    private ImageIcon[] cats;

    public CatModel(CategoryData data) {
        super("CatModel");
        int i = 0;
        this.cats = new ImageIcon[3];
        BufferedImage bg = data.getBackground();
        for (i = 0; i < 3; ++i) {
            BufferedImage cats = new BufferedImage(bg.getWidth() / 3, bg.getHeight(), 2);
            Graphics2D g = (Graphics2D)cats.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(bg, 0, 0, bg.getWidth() / 3, bg.getHeight(), i * bg.getWidth() / 3, 0, (i + 1) * bg.getWidth() / 3, bg.getHeight(), null);
            g.dispose();
            this.cats[i] = new ImageIcon(cats);
        }
        for (Image img : data.getImages()) {
            this.addElement(new CatOption(i++, img));
        }
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new CatColum(0){});
        this.addColumn((ExtColumn)new CatColum(1){});
        this.addColumn((ExtColumn)new CatColum(2){});
    }

    public class CatColum
    extends ExtIconColumn<CatOption> {
        private int catID;

        public CatColum(int i) {
            super("Column " + i);
            this.catID = i;
        }

        public boolean isResizable() {
            return true;
        }

        public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
            ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setIcon(CatModel.this.cats[CatColum.this.catID]);
                    this.setHorizontalAlignment(0);
                    this.setText(null);
                    return this;
                }
            };
            return ret;
        }

        public boolean onDoubleClick(MouseEvent e, CatOption obj) {
            return this.onSingleClick(e, obj);
        }

        public boolean onSingleClick(MouseEvent e, CatOption obj) {
            obj.setSelected(this.catID);
            int row = CatModel.this.getRowforObject(obj);
            CatModel.this.getTable().scrollToRow(row, 0);
            CatModel.this.getTable().repaint();
            return true;
        }

        public void configureRendererComponent(CatOption value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.configureRendererComponent((Object)value, isSelected, hasFocus, row, column);
            if (CatModel.this.getTable().getRowHeight(row) != value.getIcon(this.catID).getIconHeight()) {
                CatModel.this.getTable().setRowHeight(row, value.getIcon(this.catID).getIconHeight());
            }
        }

        protected Icon getIcon(CatOption value) {
            return value.getIcon(this.catID);
        }

        public int getDefaultWidth() {
            return -1;
        }

        protected boolean isDefaultResizable() {
            return true;
        }

        public boolean isDefaultVisible() {
            return true;
        }

        public boolean isSortable(CatOption obj) {
            return false;
        }

        public boolean isHidable() {
            return false;
        }

        public int getMaxWidth() {
            return -1;
        }

        public int getMinWidth() {
            return -1;
        }
    }
}

