/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jd.gui.swing.dialog.DialogType;
import net.miginfocom.swing.MigLayout;
import org.appwork.exceptions.ThrowUncheckedException;
import org.appwork.swing.MigPanel;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.DomainInfo;
import org.jdownloader.captcha.v2.AbstractCaptchaDialog;
import org.jdownloader.captcha.v2.challenge.keycaptcha.CategoryData;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptcha;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaCategoryChallenge;
import org.jdownloader.captcha.v2.challenge.keycaptcha.dialog.PicButton;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.HeaderScrollPane;

public class KeyCaptchaCategoryDialog
extends AbstractCaptchaDialog<String>
implements ActionListener {
    private JPanel p;
    private MigPanel pics;
    private int currentIndex;
    private Image image;
    private PicButton pic0;
    private PicButton pic1;
    private PicButton pic2;
    private ArrayList<Integer> positions;
    private int maxHeight;
    private int maxWidth;

    public KeyCaptchaCategoryDialog(KeyCaptchaCategoryChallenge captchaChallenge, int flag, DialogType type, DomainInfo domain) {
        super(captchaChallenge, flag, _GUI.T.KeyCaptchaCategoryDialog(domain.getTld()), type, domain, _GUI.T.KeyCaptchaCategoryDialog_explain(domain.getTld()));
    }

    protected int getPreferredHeight() {
        return -1;
    }

    protected KeyCaptcha getKeyCaptcha() {
        return ((KeyCaptchaCategoryChallenge)this.challenge).getHelper();
    }

    protected int getPreferredWidth() {
        return -1;
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    protected String createReturnValue() {
        if (!Dialog.isOK((Object)this.getReturnmask())) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer i : this.positions) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(Integer.toString(i));
        }
        try {
            return this.getKeyCaptcha().sendCategoryResult(sb.toString());
        }
        catch (Exception e) {
            ThrowUncheckedException.throwUncheckedException((Throwable)e);
            return null;
        }
    }

    @Override
    protected MigLayout getDialogLayout() {
        return super.getDialogLayout();
    }

    public void pack() {
        if (!this.getDialog().isMinimumSizeSet()) {
            this.getDialog().setMinimumSize(new Dimension(300, 300));
        }
        super.pack();
    }

    @Override
    protected HeaderScrollPane createHeaderScrollPane(MigPanel field) {
        HeaderScrollPane ret = new HeaderScrollPane((JComponent)field);
        return ret;
    }

    @Override
    protected JPanel createCaptchaPanel() {
        this.p = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]", "[][][]"));
        SwingUtils.setOpaque((JComponent)this.p, (boolean)false);
        JLabel lbl = new JLabel("<html>" + this.getHelpText().replace("\r\n", "<br>") + "</html>");
        this.p.add(lbl);
        SwingUtils.setOpaque((JComponent)lbl, (boolean)false);
        CategoryData data = this.getKeyCaptcha().getCategoryData();
        MigPanel bgs = new MigPanel("ins 0,wrap 3", "[grow,fill][grow,fill][grow,fill]", "[]");
        SwingUtils.setOpaque((JComponent)bgs, (boolean)false);
        BufferedImage bg = data.getBackground();
        for (int i = 0; i < 3; ++i) {
            BufferedImage cats = new BufferedImage(bg.getWidth() / 3, bg.getHeight(), 2);
            Graphics2D g = (Graphics2D)cats.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(bg, 0, 0, bg.getWidth() / 3, bg.getHeight(), i * bg.getWidth() / 3, 0, (i + 1) * bg.getWidth() / 3, bg.getHeight(), null);
            g.dispose();
            bgs.add((Component)new JLabel(new ImageIcon(cats)));
        }
        this.maxHeight = 0;
        this.maxWidth = 0;
        for (Image img : data.getImages()) {
            JButton bt = new JButton(new ImageIcon(img));
            Dimension pref = bt.getPreferredSize();
            this.maxWidth = Math.max(pref.width, this.maxWidth);
            this.maxHeight = Math.max(pref.height, this.maxHeight);
        }
        this.pics = new MigPanel("ins 0,wrap 3", "[grow,fill][grow,fill][grow,fill]", "[]");
        SwingUtils.setOpaque((JComponent)this.pics, (boolean)false);
        this.positions = new ArrayList();
        this.p.add((Component)bgs);
        this.p.add((Component)this.pics);
        SwingUtils.setOpaque((JComponent)lbl, (boolean)false);
        this.okButton.setEnabled(false);
        this.setImage(0);
        return this.p;
    }

    private void setImage(int i) {
        this.currentIndex = i;
        if (this.pic0 != null) {
            int position = 0;
            if (this.pic0.isSelected()) {
                position = 1;
            } else if (this.pic1.isSelected()) {
                position = 2;
            } else if (this.pic2.isSelected()) {
                position = 3;
            }
            this.positions.add(position);
        }
        if (i >= this.getKeyCaptcha().getCategoryData().getImages().size()) {
            this.okButton.setEnabled(true);
            this.pic0.setEnabled(false);
            this.pic1.setEnabled(false);
            this.pic2.setEnabled(false);
            this.okButton.doClick();
            return;
        }
        this.image = this.getKeyCaptcha().getCategoryData().getImages().get(i);
        this.pics.removeAll();
        this.pic0 = new PicButton(0, this, this.image);
        this.pics.add((Component)this.pic0);
        this.pic1 = new PicButton(1, this, this.image);
        this.pics.add((Component)this.pic1);
        this.pic2 = new PicButton(2, this, this.image);
        this.pics.add((Component)this.pic2);
        this.pic0.setPreferredSize(new Dimension(this.maxWidth, this.maxHeight));
        this.pic1.setPreferredSize(new Dimension(this.maxWidth, this.maxHeight));
        this.pic2.setPreferredSize(new Dimension(this.maxWidth, this.maxHeight));
        this.pics.revalidate();
        this.pics.repaint();
    }

    public void updateIcons(PicButton picButton) {
        this.pic0.setSelected(this.pic0 == picButton);
        this.pic1.setSelected(this.pic1 == picButton);
        this.pic2.setSelected(this.pic2 == picButton);
        this.pic0.updateIcon();
        this.pic1.updateIcon();
        this.pic2.updateIcon();
    }

    public void next() {
        this.setImage(this.currentIndex + 1);
    }
}

