/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.updatev2.gui.LAFOptions;

class KeyCaptchaDrawBackgroundPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final BufferedImage image;

    public KeyCaptchaDrawBackgroundPanel(BufferedImage image) {
        this.image = IconIO.colorRangeToTransparency((BufferedImage)image, (Color)Color.WHITE, (double)0.15);
        SwingUtils.setOpaque((JComponent)this, (boolean)true);
        LAFOptions.applyBackground((Color)LAFOptions.getInstance().getColorForPanelBackground(), (JComponent)this);
        this.setBounds(0, 0, image.getWidth(), image.getHeight());
        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
        return super.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this);
        }
    }
}

