/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import jd.gui.swing.dialog.DialogType;
import net.miginfocom.swing.MigLayout;
import org.appwork.exceptions.ThrowUncheckedException;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.DomainInfo;
import org.jdownloader.captcha.v2.AbstractCaptchaDialog;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptcha;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaImages;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaPuzzleChallenge;
import org.jdownloader.captcha.v2.challenge.keycaptcha.dialog.KeyCaptchaDragPieces;
import org.jdownloader.captcha.v2.challenge.keycaptcha.dialog.KeyCaptchaDrawBackgroundPanel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class KeyCaptchaPuzzleDialog
extends AbstractCaptchaDialog<String>
implements ActionListener {
    private JLayeredPane drawPanel;
    private JPanel p;
    ArrayList<Integer> mouseArray;
    private KeyCaptchaImages imageData;

    public KeyCaptchaPuzzleDialog(KeyCaptchaPuzzleChallenge captchaChallenge, int flag, DialogType type, DomainInfo domain) {
        super(captchaChallenge, flag, _GUI.T.KeyCaptchaDialog(domain.getTld()), type, domain, _GUI.T.KeyCaptchaDialog_explain(domain.getTld()));
        this.imageData = captchaChallenge.getHelper().getPuzzleData().getImages();
    }

    protected KeyCaptcha getKeyCaptcha() {
        return ((KeyCaptchaPuzzleChallenge)this.challenge).getHelper();
    }

    protected int getPreferredHeight() {
        return -1;
    }

    protected int getPreferredWidth() {
        return -1;
    }

    protected boolean isResizable() {
        return false;
    }

    @Override
    protected String createReturnValue() {
        if (!Dialog.isOK((Object)this.getReturnmask())) {
            return null;
        }
        try {
            return this.getKeyCaptcha().sendPuzzleResult(this.mouseArray, this.getPosition(this.drawPanel));
        }
        catch (Exception e) {
            ThrowUncheckedException.throwUncheckedException((Throwable)e);
            return null;
        }
    }

    private String getPosition(JLayeredPane drawPanel) {
        int i = 0;
        String positions = "";
        Component[] comp = drawPanel.getComponents();
        for (int c = comp.length - 1; c >= 0; --c) {
            if (comp[c].getMouseListeners().length == 0) continue;
            Point p = comp[c].getLocation();
            positions = positions + (i != 0 ? "." : "") + String.valueOf(p.x) + "." + String.valueOf(p.y);
            ++i;
        }
        return positions;
    }

    @Override
    protected MigLayout getDialogLayout() {
        return super.getDialogLayout();
    }

    @Override
    protected JPanel createCaptchaPanel() {
        KeyCaptchaPuzzleChallenge challenge = (KeyCaptchaPuzzleChallenge)this.challenge;
        this.p = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]", "[][grow,fill]"));
        JLabel lbl = new JLabel("<html>" + this.getHelpText().replace("\r\n", "<br>") + "</html>");
        this.p.add(lbl);
        SwingUtils.setOpaque((JComponent)lbl, (boolean)false);
        this.drawPanel = new JLayeredPane();
        LAFOptions.applyBackground((Color)LAFOptions.getInstance().getColorForPanelBackground(), (JComponent)this.p);
        LAFOptions.applyBackground((Color)LAFOptions.getInstance().getColorForPanelBackground(), (JComponent)this.drawPanel);
        int offset = 4;
        KeyCaptchaDrawBackgroundPanel background = new KeyCaptchaDrawBackgroundPanel(this.imageData.backgroundImage);
        this.drawPanel.add(background, JLayeredPane.DEFAULT_LAYER, JLayeredPane.DEFAULT_LAYER);
        this.mouseArray = new ArrayList();
        this.drawPanel.add(new KeyCaptchaDragPieces(this.imageData.sampleImage, offset, true, this.mouseArray, challenge), JLayeredPane.DEFAULT_LAYER + 0, JLayeredPane.DEFAULT_LAYER + 0);
        System.out.println("PIeces " + this.imageData.pieces.size());
        for (int i = 0; i < this.imageData.pieces.size(); ++i) {
            this.drawPanel.add(new KeyCaptchaDragPieces(this.imageData.pieces.get(i), offset, false, this.mouseArray, challenge), JLayeredPane.DEFAULT_LAYER + (i + 1), JLayeredPane.DEFAULT_LAYER + (i + 1));
            offset += 4;
        }
        this.p.add(this.drawPanel);
        this.drawPanel.setPreferredSize(background.getPreferredSize());
        return this.p;
    }
}

