/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha.dialog;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.images.IconIO;
import org.jdownloader.captcha.v2.challenge.keycaptcha.dialog.KeyCaptchaCategoryDialog;

public class PicButton
extends JButton
implements ActionListener,
MouseListener {
    private int position;
    private KeyCaptchaCategoryDialog owner;
    private Image image;
    private BufferedImage gray;
    private boolean mouseover = false;

    public PicButton(int i, KeyCaptchaCategoryDialog keyCaptchaCategoryDialog, Image image) {
        this.position = i;
        this.owner = keyCaptchaCategoryDialog;
        this.image = image;
        this.gray = ImageProvider.convertToGrayScale((Image)IconIO.toBufferedImage((Image)IconIO.getTransparent((Image)image, (float)0.2f)));
        this.setSelected(i == 1);
        this.addActionListener(this);
        this.addMouseListener(this);
        this.updateIcon();
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        this.updateIcon();
    }

    void updateIcon() {
        if (this.mouseover) {
            this.setIcon(new ImageIcon(this.image));
        } else {
            this.setIcon(new ImageIcon(this.gray));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.owner.updateIcons(this);
        this.owner.next();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseover = true;
        this.updateIcon();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseover = false;
        this.updateIcon();
    }
}

