/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.sweetcaptcha;

import java.io.IOException;
import java.net.URL;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.exceptions.RemoteAPIException;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserReference;

public abstract class SweetCaptchaChallenge
extends AbstractBrowserChallenge {
    private String siteKey;
    private String appKey;

    public final String getAppKey() {
        return this.appKey;
    }

    public String getSiteKey() {
        return this.siteKey;
    }

    public SweetCaptchaChallenge(String siteKey, String appKey, Plugin pluginForHost) {
        super("sweetcaptcha", pluginForHost);
        this.siteKey = siteKey;
        this.appKey = appKey;
        if (siteKey == null || !siteKey.matches("^sc_[a-f0-9]{7}$")) {
            throw new WTFException("Bad SiteKey");
        }
    }

    @Override
    public boolean onPostRequest(BrowserReference browserReference, PostRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        String sckey = request.getParameterbyKey("sckey");
        String scvalue = request.getParameterbyKey("scvalue");
        String scvalue2 = request.getParameterbyKey("scvalue2");
        if (StringUtils.isNotEmpty((String)sckey) && StringUtils.isNotEmpty((String)scvalue) && StringUtils.isNotEmpty((String)scvalue2)) {
            browserReference.onResponse(JSonStorage.serializeToJson((Object)new String[][]{{"sckey", sckey}, {"scvalue", scvalue}, {"scvalue2", scvalue2}}));
            response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html; charset=utf-8"));
            response.getOutputStream(true).write("Please Close the Browser now".getBytes("UTF-8"));
            return true;
        }
        return false;
    }

    @Override
    protected String getCaptchaNameSpace() {
        return "sweet";
    }

    @Override
    public String getHTML(HttpRequest request, String id) {
        try {
            URL url = SweetCaptchaChallenge.class.getResource("sweetcaptcha.html");
            String html = IO.readURLToString((URL)url);
            html = html.replace("%%%sitekey%%%", this.siteKey).replace("%%%appkey%%%", this.appKey);
            return html;
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }
}

