/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.xsolver;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.nutils.Colors;

class Circle {
    int inBorder = 4;
    int outBorder = 2;
    int minArea = 170;
    private Captcha captcha;
    int backgroundColor = 0xFFFFFF;
    private List<PixelObject> objectArray;
    private Letter openCircle;
    Comparator<Integer> isElementColor = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            int[] hsvC2;
            int c = o1;
            int c2 = o2;
            if (Circle.this.isBackground(o1) || Circle.this.isBackground(o2)) {
                return 0;
            }
            if (c == 0 || c2 == 0) {
                return c == c2 ? 1 : 0;
            }
            int[] hsvC = Colors.rgb2hsv((int)c);
            return hsvC[0] == (hsvC2 = Colors.rgb2hsv((int)c2))[0] && (hsvC[1] == hsvC2[1] || hsvC[2] == hsvC2[2] || hsvC[1] / hsvC2[2] == 1 || hsvC[1] / hsvC2[2] == 1) && Colors.getRGBColorDifference2((int)c, (int)c2) < 80.0 ? 1 : 0;
        }
    };

    public Circle(Captcha captcha, List<PixelObject> objectArray) {
        this.captcha = captcha;
        this.objectArray = objectArray;
    }

    private boolean equalElements(int c, int c2) {
        return this.isElementColor.compare(c, c2) == 1;
    }

    private boolean isBackground(int c) {
        return c < 0 || c == this.backgroundColor;
    }

    private PixelObject getCircle(int x, int y, int r) {
        PixelObject b = new PixelObject((PixelGrid)this.captcha);
        int ret = 0;
        for (int i = -this.inBorder; i < this.outBorder / 2; ++i) {
            PixelObject n = new PixelObject((PixelGrid)this.captcha);
            ret += this.circle(x, y, r + i, n);
            if (n.getSize() <= 0) continue;
            b.add(n);
        }
        if (b.getSize() > 10 && b.getArea() > 30) {
            return b;
        }
        return null;
    }

    private int checkBackground(int x, int y, PixelObject n) {
        int c = this.captcha.getPixelValue(x, y);
        boolean b = this.isBackground(c);
        if (!b) {
            n.add(x, y, c);
        }
        return b ? 1 : 0;
    }

    private int circle(int cx, int cy, int radius, PixelObject n) {
        int error = -radius;
        int x = radius;
        int y = 0;
        int ret = 0;
        while (x >= y) {
            ret += this.plot8points(cx, cy, x, y, n);
            ret += this.plot8points(cx - 1, cy, x, y, n);
            ret += this.plot8points(cx, cy - 1, x, y, n);
            error += y;
            if ((error += ++y) < 0) continue;
            error -= --x;
            error -= x;
        }
        return ret;
    }

    private int plot8points(int cx, int cy, int x, int y, PixelObject n) {
        int ret = 0;
        ret += this.plot4points(cx, cy, x, y, n);
        if (x != y) {
            ret += this.plot4points(cx, cy, y, x, n);
        }
        return ret;
    }

    private int plot4points(int cx, int cy, int x, int y, PixelObject n) {
        int ret = 0;
        ret += this.checkBackground(cx + x, cy + y, n);
        if (x != 0) {
            ret += this.checkBackground(cx - x, cy + y, n);
        }
        if (y != 0) {
            ret += this.checkBackground(cx + x, cy - y, n);
        }
        if (x != 0 && y != 0) {
            ret += this.checkBackground(cx - x, cy - y, n);
        }
        return ret;
    }

    private int[] getBounds(PixelObject pixelObject) {
        int x;
        if (pixelObject.getSize() < 5 || pixelObject.getArea() < this.minArea) {
            return null;
        }
        Letter let = pixelObject.toColoredLetter();
        int r = let.getWidth() / 2;
        try {
            int ratio = pixelObject.getHeight() * 100 / pixelObject.getWidth();
            if (ratio > 95 && ratio < 105 || this.equalElements(let.getGrid()[r][0], let.getGrid()[0][r]) || this.equalElements(let.getGrid()[r][let.getWidth() - 1], let.getGrid()[0][r]) || this.equalElements(let.getGrid()[r][0], let.getGrid()[let.getWidth() - 1][r]) || this.equalElements(let.getGrid()[r][let.getWidth() - 1], let.getGrid()[let.getWidth() - 1][r])) {
                return new int[]{let.getLocation()[0] + r, let.getLocation()[1] + let.getWidth()};
            }
        }
        catch (Exception ratio) {
            // empty catch block
        }
        ArrayList<int[]> best = new ArrayList<int[]>();
        int h = let.getLocation()[1] + let.getHeight();
        for (x = let.getLocation()[0]; x < let.getLocation()[0] + let.getWidth(); ++x) {
            int y = let.getLocation()[1];
            int c = this.captcha.grid[x][y];
            if (this.isBackground(c)) continue;
            ++y;
            while (y < h && !this.isBackground(this.captcha.grid[x][y])) {
                ++y;
            }
            int oldy = y;
            while (y < h && (this.isBackground(this.captcha.grid[x][y]) || !this.equalElements(c, this.captcha.grid[x][y]))) {
                ++y;
            }
            if (oldy == y || h < y) continue;
            oldy = y;
            while (y < h && !this.isBackground(this.captcha.grid[x][y])) {
                ++y;
            }
            if (oldy == y || y == let.getHeight() && Math.abs(let.getHeight() - let.getWidth()) > 15) continue;
            if (best.size() > 0) {
                if (y > ((int[])best.get(0))[0]) {
                    best = new ArrayList();
                    best.add(new int[]{x, y});
                    continue;
                }
                if (y != ((int[])best.get(0))[1]) continue;
                best.add(new int[]{x, y});
                continue;
            }
            best.add(new int[]{x, y});
        }
        if (best.size() == 0) {
            return null;
        }
        x = 0;
        for (int[] is : best) {
            x += is[0];
        }
        return new int[]{x / best.size(), ((int[])best.get(0))[1]};
    }

    private void addCircles(PixelObject pixelObject, List<PixelObject> obnew) {
        int ratio;
        PixelObject object;
        if (pixelObject.getArea() < this.minArea) {
            return;
        }
        int[] bounds = this.getBounds(pixelObject);
        int r = 0;
        if (bounds != null && (object = this.getCircle(bounds[0], bounds[1] - (r = (bounds[1] - pixelObject.getLocation()[1]) / 2), r)) != null && (ratio = object.getHeight() * 100 / object.getWidth()) > 90 && ratio < 110) {
            obnew.add(object);
            pixelObject.del(object);
        }
    }

    private static BufferedImage copyImage(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        WritableRaster raster = image.copyData(null);
        return new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
    }

    private boolean outOfBounds(BufferedImage img, int x, int y) {
        if (x >= img.getWidth()) {
            return true;
        }
        if (x < 0) {
            return true;
        }
        if (y >= img.getHeight()) {
            return true;
        }
        return y < 0;
    }

    private BufferedImage expandImage(BufferedImage src) {
        BufferedImage tgt = Circle.copyImage(src);
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                int c = src.getRGB(x, y);
                if (!(Colors.getCMYKColorDifference1((int)c, (int)Color.WHITE.getRGB()) > 4.0)) continue;
                tgt.setRGB(x, y, c);
                if (x >= src.getWidth() - 1) continue;
                tgt.setRGB(x, y, c);
                if (!this.outOfBounds(src, x, y - 1)) {
                    tgt.setRGB(x, y - 1, c);
                }
                if (!this.outOfBounds(src, x + 1, y)) {
                    tgt.setRGB(x + 1, y, c);
                }
                if (!this.outOfBounds(src, x, y + 1)) {
                    tgt.setRGB(x, y + 1, c);
                }
                if (this.outOfBounds(src, x - 1, y)) continue;
                tgt.setRGB(x - 1, y, c);
            }
        }
        return tgt;
    }

    public List<PixelObject> getCircles() {
        ArrayList<PixelObject> obnew = new ArrayList<PixelObject>();
        for (PixelObject pixelObject : this.objectArray) {
            if (pixelObject.getArea() <= this.minArea) continue;
            this.addCircles(pixelObject, obnew);
        }
        return obnew;
    }

    private int getLongestOff(BufferedImage img, int r) {
        int xc = (int)((double)img.getWidth() / 2.0);
        int yc = (int)((double)img.getHeight() / 2.0);
        int longestOff = 0;
        int tmp = 0;
        Double theta = 0.0;
        while (theta < Math.PI * 3) {
            double x = (double)r * Math.cos(theta) + (double)xc;
            double y = (double)r * Math.sin(theta) + (double)yc;
            int color = img.getRGB((int)x, (int)y);
            if (Colors.getCMYKColorDifference1((int)Color.white.getRGB(), (int)color) > 5.0) {
                tmp = 0;
            } else if (++tmp > longestOff) {
                longestOff = tmp;
            }
            theta = theta + 0.1;
        }
        return longestOff;
    }

    Letter getOpenCircle() {
        if (this.openCircle != null) {
            return this.openCircle;
        }
        this.objectArray = this.getCircles();
        Letter best = null;
        int maxLongestOff = Integer.MIN_VALUE;
        for (PixelObject pixelObject : this.objectArray) {
            Letter let = pixelObject.toColoredLetter();
            int tmp = this.getLongestOff(this.expandImage(let.getImage()), (int)((double)Math.min(let.getHeight(), let.getWidth()) / 2.0) - 2);
            if (tmp <= maxLongestOff) continue;
            maxLongestOff = tmp;
            best = let;
        }
        this.openCircle = best;
        return best;
    }
}

