/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.browser;

import java.awt.Rectangle;
import java.io.IOException;
import jd.http.Browser;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.remoteapi.exceptions.RemoteAPIException;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserReference;
import org.jdownloader.captcha.v2.solver.browser.BrowserViewport;
import org.jdownloader.captcha.v2.solver.browser.BrowserWindow;
import org.jdownloader.logging.LogController;

public abstract class AbstractBrowserChallenge
extends Challenge<String> {
    protected final Plugin plugin;
    protected final Browser pluginBrowser;

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    public Browser getPluginBrowser() {
        return this.pluginBrowser;
    }

    protected AbstractBrowserChallenge(String method, Plugin plugin, Browser pluginBrowser) {
        super(method, null);
        this.plugin = plugin;
        this.pluginBrowser = pluginBrowser;
    }

    public AbstractBrowserChallenge(String method, Plugin plugin) {
        super(method, null);
        this.plugin = plugin == null ? Plugin.getCurrentActivePlugin() : plugin;
        this.pluginBrowser = this.plugin instanceof PluginForHost ? ((PluginForHost)this.plugin).getBrowser() : (this.plugin instanceof PluginForDecrypt ? ((PluginForDecrypt)this.plugin).getBrowser() : null);
    }

    protected LogInterface getLogger() {
        LogInterface ret = null;
        if (this.plugin != null && (ret = this.plugin.getLogger()) == null) {
            ret = LogController.CL();
        }
        return ret;
    }

    public abstract String getHTML(HttpRequest var1, String var2);

    public abstract BrowserViewport getBrowserViewport(BrowserWindow var1, Rectangle var2);

    public boolean onGetRequest(BrowserReference browserReference, GetRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        return false;
    }

    public boolean onPostRequest(BrowserReference browserReference, PostRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        return false;
    }

    public boolean onRawPostRequest(BrowserReference browserRefefence, PostRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        return false;
    }

    public boolean onRawGetRequest(BrowserReference browserReference, GetRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        return false;
    }

    protected abstract String getCaptchaNameSpace();

    protected String getHttpPath() {
        if (this.plugin != null) {
            return "captcha/" + this.getCaptchaNameSpace() + "/" + this.plugin.getHost();
        }
        return "captcha/" + this.getCaptchaNameSpace() + "/jd";
    }

    public static interface AbstractBrowserChallengeAPIStorable {
        public String getSiteUrl();

        public String getType();

        public String getSiteKey();

        public String getContextUrl();
    }
}

