/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.browser;

import jd.controlling.captcha.SkipException;
import jd.controlling.captcha.SkipRequest;
import jd.gui.swing.jdgui.JDGui;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CloudflareTurnstileChallenge;
import org.jdownloader.captcha.v2.challenge.cutcaptcha.CutCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserCaptchaSolverConfig;
import org.jdownloader.captcha.v2.solver.browser.BrowserDialogHandler;
import org.jdownloader.captcha.v2.solver.browser.BrowserResponse;
import org.jdownloader.captcha.v2.solver.gui.DialogBasicCaptchaSolver;
import org.jdownloader.captcha.v2.solver.service.BrowserSolverService;
import org.jdownloader.captcha.v2.solverjob.ChallengeSolverJobListener;
import org.jdownloader.captcha.v2.solverjob.ResponseList;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.settings.staticreferences.CFG_SILENTMODE;

public abstract class AbstractBrowserSolver
extends ChallengeSolver<String> {
    protected final BrowserCaptchaSolverConfig config = BrowserSolverService.getInstance().getConfig();
    private volatile BrowserDialogHandler handler;

    public AbstractBrowserSolver(int i) {
        super(BrowserSolverService.getInstance(), i);
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof AbstractBrowserChallenge;
    }

    @Override
    public boolean canHandle(Challenge<?> c) {
        if (c instanceof CutCaptchaChallenge) {
            return false;
        }
        if (c instanceof CloudflareTurnstileChallenge) {
            return false;
        }
        if (super.canHandle(c)) {
            return BrowserSolverService.getInstance().isOpenBrowserSupported();
        }
        return false;
    }

    public void checkSilentMode(final SolverJob<String> job) throws SkipException, InterruptedException {
        if (JDGui.getInstance().isSilentModeActive()) {
            switch (CFG_SILENTMODE.CFG.getOnCaptchaDuringSilentModeAction()) {
                case WAIT_IN_BACKGROUND_UNTIL_WINDOW_GETS_FOCUS_OR_TIMEOUT: {
                    break;
                }
                case DISABLE_DIALOG_SOLVER: {
                    job.getEventSender().addListener(new ChallengeSolverJobListener(){

                        @Override
                        public void onSolverTimedOut(ChallengeSolver<?> parameter) {
                        }

                        @Override
                        public void onSolverStarts(ChallengeSolver<?> parameter) {
                        }

                        @Override
                        public void onSolverJobReceivedNewResponse(AbstractResponse<?> response) {
                        }

                        @Override
                        public void onSolverDone(ChallengeSolver<?> solver) {
                            if (job.isDone()) {
                                if (!job.isSolved()) {
                                    ChallengeResponseController.getInstance().setSkipRequest(SkipRequest.SINGLE, AbstractBrowserSolver.this, job.getChallenge());
                                }
                                job.getEventSender().removeListener(this);
                            }
                        }
                    });
                    return;
                }
                case SKIP_LINK: {
                    throw new SkipException(job.getChallenge(), SkipRequest.SINGLE);
                }
            }
        }
        AbstractBrowserSolver.checkInterruption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(final SolverJob<String> job) throws InterruptedException, SkipException {
        DialogBasicCaptchaSolver dialogBasicCaptchaSolver = DialogBasicCaptchaSolver.getInstance();
        synchronized (dialogBasicCaptchaSolver) {
            if (job.isDone()) {
                return;
            }
            if (job.getChallenge() instanceof AbstractBrowserChallenge) {
                ChallengeSolverJobListener jacListener = null;
                this.checkSilentMode(job);
                AbstractBrowserChallenge captchaChallenge = (AbstractBrowserChallenge)job.getChallenge();
                this.handler = new BrowserDialogHandler(captchaChallenge);
                jacListener = new ChallengeSolverJobListener(){

                    @Override
                    public void onSolverTimedOut(ChallengeSolver<?> parameter) {
                    }

                    @Override
                    public void onSolverStarts(ChallengeSolver<?> parameter) {
                    }

                    @Override
                    public void onSolverJobReceivedNewResponse(AbstractResponse<?> response) {
                        ResponseList resp = job.getResponse();
                        BrowserDialogHandler hndlr = AbstractBrowserSolver.this.handler;
                        if (hndlr != null && resp != null) {
                            hndlr.setSuggest(resp.getValue());
                            job.getLogger().info("Received Suggestion: " + resp);
                        }
                    }

                    @Override
                    public void onSolverDone(ChallengeSolver<?> solver) {
                    }
                };
                job.getEventSender().addListener(jacListener);
                try {
                    ResponseList<String> resp = job.getResponse();
                    if (resp != null) {
                        this.handler.setSuggest(resp.getValue());
                    }
                    AbstractBrowserSolver.checkInterruption();
                    this.handler.run();
                    String response = (String)this.handler.getResult();
                    if (response != null) {
                        job.addAnswer(new BrowserResponse(captchaChallenge, (Object)this, response, 100));
                    }
                }
                finally {
                    job.getLogger().info("Dialog closed. Response far: " + job.getResponse());
                    if (jacListener != null) {
                        job.getEventSender().removeListener(jacListener);
                    }
                    this.handler = null;
                }
            }
        }
    }

    public void requestFocus(Challenge<?> challenge) {
        BrowserDialogHandler hndlr = this.handler;
        if (hndlr != null) {
            hndlr.requestFocus();
        }
    }
}

