/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.browser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jd.gui.swing.dialog.AbstractImageCaptchaDialog;
import jd.gui.swing.dialog.DialogType;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.components.ExtButton;
import org.appwork.uio.UIOManager;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.DefaultButtonPanel;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberAbsoluteDialogLocator;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.DomainInfo;
import org.jdownloader.actions.AppAction;
import org.jdownloader.captcha.v2.AbstractCaptchaDialog;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserReference;
import org.jdownloader.captcha.v2.solver.browser.BrowserSolver;
import org.jdownloader.captcha.v2.solver.browser.CFG_BROWSER_CAPTCHA_SOLVER;
import org.jdownloader.captcha.v2.solver.service.BrowserSolverService;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.gui.settings.AbstractConfigPanel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.premium.PremiumInfoDialog;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class BrowserCaptchaDialog
extends AbstractCaptchaDialog<String> {
    protected AbstractConfigPanel iconPanel;
    protected Point offset;
    protected boolean refresh;
    protected final CopyOnWriteArrayList<BrowserReference> browserReferences = new CopyOnWriteArrayList();
    private volatile String responseCode;
    private WindowFocusListener openBrowserFocusListener;

    public BrowserCaptchaDialog(int flag, DialogType type, DomainInfo domainInfo, AbstractBrowserChallenge captchaChallenge) {
        super(captchaChallenge, flag | 0x100, _GUI.T.gui_captchaWindow_askForInput(domainInfo.getTld()), type, domainInfo, null);
        if (((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isCaptchaDialogUniquePositionByHosterEnabled()) {
            this.setLocator((DialogLocator)new RememberAbsoluteDialogLocator("CaptchaDialog_" + domainInfo.getTld()));
        } else {
            this.setLocator((DialogLocator)new RememberAbsoluteDialogLocator("CaptchaDialog"));
        }
        this.setDimensor((DialogDimensor)new RememberLastDialogDimension("Captcha-" + this.getHost() + "." + this.challenge.getClass().getSimpleName() + "." + this.challenge.getTypeID()));
    }

    public static WindowManager.FrameState getWindowState() {
        for (Window w : Window.getWindows()) {
            if (!WindowManager.getInstance().hasFocus(w)) continue;
            return WindowManager.FrameState.TO_FRONT_FOCUSED;
        }
        WindowManager.FrameState ret = (WindowManager.FrameState)CFG_GUI.NEW_DIALOG_FRAME_STATE.getValue();
        if (ret == null) {
            ret = WindowManager.FrameState.TO_FRONT;
        }
        switch (ret) {
            case OS_DEFAULT: 
            case TO_BACK: {
                JDGui.getInstance().flashTaskbar();
            }
        }
        return ret;
    }

    @Override
    protected WindowManager.FrameState getWindowStateOnVisible() {
        return BrowserCaptchaDialog.getWindowState();
    }

    @Override
    public void onSetVisible(boolean b) {
        super.onSetVisible(b);
        if (b) {
            AbstractImageCaptchaDialog.playCaptchaSound();
        }
    }

    @Override
    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    @Override
    protected String createReturnValue() {
        return this.responseCode;
    }

    @Override
    public void dispose() {
        try {
            if (!this.isInitialized()) {
                return;
            }
            try {
                if (this.dialog != null && this.openBrowserFocusListener != null) {
                    this.getDialog().removeWindowFocusListener(this.openBrowserFocusListener);
                }
            }
            finally {
                super.dispose();
            }
        }
        finally {
            while (this.browserReferences.size() > 0) {
                BrowserReference browserReference = this.browserReferences.remove(0);
                if (browserReference == null) continue;
                browserReference.dispose();
            }
        }
    }

    @Override
    protected DefaultButtonPanel getDefaultButtonPanel() {
        DefaultButtonPanel ret = new DefaultButtonPanel("ins 0", "[]", "0[grow,fill]0"){

            public void addCancelButton(JButton cancelButton) {
                super.addCancelButton(cancelButton);
                JButton bt = new JButton((Icon)new AbstractIcon("popDownSmall", -1)){

                    @Override
                    public void setBounds(int x, int y, int width, int height) {
                        int delta = 5;
                        super.setBounds(x - delta, y, width + delta, height);
                    }
                };
                bt.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BrowserCaptchaDialog.this.createPopup();
                    }
                });
                super.add((Component)bt, (Object)"gapleft 0,width 8!");
            }
        };
        ret.setOpaque(false);
        ExtButton premium = new ExtButton((AbstractAction)((Object)new AppAction(){
            private static final long serialVersionUID = -3551320196255605774L;
            {
                this.setName(_GUI.T.CaptchaDialog_getDefaultButtonPanel_premium());
            }

            public void actionPerformed(ActionEvent e) {
                BrowserCaptchaDialog.this.cancel();
                PremiumInfoDialog d = new PremiumInfoDialog(BrowserCaptchaDialog.this.hosterInfo, _GUI.T.PremiumInfoDialog_PremiumInfoDialog_(BrowserCaptchaDialog.this.hosterInfo.getTld()), "CaptchaDialog");
                try {
                    Dialog.getInstance().showDialog((AbstractDialog)d);
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
                catch (DialogCanceledException e1) {
                    e1.printStackTrace();
                }
            }
        }));
        premium.setCursor(Cursor.getPredefinedCursor(12));
        premium.setRolloverEffectEnabled(true);
        LazyHostPlugin plg = HostPluginController.getInstance().get(this.hosterInfo.getTld());
        if (plg != null && plg.isPremium() && CFG_GUI.CFG.isHateCaptchasTextInCaptchaDialogVisible()) {
            ret.add((Component)premium);
        }
        SwingUtils.setOpaque((JComponent)premium, (boolean)false);
        return ret;
    }

    public Point getOffset() {
        return this.offset;
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    protected MigLayout getDialogLayout() {
        return new MigLayout("ins 0,wrap 1", "[fill,grow]", "[grow,fill]10[]");
    }

    @Override
    protected JPanel createCaptchaPanel() {
        this.iconPanel = new AbstractConfigPanel(5){

            @Override
            public Icon getIcon() {
                return null;
            }

            @Override
            public String getLeftGap() {
                return "0";
            }

            @Override
            public String getTitle() {
                return null;
            }

            @Override
            public void save() {
            }

            @Override
            public void updateContents() {
            }
        };
        this.iconPanel.addDescriptionPlain(_GUI.T.BrowserCaptchaDialog_layoutDialogContent_explain_());
        this.iconPanel.addPair(_GUI.T.BrowserCaptchaDialog_layoutDialogContent_autoclick(), null, new Checkbox(CFG_BROWSER_CAPTCHA_SOLVER.AUTO_CLICK_ENABLED, new JComponent[0]));
        this.iconPanel.addPair(_GUI.T.BrowserCaptchaDialog_layoutDialogContent_autoopen(), null, new Checkbox(CFG_BROWSER_CAPTCHA_SOLVER.AUTO_OPEN_BROWSER_ENABLED, new JComponent[0]));
        return this.iconPanel;
    }

    @Override
    public JComponent layoutDialogContent() {
        JComponent ret = super.layoutDialogContent();
        if (BrowserSolverService.getInstance().getConfig().isAutoOpenBrowserEnabled()) {
            final Thread openBrowseThread = new Thread("BrowserCaptcha:AutoOpen:" + this.challenge){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    try {
                        BrowserCaptchaDialog.this.autoOpenDelay();
                        if (BrowserCaptchaDialog.this.isAutoOpenStillRequired()) {
                            BrowserCaptchaDialog.this.openBrowser();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            if (CFG_GUI.CFG.getNewDialogFrameState() != WindowManager.FrameState.TO_BACK) {
                openBrowseThread.start();
            } else {
                this.openBrowserFocusListener = new WindowFocusListener(){

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                    }

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        openBrowseThread.start();
                        BrowserCaptchaDialog.this.getDialog().removeWindowFocusListener((WindowFocusListener)this);
                    }
                };
                this.getDialog().addWindowFocusListener(this.openBrowserFocusListener);
            }
        }
        return ret;
    }

    protected boolean isAutoOpenStillRequired() {
        if (!CFG_BROWSER_CAPTCHA_SOLVER.AUTO_OPEN_BROWSER_ENABLED.isEnabled()) {
            return false;
        }
        SolverJob<?> job = ChallengeResponseController.getInstance().getJobByChallengeId(this.challenge.getId().getID());
        return !this.challenge.isSolved() && job != null && !job.isDone() && !BrowserSolver.getInstance().isJobDone(job);
    }

    protected void autoOpenDelay() throws InterruptedException {
        for (int autoOpenDelay = Math.max(100, BrowserSolverService.getInstance().getConfig().getAutoOpenDelay()); autoOpenDelay > 0 && this.isAutoOpenStillRequired(); autoOpenDelay -= 100) {
            Thread.sleep(100L);
        }
        if (!this.isAutoOpenStillRequired()) {
            throw new InterruptedException("Challenge is no longer required");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            new Thread("BrowserCaptchaDialog:actionPerformed:" + this.challenge){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    BrowserCaptchaDialog.this.openBrowser();
                }
            }.start();
        } else {
            super.actionPerformed(e);
        }
    }

    public String getOKButtonText() {
        return _GUI.T.BrowserCaptchaDialog_getOKButtonText_open_browser();
    }

    @Override
    public boolean isRefresh() {
        return this.refresh;
    }

    @Override
    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void mouseClicked(MouseEvent e) {
        this.cancel();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.cancel();
    }

    public void mouseReleased(MouseEvent e) {
        this.cancel();
    }

    @Override
    public List<? extends Image> getIconList() {
        return JDGui.getInstance().getMainFrame().getIconImages();
    }

    protected void openBrowser() {
        BrowserReference browserReference = new BrowserReference((AbstractBrowserChallenge)this.challenge){

            @Override
            public void onResponse(String parameter) {
                BrowserCaptchaDialog.this.responseCode = parameter;
                new EDTRunner(){

                    protected void runInEDT() {
                        BrowserCaptchaDialog.this.setReturnmask(true);
                        BrowserCaptchaDialog.this.dispose();
                    }
                };
            }
        };
        this.browserReferences.add(browserReference);
        try {
            browserReference.open();
        }
        catch (Throwable e1) {
            browserReference.dispose();
            this.browserReferences.remove(browserReference);
            UIOManager.I().showException(e1.getMessage(), e1);
        }
    }
}

