/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.gui;

import jd.controlling.captcha.CaptchaSettings;
import jd.controlling.captcha.MultiClickCaptchaDialogHandler;
import jd.controlling.captcha.SkipException;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickedPoint;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.MultiClickCaptchaResponse;
import org.jdownloader.captcha.v2.solver.gui.AbstractDialogSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogBasicCaptchaSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogCaptchaSolverConfig;
import org.jdownloader.captcha.v2.solver.jac.JACSolver;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.settings.advanced.AdvancedConfigManager;

public class DialogMultiClickCaptchaSolver
extends AbstractDialogSolver<MultiClickedPoint> {
    private CaptchaSettings config = (CaptchaSettings)JsonConfig.create(CaptchaSettings.class);
    private MultiClickCaptchaDialogHandler handler;
    private static final DialogMultiClickCaptchaSolver INSTANCE = new DialogMultiClickCaptchaSolver();

    private DialogMultiClickCaptchaSolver() {
        super(1);
        AdvancedConfigManager.getInstance().register(JsonConfig.create(DialogCaptchaSolverConfig.class));
    }

    public static DialogMultiClickCaptchaSolver getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof MultiClickCaptchaChallenge;
    }

    public void requestFocus(Challenge<?> challenge) {
        MultiClickCaptchaDialogHandler hndlr = this.handler;
        if (hndlr != null) {
            hndlr.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(SolverJob<MultiClickedPoint> solverJob) throws InterruptedException, SkipException {
        DialogBasicCaptchaSolver dialogBasicCaptchaSolver = DialogBasicCaptchaSolver.getInstance();
        synchronized (dialogBasicCaptchaSolver) {
            if (solverJob.isDone()) {
                return;
            }
            if (solverJob.getChallenge() instanceof MultiClickCaptchaChallenge) {
                solverJob.getLogger().info("Waiting for JAC (Click/Mouse)");
                solverJob.waitFor(9, JACSolver.getInstance());
                solverJob.getLogger().info("JAC (Click/Mouse) is done. Response so far: " + solverJob.getResponse());
                this.checkSilentMode(solverJob);
                MultiClickCaptchaChallenge captchaChallenge = (MultiClickCaptchaChallenge)solverJob.getChallenge();
                DialogMultiClickCaptchaSolver.checkInterruption();
                this.handler = new MultiClickCaptchaDialogHandler(captchaChallenge);
                this.handler.run();
                MultiClickedPoint result = (MultiClickedPoint)this.handler.getResult();
                if (result != null) {
                    solverJob.addAnswer(new MultiClickCaptchaResponse(captchaChallenge, (Object)this, result, 100));
                }
            }
        }
    }
}

