/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.solver9kw;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import jd.http.Browser;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaImages;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaPuzzleChallenge;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solver.solver9kw.AbstractCaptcha9kwSolver;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwPuzzleResponse;
import org.jdownloader.captcha.v2.solver.solver9kw.NineKwSolverService;
import org.jdownloader.captcha.v2.solver.solver9kw.RequestOptions;

public class Captcha9kwSolverPuzzle
extends AbstractCaptcha9kwSolver<String> {
    private static Captcha9kwSolverPuzzle INSTANCE = new Captcha9kwSolverPuzzle();

    public static Captcha9kwSolverPuzzle getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    private Captcha9kwSolverPuzzle() {
        NineKwSolverService.getInstance().setPuzzleSolver(this);
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof KeyCaptchaPuzzleChallenge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void solveCES(CESSolverJob<String> solverJob) throws InterruptedException, SolverException {
        Captcha9kwSolverPuzzle.checkInterruption();
        KeyCaptchaPuzzleChallenge captchaChallenge = (KeyCaptchaPuzzleChallenge)solverJob.getChallenge();
        RequestOptions options = this.prepare(solverJob);
        if (options.getMoreoptions().containsKey("userconfirm")) {
            options.getMoreoptions().remove("userconfirm");
        } else {
            options.setConfirm(this.config.isconfirm());
        }
        try {
            UrlQuery qi = this.createQueryForUpload(solverJob, options, null);
            qi.appendEncoded("puzzle", "1");
            KeyCaptchaImages images = captchaChallenge.getHelper().getPuzzleData().getImages();
            LinkedList<BufferedImage> piecesAll = new LinkedList<BufferedImage>(images.pieces);
            qi.appendEncoded("file-upload-01", Base64.encodeToString((byte[])IconIO.toJpgBytes((Image)images.backgroundImage), (boolean)false));
            qi.appendEncoded("file-upload-02", Base64.encodeToString((byte[])IconIO.toJpgBytes((Image)images.sampleImage), (boolean)false));
            String allfiledata = "";
            for (int c = 0; c < piecesAll.size(); ++c) {
                BufferedImage image = piecesAll.get(c);
                int x = c + 3;
                qi.appendEncoded("file-upload-0" + x, Base64.encodeToString((byte[])IconIO.toJpgBytes((Image)image), (boolean)false));
            }
            UrlQuery queryPoll = this.createQueryForPolling().appendEncoded("puzzle", "1");
            Browser br = new Browser();
            br.setAllowedResponseCodes(new int[]{500});
            String captchaID = this.upload(br, solverJob, qi);
            this.poll(br, options, solverJob, captchaID, queryPoll);
        }
        catch (IOException e) {
            solverJob.getChallenge().sendStatsError(this, e);
            this.setdebug(solverJob, "Interrupted: " + e);
            this.counterInterrupted.incrementAndGet();
            solverJob.getLogger().log((Throwable)e);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.config.ispuzzle() && this.config.isEnabledGlobally();
    }

    @Override
    protected void parseResponse(CESSolverJob<String> solverJob, Challenge<String> challenge, String captchaID, String ret) throws IOException {
        String points = StringUtils.startsWithCaseInsensitive((String)ret, (String)"OK-answered-") ? ret.substring("OK-answered-".length()) : ret;
        String token = ((KeyCaptchaPuzzleChallenge)challenge).getHelper().sendPuzzleResult(null, points);
        this.counterSolved.incrementAndGet();
        solverJob.setAnswer(new Captcha9kwPuzzleResponse(challenge, this, token, 95, captchaID));
    }
}

