/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.twocaptcha;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jd.gui.UserIO;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.SettingsButton;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.TextInput;
import jd.gui.swing.jdgui.views.settings.panels.anticaptcha.AbstractCaptchaSolverConfigPanel;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.actions.AppAction;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaAccount;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaSolver;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaSolverService;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_TWO_CAPTCHA;

public final class TwoCaptchaConfigPanel
extends AbstractCaptchaSolverConfigPanel {
    private static final long serialVersionUID = -6345775244208176097L;
    private ExtButton btnUserCheck;
    private TextInput apiKey;
    private TwoCaptchaSolverService service;

    public TwoCaptchaConfigPanel(TwoCaptchaSolverService twoCaptchaSolverService) {
        this.service = twoCaptchaSolverService;
        this.addHeader(this.getTitle(), new AbstractIcon("logo/2captcha", 32));
        this.addDescription(_GUI.T.AntiCaptchaConfigPanel_onShow_description_paid_service());
        this.add((Component)new SettingsButton(new AppAction(){
            private static final long serialVersionUID = 546456487846L;
            {
                this.setName(_GUI.T.lit_open_website());
            }

            public void actionPerformed(ActionEvent e) {
                CrossSystem.openURL((String)"https://2captcha.com?from=15779444");
            }
        }), "gapleft 37,spanx,pushx,growx");
        this.apiKey = new TextInput(CFG_TWO_CAPTCHA.API_KEY);
        this.addHeader(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_logins_(), new AbstractIcon("logins", 32));
        this.addDescriptionPlain(_GUI.T.captchasolver_configpanel_my_account_description(this.service.getName()));
        this.addPair(_GUI.T.captchasolver_configpanel_enabled(this.service.getName()), null, (SettingsComponent)new Checkbox(CFG_TWO_CAPTCHA.ENABLED, new JComponent[]{this.apiKey}));
        MigPanel toolbar = new MigPanel("ins 0", "[][][][]", "[]");
        toolbar.add(this.label(_GUI.T.lit_api_key()));
        toolbar.add((Component)this.apiKey, (Object)"pushx,growx");
        this.btnUserCheck = new ExtButton((AbstractAction)((Object)new AppAction(){
            private static final long serialVersionUID = -103695205004891917L;
            {
                this.setName(_GUI.T.NinekwService_createPanel_btnUserCheck());
            }

            public void actionPerformed(ActionEvent e) {
                TwoCaptchaSolver solver = TwoCaptchaSolver.getInstance();
                if (TwoCaptchaConfigPanel.this.apiKey.getText().length() < 5) {
                    UserIO.getInstance().requestMessageDialog("2Captcha.com Error", "No api key.");
                } else if (!solver.looksLikeValidAPIKey(TwoCaptchaConfigPanel.this.apiKey.getText())) {
                    UserIO.getInstance().requestMessageDialog("2Captcha.com Error", "API Key is not correct!\nFormat: [a-f0-9]{32}");
                } else {
                    TwoCaptchaAccount acc = TwoCaptchaSolver.getInstance().loadAccount();
                    if (acc.getError() != null) {
                        UserIO.getInstance().requestMessageDialog("2Captcha.com Error", "Account error\n" + acc.getError());
                        return;
                    }
                    UserIO.getInstance().requestMessageDialog("2Captcha.com message ", "Account OK\nCredits: " + acc.getBalance());
                }
            }
        }));
        this.btnUserCheck.setToolTipText(_GUI.T.NinekwService_createPanel_btnUserCheck_tooltiptext());
        toolbar.add((Component)this.btnUserCheck);
        this.add((Component)toolbar, "gapleft 40, spanx,pushx,growx");
        this.addPair(_GUI.T.DeatchbyCaptcha_Service_createPanel_feedback(), null, (SettingsComponent)new Checkbox(CFG_TWO_CAPTCHA.FEED_BACK_SENDING_ENABLED, new JComponent[0]));
        this.addBlackWhiteList(CFG_TWO_CAPTCHA.CFG);
    }

    public String getPanelID() {
        return "CES_" + this.getTitle();
    }

    public void save() {
    }

    public void updateContents() {
    }

    public Icon getIcon() {
        return this.service.getIcon(32);
    }

    public String getTitle() {
        return "2captcha.com / rucaptcha.com";
    }

    private Component label(String lbl) {
        JLabel ret = new JLabel(lbl);
        ret.setEnabled(true);
        return ret;
    }
}

