/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class AggregatedCrawlerNumbers {
    protected static final boolean FORCED_MIRROR_CASE_INSENSITIVE = CrossSystem.isWindows() || ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isForceMirrorDetectionCaseInsensitive();
    private final long totalBytes;
    private static final GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();
    private final DecimalFormat formatter = new DecimalFormat();
    private final int linkCount;
    private final int packageCount;
    private final long disabledTotalBytes;
    private final long statusOnline;
    private final long statusOffline;
    private final long statusUnknown;
    private final HashSet<DomainInfo> hoster = new HashSet();

    public final String getTotalBytesString(boolean includeDisabled) {
        if (includeDisabled) {
            return this.format(this.totalBytes + this.disabledTotalBytes);
        }
        return this.format(this.totalBytes);
    }

    private final String format(long totalBytes2) {
        if (totalBytes2 < 0L) {
            return _GUI.T.lit_unknown();
        }
        return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(maxSizeUnit, this.formatter, totalBytes2);
    }

    public final int getLinkCount() {
        return this.linkCount;
    }

    public final int getPackageCount() {
        return this.packageCount;
    }

    public final long getStatusOnline() {
        return this.statusOnline;
    }

    public final long getStatusOffline() {
        return this.statusOffline;
    }

    public final long getStatusUnknown() {
        return this.statusUnknown;
    }

    public final HashSet<DomainInfo> getHoster() {
        return this.hoster;
    }

    public final long getDisabledTotalBytes() {
        return this.disabledTotalBytes;
    }

    public AggregatedCrawlerNumbers(SelectionInfo<CrawledPackage, CrawledLink> selection) {
        long totalBytes = 0L;
        long disabledTotalBytes = 0L;
        long statusOnline = 0L;
        long statusOffline = 0L;
        long statusUnknown = 0L;
        List<SelectionInfo.PackageView<CrawledPackage, CrawledLink>> packageViews = selection.getPackageViews();
        this.packageCount = packageViews.size();
        int linkCount = 0;
        for (SelectionInfo.PackageView<CrawledPackage, CrawledLink> packageView : packageViews) {
            HashMap<String, AggregatedCrawledLink> aggregatedCrawledLinks = new HashMap<String, AggregatedCrawledLink>();
            block8: for (CrawledLink cl : packageView.getChildren()) {
                if (cl == null) continue;
                String name = FORCED_MIRROR_CASE_INSENSITIVE ? cl.getName().toLowerCase(Locale.ENGLISH) : cl.getName();
                this.hoster.add(cl.getDomainInfo());
                AggregatedCrawledLink acl = (AggregatedCrawledLink)aggregatedCrawledLinks.get(name);
                long itemSize = Math.max(0L, cl.getSize());
                AvailableLinkState state = cl.getLinkState();
                if (acl == null) {
                    acl = new AggregatedCrawledLink();
                    acl.enabled = cl.isEnabled();
                    acl.bytes = itemSize;
                    acl.status = state;
                    aggregatedCrawledLinks.put(name, acl);
                    continue;
                }
                if (itemSize > acl.bytes) {
                    acl.bytes = itemSize;
                }
                if (!acl.enabled) {
                    acl.enabled = cl.isEnabled();
                }
                switch (acl.status) {
                    case ONLINE: {
                        continue block8;
                    }
                }
                acl.status = state;
            }
            linkCount += aggregatedCrawledLinks.size();
            block9: for (AggregatedCrawledLink acl : aggregatedCrawledLinks.values()) {
                if (acl.enabled) {
                    totalBytes += acl.bytes;
                } else {
                    disabledTotalBytes += acl.bytes;
                }
                switch (acl.status) {
                    case ONLINE: {
                        ++statusOnline;
                        continue block9;
                    }
                    case OFFLINE: {
                        ++statusOffline;
                        continue block9;
                    }
                }
                ++statusUnknown;
            }
        }
        this.statusOffline = statusOffline;
        this.statusOnline = statusOnline;
        this.statusUnknown = statusUnknown;
        this.disabledTotalBytes = disabledTotalBytes;
        this.totalBytes = totalBytes;
        this.linkCount = linkCount;
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    private static final class AggregatedCrawledLink {
        private long bytes = -1L;
        private boolean enabled = false;
        private AvailableLinkState status = AvailableLinkState.UNKNOWN;

        private AggregatedCrawledLink() {
        }
    }
}

