/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.download.DownloadInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.DownloadLinkView;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.MirrorLoading;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class AggregatedNumbers {
    protected static final boolean FORCED_MIRROR_CASE_INSENSITIVE = CrossSystem.isWindows() || ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isForceMirrorDetectionCaseInsensitive();
    private final long totalBytes;
    private static final GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();
    private final NumberFormat formatter;
    private final long loadedBytes;
    private final long downloadSpeed;
    private final long eta;
    private final int linkCount;
    private final int packageCount;
    private final int running;
    private final long enabledUnfinishedTotalBytes;
    private final long enabledUnfinishedLoadedBytes;
    private final int connections;
    private final long disabledTotalBytes;
    private final long disabledLoadedBytes;
    private final long downloadsFinished;
    private final long downloadsFailed;
    private final long downloadsSkipped;
    private final long disabledDownloadsFinished;
    private final long disabledDownloadsFailed;
    private final long disabledDownloadsSkipped;

    public final String getFinishedString(boolean inclDisabled) {
        if (inclDisabled) {
            return String.valueOf(this.downloadsFinished + this.disabledDownloadsFinished);
        }
        return String.valueOf(this.downloadsFinished);
    }

    public String getSkippedString(boolean inclDisabled) {
        if (inclDisabled) {
            return String.valueOf(this.downloadsSkipped + this.disabledDownloadsSkipped);
        }
        return String.valueOf(this.downloadsSkipped);
    }

    public String getFailedString(boolean inclDisabled) {
        if (inclDisabled) {
            return String.valueOf(this.downloadsFailed + this.disabledDownloadsFailed);
        }
        return String.valueOf(this.downloadsFailed);
    }

    public String getTotalBytesString(boolean inclDisabled) {
        if (inclDisabled) {
            return this.format(this.totalBytes + this.disabledTotalBytes);
        }
        return this.format(this.totalBytes);
    }

    private String format(long fileSize) {
        if (fileSize < 0L) {
            return _GUI.T.lit_unknown();
        }
        return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(maxSizeUnit, this.formatter, fileSize);
    }

    public String getLoadedBytesString(boolean inclDisabled) {
        if (inclDisabled) {
            return this.format(this.loadedBytes + this.disabledLoadedBytes);
        }
        return this.format(this.loadedBytes);
    }

    public String getRemainingBytesString(boolean inclDisabled) {
        if (inclDisabled) {
            return this.format(this.totalBytes + this.disabledTotalBytes - (this.loadedBytes + this.disabledLoadedBytes));
        }
        return this.format(this.totalBytes - this.loadedBytes);
    }

    public String getDownloadSpeedString() {
        return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(maxSizeUnit, this.formatter, this.downloadSpeed) + "/s";
    }

    public String getEtaString() {
        return this.eta > 0L ? TimeFormatter.formatSeconds((long)this.eta, (int)0) : "~";
    }

    public final int getLinkCount() {
        return this.linkCount;
    }

    public final int getPackageCount() {
        return this.packageCount;
    }

    public final int getRunning() {
        return this.running;
    }

    public final int getConnections() {
        return this.connections;
    }

    private void aggregrate(DownloadLink link, Map<String, AggregatedDownloadLink> linkInfos) {
        boolean isEnabled = link.isEnabled();
        DownloadLinkView view = link.getView();
        ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
        String displayName = FORCED_MIRROR_CASE_INSENSITIVE ? view.getDisplayName().toLowerCase(Locale.ENGLISH) : view.getDisplayName();
        if (isEnabled) {
            if (conditionalSkipReason instanceof MirrorLoading) {
                MirrorLoading mirrorLoading = (MirrorLoading)conditionalSkipReason;
                DownloadLink downloadLink = mirrorLoading.getDownloadLink();
                AggregatedDownloadLink linkInfo = linkInfos.get(displayName);
                if (linkInfo == null || linkInfo.link != downloadLink) {
                    linkInfo = new AggregatedDownloadLink();
                    linkInfo.link = downloadLink;
                    DownloadLinkView downloadView = downloadLink.getView();
                    linkInfo.bytesTotal = downloadView.getBytesTotal();
                    linkInfo.bytesDone = downloadView.getBytesLoaded();
                    SingleDownloadController controller = downloadLink.getDownloadLinkController();
                    if (controller != null) {
                        ManagedThrottledConnectionHandler handlerP;
                        DownloadInterface downloadInterface = controller.getDownloadInstance();
                        if (downloadInterface == null || System.currentTimeMillis() - downloadInterface.getStartTimeStamp() < 5000L) {
                            linkInfo.speed = 0L;
                        } else {
                            linkInfo.speed = downloadView.getSpeedBps();
                        }
                        if (downloadInterface != null && (handlerP = downloadInterface.getManagedConnetionHandler()) != null) {
                            linkInfo.connections = Math.max(linkInfo.connections, handlerP.size());
                        }
                    }
                    linkInfos.put(displayName, linkInfo);
                }
            } else {
                AggregatedDownloadLink linkInfo = linkInfos.get(displayName);
                if (linkInfo == null) {
                    linkInfo = new AggregatedDownloadLink();
                    linkInfo.link = link;
                    linkInfos.put(displayName, linkInfo);
                }
                linkInfo.enabled = true;
                SingleDownloadController controller = link.getDownloadLinkController();
                if (controller != null) {
                    ManagedThrottledConnectionHandler handlerP;
                    linkInfo.bytesTotal = view.getBytesTotal();
                    linkInfo.bytesDone = view.getBytesLoaded();
                    DownloadInterface downloadInterface = controller.getDownloadInstance();
                    if (downloadInterface == null || System.currentTimeMillis() - downloadInterface.getStartTimeStamp() < 5000L) {
                        linkInfo.speed = 0L;
                    } else {
                        linkInfo.speed = view.getSpeedBps();
                    }
                    if (downloadInterface != null && (handlerP = downloadInterface.getManagedConnetionHandler()) != null) {
                        linkInfo.connections = Math.max(linkInfo.connections, handlerP.size());
                    }
                } else if (linkInfo.speed < 0L) {
                    if (linkInfo.bytesTotal < view.getBytesTotal()) {
                        linkInfo.bytesTotal = view.getBytesTotal();
                    }
                    if (linkInfo.bytesDone < view.getBytesLoaded()) {
                        linkInfo.bytesDone = view.getBytesLoaded();
                    }
                }
            }
        } else {
            AggregatedDownloadLink linkInfo = linkInfos.get(displayName);
            if (linkInfo == null) {
                linkInfo = new AggregatedDownloadLink();
                linkInfo.link = link;
                linkInfo.enabled = false;
                linkInfos.put(displayName, linkInfo);
            }
            if (!linkInfo.enabled && linkInfo.speed < 0L) {
                if (linkInfo.bytesTotal < view.getBytesTotal()) {
                    linkInfo.bytesTotal = view.getBytesTotal();
                }
                if (linkInfo.bytesDone < view.getBytesLoaded()) {
                    linkInfo.bytesDone = view.getBytesLoaded();
                }
            }
        }
    }

    public AggregatedNumbers(SelectionInfo<FilePackage, DownloadLink> selection) {
        List<SelectionInfo.PackageView<FilePackage, DownloadLink>> packageViews = selection.getPackageViews();
        this.packageCount = packageViews.size();
        int linkCount = 0;
        long downloadSpeed = 0L;
        long totalBytes = -1L;
        long totalBytesDisabled = -1L;
        long loadedBytes = 0L;
        long loadedBytesDisabled = 0L;
        long downloadsSkipped = 0L;
        long downloadsSkippedDisabled = 0L;
        long downloadsFinished = 0L;
        long downloadsFinishedDisabled = 0L;
        long downloadsFailed = 0L;
        long downloadsFailedDisabled = 0L;
        int running = 0;
        int connections = 0;
        long enabledUnfinishedTotalBytes = -1L;
        long enabledUnfinishedLoadedBytes = 0L;
        for (SelectionInfo.PackageView<FilePackage, DownloadLink> packageView : packageViews) {
            HashMap<String, AggregatedDownloadLink> linkInfos = new HashMap<String, AggregatedDownloadLink>();
            for (DownloadLink link : packageView.getChildren()) {
                this.aggregrate(link, linkInfos);
            }
            linkCount += linkInfos.size();
            for (AggregatedDownloadLink linkInfo : linkInfos.values()) {
                FinalLinkState state = linkInfo.link.getFinalLinkState();
                connections += linkInfo.connections;
                SkipReason skipReason = linkInfo.link.getSkipReason();
                if (linkInfo.speed >= 0L) {
                    if (downloadSpeed == -1L) {
                        downloadSpeed = 0L;
                    }
                    downloadSpeed += linkInfo.speed;
                    ++running;
                }
                if (linkInfo.enabled) {
                    boolean enabledUnfinished = false;
                    if (state == null) {
                        if (skipReason != null) {
                            ++downloadsSkipped;
                        } else {
                            enabledUnfinished = true;
                        }
                    } else if (state.isFailed()) {
                        ++downloadsFailed;
                    } else if (state.isFinished()) {
                        ++downloadsFinished;
                    }
                    if (linkInfo.bytesTotal >= 0L) {
                        if (totalBytes == -1L) {
                            totalBytes = 0L;
                        }
                        totalBytes += linkInfo.bytesTotal;
                        if (enabledUnfinished) {
                            if (enabledUnfinishedTotalBytes == -1L) {
                                enabledUnfinishedTotalBytes = 0L;
                            }
                            enabledUnfinishedTotalBytes += linkInfo.bytesTotal;
                        }
                    }
                    if (linkInfo.bytesDone < 0L) continue;
                    loadedBytes += linkInfo.bytesDone;
                    if (!enabledUnfinished) continue;
                    enabledUnfinishedLoadedBytes += linkInfo.bytesDone;
                    continue;
                }
                if (state == null) {
                    if (skipReason != null) {
                        ++downloadsSkippedDisabled;
                    }
                } else if (state.isFailed()) {
                    ++downloadsFailedDisabled;
                } else if (state.isFinished()) {
                    ++downloadsFinishedDisabled;
                }
                if (linkInfo.bytesTotal >= 0L) {
                    if (totalBytesDisabled == -1L) {
                        totalBytesDisabled = 0L;
                    }
                    totalBytesDisabled += linkInfo.bytesTotal;
                }
                if (linkInfo.bytesDone < 0L) continue;
                loadedBytesDisabled += linkInfo.bytesDone;
            }
        }
        if (totalBytes >= 0L && downloadSpeed > 0L) {
            long bytesLeft = Math.max(-1L, totalBytes - loadedBytes);
            this.eta = bytesLeft / downloadSpeed;
        } else {
            this.eta = -1L;
        }
        this.connections = connections;
        this.running = running;
        this.downloadSpeed = downloadSpeed;
        this.disabledDownloadsFailed = downloadsFailedDisabled;
        this.disabledDownloadsFinished = downloadsFinishedDisabled;
        this.disabledDownloadsSkipped = downloadsSkippedDisabled;
        this.disabledLoadedBytes = loadedBytesDisabled;
        if (totalBytesDisabled == -1L && linkCount == 0) {
            totalBytesDisabled = 0L;
        }
        this.disabledTotalBytes = totalBytesDisabled;
        this.downloadsFailed = downloadsFailed;
        this.downloadsFinished = downloadsFinished;
        this.downloadsSkipped = downloadsSkipped;
        if (totalBytes == -1L && linkCount == 0) {
            totalBytes = 0L;
        }
        this.totalBytes = totalBytes;
        this.loadedBytes = loadedBytes;
        this.enabledUnfinishedLoadedBytes = enabledUnfinishedLoadedBytes;
        if (enabledUnfinishedTotalBytes == -1L && linkCount == 0) {
            enabledUnfinishedTotalBytes = 0L;
        }
        this.enabledUnfinishedTotalBytes = enabledUnfinishedTotalBytes;
        this.linkCount = linkCount;
        this.formatter = this.initNumberFormat();
    }

    protected NumberFormat initNumberFormat() {
        return NumberFormat.getInstance();
    }

    public long getEnabledUnfinishedTotalBytes() {
        return this.enabledUnfinishedTotalBytes;
    }

    public long getEnabledUnfinishedLoadedBytes() {
        return this.enabledUnfinishedLoadedBytes;
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    public final long getDownloadSpeed() {
        return this.downloadSpeed;
    }

    public final long getEta() {
        return this.eta;
    }

    public final long getLoadedBytes() {
        return this.loadedBytes;
    }

    private static final class AggregatedDownloadLink {
        private long bytesTotal = -1L;
        private long bytesDone = -1L;
        private long speed = -1L;
        private int connections = 0;
        private boolean enabled = true;
        private DownloadLink link = null;

        private AggregatedDownloadLink() {
        }
    }
}

