/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.DownloadLinkView;
import org.jdownloader.controlling.MirrorPackage;
import org.jdownloader.controlling.MirrorPackageSetup;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.plugins.FinalLinkState;

public class DownloadLinkAggregator
implements MirrorPackageSetup {
    private int totalCount;
    private int onlineStatusOfflineCount;
    private int onlineStatusOnlineCount;
    private int enabledCount;
    private long totalBytes;
    private long bytesLoaded;
    private int finishedCount;
    private long eta;
    private boolean localFileUsageEnabled = false;
    private boolean mirrorHandlingEnabled = true;
    private int localFileCount;

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getOnlineStatusOfflineCount() {
        return this.onlineStatusOfflineCount;
    }

    public int getOnlineStatusOnlineCount() {
        return this.onlineStatusOnlineCount;
    }

    public int getOnlineStatusUnkownCount() {
        return this.getTotalCount() - this.getOnlineStatusOfflineCount() - this.getOnlineStatusOfflineCount();
    }

    public int getEnabledCount() {
        return this.enabledCount;
    }

    public int getDisabledCount() {
        return this.getTotalCount() - this.getEnabledCount();
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getBytesLoaded() {
        return this.bytesLoaded;
    }

    public int getFinishedCount() {
        return this.finishedCount;
    }

    public void setLocalFileUsageEnabled(boolean fileSizeCheckEnabled) {
        this.localFileUsageEnabled = fileSizeCheckEnabled;
    }

    public boolean isMirrorHandlingEnabled() {
        return this.mirrorHandlingEnabled;
    }

    public void setMirrorHandlingEnabled(boolean mirrorHandlingEnabled) {
        this.mirrorHandlingEnabled = mirrorHandlingEnabled;
    }

    public DownloadLinkAggregator(FilePackage fp) {
        boolean readL = fp.getModifyLock().readLock();
        try {
            this.update(fp.getChildren());
        }
        finally {
            fp.getModifyLock().readUnlock(readL);
        }
    }

    public DownloadLinkAggregator() {
    }

    public DownloadLinkAggregator(SelectionInfo<FilePackage, DownloadLink> si) {
        this.update(si.getChildren());
    }

    public void update(List<DownloadLink> children) {
        int total;
        int enabled = 0;
        int offline = 0;
        int online = 0;
        Long totalBytes = null;
        long bytesLoaded = 0L;
        long bytesToDo = 0L;
        int finished = 0;
        long speed = 0L;
        int localFileCount = 0;
        Long maxEta = null;
        boolean isLocalFileMode = this.isLocalFileUsageEnabled();
        if (this.isMirrorHandlingEnabled()) {
            HashMap<String, MirrorPackage> mirrorPackages = new HashMap<String, MirrorPackage>();
            block4: for (DownloadLink link : children) {
                String mirrorID = this.createDupeID(link);
                HashSet<String> idDupes = new HashSet<String>();
                idDupes.add(mirrorID);
                while (mirrorID != null) {
                    String newID;
                    MirrorPackage mirrorPackage = (MirrorPackage)mirrorPackages.get(mirrorID);
                    if (mirrorPackage == null) {
                        mirrorPackage = new MirrorPackage(mirrorID, this);
                        mirrorPackages.put(mirrorID, mirrorPackage);
                    }
                    if ((newID = mirrorPackage.add(link)) == null || !idDupes.add(newID)) continue block4;
                    mirrorID = newID;
                }
            }
            total = mirrorPackages.values().size();
            for (MirrorPackage mirrorPackage : mirrorPackages.values()) {
                long toDo;
                long fileSize = mirrorPackage.getTotalBytes();
                long loaded = mirrorPackage.getBytesLoaded();
                if (fileSize >= 0L) {
                    totalBytes = totalBytes == null ? Long.valueOf(fileSize) : Long.valueOf(totalBytes + fileSize);
                    toDo = Math.max(0L, fileSize - loaded);
                    bytesToDo += toDo;
                } else {
                    toDo = 0L;
                }
                if (loaded > 0L) {
                    bytesLoaded += loaded;
                    if (isLocalFileMode) {
                        ++localFileCount;
                    }
                }
                if (mirrorPackage.isFinished()) {
                    ++finished;
                }
                if (mirrorPackage.isEnabled()) {
                    ++enabled;
                    long dlSpeed = mirrorPackage.getSpeed();
                    if (dlSpeed > 0L) {
                        if (toDo > 0L) {
                            maxEta = maxEta == null ? Long.valueOf(toDo / dlSpeed) : Long.valueOf(Math.max(maxEta, toDo / dlSpeed));
                        }
                        speed += dlSpeed;
                    }
                }
                if (mirrorPackage.isOnline()) {
                    ++online;
                    continue;
                }
                if (!mirrorPackage.isOffline()) continue;
                ++offline;
            }
        } else {
            HashSet<String> localFileCheck = new HashSet<String>();
            total = children.size();
            for (DownloadLink link : children) {
                long toDo;
                DownloadLinkView view = link.getView();
                boolean isFinished = FinalLinkState.CheckFinished(link.getFinalLinkState());
                if (isFinished) {
                    ++finished;
                }
                long loaded = 0L;
                if (isLocalFileMode) {
                    String fileOutput = link.getFileOutput();
                    if (StringUtils.isNotEmpty((String)fileOutput) && localFileCheck.add(fileOutput)) {
                        File completeFile = new File(fileOutput);
                        if (completeFile.exists()) {
                            loaded = completeFile.length();
                            ++localFileCount;
                        } else {
                            File partFile = new File(fileOutput + ".part");
                            if (partFile.exists()) {
                                loaded = partFile.length();
                                ++localFileCount;
                            }
                        }
                    }
                } else {
                    loaded = view.getBytesLoaded();
                }
                long fileSize = view.getBytesTotal();
                if (fileSize >= 0L) {
                    totalBytes = totalBytes == null ? Long.valueOf(fileSize) : Long.valueOf(totalBytes + fileSize);
                    toDo = Math.max(0L, fileSize - loaded);
                    bytesToDo += toDo;
                } else {
                    toDo = 0L;
                }
                bytesLoaded += loaded;
                if (link.isEnabled()) {
                    long dlSpeed;
                    ++enabled;
                    if (!isFinished && link.getDownloadLinkController() != null && (dlSpeed = view.getSpeedBps()) > 0L) {
                        if (toDo > 0L) {
                            maxEta = maxEta == null ? Long.valueOf(toDo / dlSpeed) : Long.valueOf(Math.max(maxEta, toDo / dlSpeed));
                        }
                        speed += dlSpeed;
                    }
                }
                switch (link.getAvailableStatus()) {
                    case TRUE: {
                        ++online;
                        break;
                    }
                    case FALSE: {
                        ++offline;
                    }
                }
            }
        }
        this.localFileCount = localFileCount;
        this.totalCount = total;
        this.onlineStatusOfflineCount = offline;
        this.onlineStatusOnlineCount = online;
        this.enabledCount = enabled;
        if (totalBytes == null && this.totalCount == 0) {
            totalBytes = 0L;
        }
        this.totalBytes = totalBytes != null ? totalBytes : -1L;
        this.bytesLoaded = bytesLoaded;
        this.finishedCount = finished;
        long eta = speed > 0L ? bytesToDo / speed : -1L;
        this.eta = maxEta != null && eta > 0L ? Math.max(maxEta, eta) : eta;
        if (bytesToDo == 0L && !this.isFinished()) {
            this.eta = -1L;
        }
    }

    public int getLocalFileCount() {
        if (!this.isLocalFileUsageEnabled()) {
            throw new IllegalStateException("isLocalFileUsageEnabled() is disabled");
        }
        return this.localFileCount;
    }

    @Override
    public boolean isLocalFileUsageEnabled() {
        return this.localFileUsageEnabled;
    }

    public long getEta() {
        return this.eta;
    }

    private String createDupeID(DownloadLink link) {
        return link.getFileOutput();
    }

    public boolean isFinished() {
        return this.finishedCount == this.totalCount || this.totalCount == this.finishedCount + this.onlineStatusOfflineCount;
    }
}

