/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.Scrollable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtTextField;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.FileHandler;
import org.appwork.utils.Files;
import org.appwork.utils.GetterSetter;
import org.appwork.utils.KeyUtils;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.CustomSettingsPanelInterface;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.contextmenu.gui.CustomPanel;
import org.jdownloader.controlling.contextmenu.gui.MenuManagerDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.config.Order;

public class InfoPanel
extends MigPanel
implements ActionListener,
Scrollable {
    private JLabel label;
    private MenuItemData item;
    private ExtTextField name;
    private ExtButton iconChange;
    private MenuManagerDialog managerFrame;
    private JCheckBox visibleBox;
    private ExtTextField shortcut;
    private CustomPanel customPanel;
    private JLabel namelabel;
    private JButton iconKeyReset;
    private JButton nameReset;
    private JButton shortCutReset;
    private JLabel shortcutLabel;
    private String resetIconKey;
    private String resetName;
    private String resetShortcut;

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return Math.max(visibleRect.height * 9 / 10, 1);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return Math.max(visibleRect.height / 10, 1);
    }

    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        ret.width = Math.max(ret.width, 300);
        return ret;
    }

    public InfoPanel(MenuManagerDialog m) {
        super("ins 5,wrap 2", "[grow,fill][]", "[22!][]");
        this.managerFrame = m;
        this.label = SwingUtils.toBold((JLabel)new JLabel());
        this.add(this.label);
        this.add(new JSeparator(), "spanx");
        this.add(SwingUtils.toBold((JLabel)new JLabel(_GUI.T.InfoPanel_InfoPanel_properties_())), "spanx");
        this.visibleBox = new JCheckBox();
        this.visibleBox.addActionListener(this);
        this.name = new ExtTextField(){

            public void onChanged() {
                if (InfoPanel.this.item == null) {
                    return;
                }
                InfoPanel.this.item.setName(InfoPanel.this.name.getText());
                InfoPanel.this.updateResetButtons(InfoPanel.this.item);
                InfoPanel.this.updateHeaderLabel(InfoPanel.this.item);
                InfoPanel.this.managerFrame.fireUpdate();
            }
        };
        this.name.setHelpText(_GUI.T.InfoPanel_InfoPanel_customname_help());
        this.iconChange = new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setName(_GUI.T.InfoPanel_changeicon());
            }

            public void actionPerformed(ActionEvent e) {
                final JPopupMenu p = new JPopupMenu();
                final File imagesDir = NewTheme.I().getImagesDirectory();
                final ArrayList files = new ArrayList();
                Files.internalWalkThroughStructure((FileHandler)new FileHandler<RuntimeException>(){

                    public void intro(File f) throws RuntimeException {
                    }

                    public boolean onFile(File f, int depths) throws RuntimeException {
                        String name = f.getName().toLowerCase(Locale.ENGLISH);
                        if ("fav".equals(name) && f.isDirectory()) {
                            return false;
                        }
                        if (name.endsWith(".png") || IconIO.getSvgFactory() != null && name.endsWith(".svg")) {
                            files.add(f);
                        }
                        return true;
                    }

                    public void outro(File f) throws RuntimeException {
                    }
                }, (File)imagesDir, (int)5);
                final JList<File> list = new JList<File>(files.toArray(new File[0]));
                list.setLayoutOrientation(1);
                list.setVisibleRowCount(30);
                final ListCellRenderer<File> org = list.getCellRenderer();
                list.setCellRenderer(new ListCellRenderer(){

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        File f = (File)value;
                        JLabel ret = (JLabel)org.getListCellRendererComponent(list, "", index, isSelected, cellHasFocus);
                        try {
                            ret.setIcon(IconIO.getIcon((URL)f.toURI().toURL(), (int)20, (int)20));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        return ret;
                    }
                });
                list.setFixedCellHeight(24);
                list.setFixedCellWidth(24);
                list.setSelectionMode(0);
                list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        File v = (File)list.getSelectedValue();
                        String rel = Files.getRelativePath((File)imagesDir, (File)v);
                        rel = rel.substring(0, rel.length() - 4);
                        InfoPanel.this.item.setIconKey(rel);
                        InfoPanel.this.updateInfo(InfoPanel.this.item);
                        p.setVisible(false);
                        InfoPanel.this.managerFrame.fireUpdate();
                    }
                });
                p.setLayout((LayoutManager)new MigLayout("ins 5", "[grow,fill]", "[grow,fill]"));
                p.add(list, "width 32:n:n");
                p.show((Component)InfoPanel.this.iconChange, 0, InfoPanel.this.iconChange.getHeight());
            }
        }));
        this.namelabel = this.label(_GUI.T.InfoPanel_InfoPanel_itemname());
        this.add(this.namelabel);
        this.add((Component)this.name, "newline");
        this.nameReset = new JButton((Action)((Object)new AppAction(){
            {
                this.setIconKey("reset");
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        InfoPanel.this.name.setText(InfoPanel.this.resetName);
                        InfoPanel.this.item.setName(InfoPanel.this.resetName);
                        InfoPanel.this.updateInfo(InfoPanel.this.item);
                        InfoPanel.this.managerFrame.fireUpdate();
                    }
                };
            }
        }));
        this.add(this.nameReset, "width 22!,height 22!");
        this.add((Component)this.iconChange, "newline");
        this.iconKeyReset = new JButton((Action)((Object)new AppAction(){
            {
                this.setIconKey("reset");
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        InfoPanel.this.item.setIconKey(InfoPanel.this.resetIconKey);
                        InfoPanel.this.updateInfo(InfoPanel.this.item);
                        InfoPanel.this.managerFrame.fireUpdate();
                    }
                };
            }
        }));
        this.add(this.iconKeyReset, "width 22!,height 22!");
        this.shortcut = new ExtTextField();
        this.shortcut.setHelpText(_GUI.T.InfoPanel_InfoPanel_shortcuthelp2());
        this.shortcut.setEditable(false);
        this.shortcut.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent event) {
                String msg1 = KeyUtils.getShortcutString((KeyEvent)event, (boolean)true);
                KeyStroke currentShortcut = KeyStroke.getKeyStroke(event.getKeyCode(), event.getModifiersEx());
                InfoPanel.this.shortcut.setText(msg1);
                InfoPanel.this.item.setShortcut(currentShortcut == null ? null : currentShortcut.toString());
                InfoPanel.this.updateResetButtons(InfoPanel.this.item);
            }
        });
        if (this.managerFrame.getManager().isAcceleratorsEnabled()) {
            this.shortcutLabel = this.label(_GUI.T.InfoPanel_InfoPanel_shortcuts());
            this.add(this.shortcutLabel, "hidemode 3");
            this.add((Component)this.shortcut, "newline,hidemode 3");
            this.shortCutReset = new JButton((Action)((Object)new AppAction(){
                {
                    this.setIconKey("reset");
                }

                public void actionPerformed(ActionEvent e) {
                    new EDTRunner(){

                        protected void runInEDT() {
                            InfoPanel.this.item.setShortcut(InfoPanel.this.resetShortcut);
                            InfoPanel.this.updateInfo(InfoPanel.this.item);
                            InfoPanel.this.managerFrame.fireUpdate();
                        }
                    };
                }
            }));
            this.add(this.shortCutReset, "width 22!,height 22!,hidemode 3");
        }
        this.add(this.label(_GUI.T.InfoPanel_InfoPanel_hidden_2()));
        this.add(this.visibleBox, "spanx");
        this.add(new JSeparator(), "spanx");
        this.customPanel = new CustomPanel(this.managerFrame);
        this.add((Component)((Object)this.customPanel), "spanx,growx,pushx");
    }

    private JLabel label(String infoPanel_InfoPanel_hideIfDisabled) {
        return new JLabel(infoPanel_InfoPanel_hideIfDisabled);
    }

    public void updateResetButtons(MenuItemData value) {
        if (value == null) {
            this.iconKeyReset.setEnabled(false);
            this.iconKeyReset.setToolTipText(null);
            this.nameReset.setEnabled(false);
            this.nameReset.setToolTipText(null);
            if (this.shortCutReset != null) {
                this.shortCutReset.setEnabled(false);
                this.shortCutReset.setToolTipText(null);
            }
        } else {
            try {
                if (value.getActionData() == null || !value.getActionData()._isValidDataForCreatingAnAction() || value instanceof MenuLink) {
                    return;
                }
                ActionData actionData = value.getActionData();
                Class<?> clazz = actionData._getClazz();
                Constructor<?> c = clazz.getConstructor(new Class[0]);
                CustomizableAppAction ret = (CustomizableAppAction)((Object)c.newInstance(new Object[0]));
                ret.setMenuItemData(value);
                ret.initContextDefaults();
                ret.loadContextSetups();
                this.iconKeyReset.setEnabled(true);
                this.nameReset.setEnabled(true);
                if (this.shortCutReset != null) {
                    this.shortCutReset.setEnabled(true);
                }
                this.resetName = StringUtils.equals((String)this.name.getText(), (String)ret.getName()) ? "<EMPTY>" : ret.getName();
                this.resetIconKey = StringUtils.equals((String)value.getIconKey(), (String)ret.getIconKey()) ? "<EMPTY>" : ret.getIconKey();
                this.iconKeyReset.setToolTipText(_GUI.T.ManagerFrame_layoutPanel_resettodefault_parametered(this.resetIconKey));
                this.nameReset.setToolTipText(_GUI.T.ManagerFrame_layoutPanel_resettodefault_parametered(this.resetName));
                if (this.shortCutReset != null) {
                    this.resetShortcut = StringUtils.equals((String)value.getShortcut(), (String)(ret.getValue("AcceleratorKey") + "")) ? "<EMPTY>" : ret.getValue("AcceleratorKey") + "";
                    this.shortCutReset.setToolTipText(_GUI.T.ManagerFrame_layoutPanel_resettodefault_parametered(this.resetShortcut));
                }
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
    }

    public void updateInfo(MenuItemData value) {
        JComponent p = (JComponent)this.getParent().getParent().getParent();
        this.updateResetButtons(value);
        p.revalidate();
        this.item = value;
        if (value == null) {
            this.label.setText("");
            return;
        }
        this.visibleBox.setSelected(value.isVisible());
        MenuItemData mid = value;
        Object bounds = null;
        String n = mid.getName();
        this.name.setText(n);
        this.updateHeaderLabel(mid);
        this.customPanel.removeAll();
        CustomizableAppAction action = null;
        try {
            JComponent panel;
            if (mid.getActionData() != null && mid.getActionData()._isValidDataForCreatingAnAction() && !(mid instanceof MenuLink)) {
                KeyStroke ks;
                if (this.shortcutLabel != null) {
                    this.shortcutLabel.setVisible(true);
                }
                if (this.shortcut != null) {
                    this.shortcut.setVisible(true);
                }
                if (this.shortCutReset != null) {
                    this.shortCutReset.setVisible(true);
                }
                action = mid.createAction();
                this.name.setText(action.getName());
                if (StringUtils.isEmpty((String)action.getName())) {
                    this.name.setText("<EMPTY>");
                }
                if (MenuItemData.isEmptyValue(mid.getShortcut())) {
                    action.setAccelerator(null);
                }
                if ((ks = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                    this.shortcut.setText(KeyUtils.getShortcutString((KeyStroke)ks, (boolean)true));
                } else {
                    this.shortcut.setText("");
                }
                List<ActionContext> sos = action.getSetupObjects();
                if (sos != null) {
                    ArrayList entries = new ArrayList();
                    for (ActionContext so : sos) {
                        ArrayList gss = new ArrayList(ReflectionUtils.getGettersSetteres(so.getClass()));
                        ArrayList<Entry> toSort = new ArrayList<Entry>();
                        for (GetterSetter gs : gss) {
                            if (!gs.hasGetter() || !gs.hasSetter() || !gs.hasAnnotation(Customizer.class)) continue;
                            toSort.add(new Entry(mid, so, gs));
                        }
                        if (toSort.size() <= 0) continue;
                        Collections.sort(toSort, new Comparator<Entry>(){

                            @Override
                            public int compare(Entry o1, Entry o2) {
                                try {
                                    Order orderAn1 = (Order)o1.gs.getAnnotation(Order.class);
                                    Order orderAn2 = (Order)o2.gs.getAnnotation(Order.class);
                                    int order1 = orderAn1 == null ? Integer.MAX_VALUE : orderAn1.value();
                                    int order2 = orderAn2 == null ? Integer.MAX_VALUE : orderAn2.value();
                                    int ret = CompareUtils.compareInt((int)order1, (int)order2);
                                    if (ret != 0) {
                                        return ret;
                                    }
                                    Customizer oc1 = (Customizer)o1.gs.getAnnotation(Customizer.class);
                                    String lbl1 = oc1 != null ? CustomPanel.getNameForCustomizer(o1.gs) : o1.gs.getKey();
                                    Customizer oc2 = (Customizer)o2.gs.getAnnotation(Customizer.class);
                                    String lbl2 = oc2 != null ? CustomPanel.getNameForCustomizer(o2.gs) : o2.gs.getKey();
                                    return lbl1.compareToIgnoreCase(lbl2);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    return 0;
                                }
                            }
                        });
                        entries.addAll(toSort);
                    }
                    for (Entry e : entries) {
                        this.customPanel.add(e.mid.getActionData(), action, e.so, e.gs);
                    }
                }
            } else {
                this.shortcut.setText("");
                this.shortcutLabel.setVisible(false);
                this.shortcut.setVisible(false);
                if (this.shortCutReset != null) {
                    this.shortCutReset.setVisible(false);
                }
            }
            if (mid instanceof CustomSettingsPanelInterface) {
                panel = ((CustomSettingsPanelInterface)((Object)mid)).createSettingsPanel();
                if (panel != null) {
                    this.customPanel.add(panel, "pushx,growx");
                }
            } else if (action != null && action instanceof CustomSettingsPanelInterface && (panel = ((CustomSettingsPanelInterface)((Object)action)).createSettingsPanel()) != null) {
                this.customPanel.add(panel, "pushx,growx");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.revalidate();
    }

    public void updateHeaderLabel(MenuItemData mid) {
        String type = null;
        String name = mid.getName();
        Icon icon = null;
        if (mid.getIconKey() != null) {
            icon = MenuItemData.getIcon(mid.getIconKey(), 20);
        }
        if (mid instanceof MenuContainer) {
            type = _GUI.T.InfoPanel_update_submenu();
        } else if (mid instanceof SeparatorData) {
            name = _GUI.T.Renderer_getTreeCellRendererComponent_separator();
        } else if (mid instanceof MenuLink) {
            type = _GUI.T.InfoPanel_update_link();
        } else {
            if (mid._isValidated()) {
                try {
                    CustomizableAppAction action = mid.createAction();
                    if (StringUtils.isEmpty((String)name)) {
                        name = action.getName();
                    }
                    type = _GUI.T.InfoPanel_update_action();
                    if (icon == null) {
                        icon = action.getSmallIcon();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((String)name)) {
                name = mid.getActionData().getName();
            }
            if (icon == null && mid.getActionData().getIconKey() != null) {
                icon = NewTheme.I().getIcon(mid.getActionData().getIconKey(), 18);
            }
            if (StringUtils.isEmpty((String)name)) {
                name = mid.getActionData().getClazzName();
                name = name.substring(name.lastIndexOf(".") + 1);
            }
            if (MenuItemData.isEmptyValue(mid.getIconKey())) {
                icon = null;
            }
            if (MenuItemData.isEmptyValue(name)) {
                name = mid.getActionData().getClazzName();
                name = name.substring(name.lastIndexOf(".") + 1);
                name = name + "(<EMPTY>)";
            }
        }
        if (StringUtils.isNotEmpty((String)type)) {
            this.label.setText(_GUI.T.InfoPanel_updateInfo_header_actionlabel(name, type));
        } else {
            this.label.setText(name);
        }
        this.label.setIcon(icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.item.setVisible(this.visibleBox.isSelected());
        this.managerFrame.repaint();
    }

    private class Entry {
        private MenuItemData mid;
        private ActionContext so;
        private GetterSetter gs;

        public Entry(MenuItemData mid, ActionContext so, GetterSetter gs) {
            this.mid = mid;
            this.so = so;
            this.gs = gs;
        }
    }
}

