/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;

public class Renderer
implements TreeCellRenderer {
    private JLabel renderer = new RenderLabel();
    private Icon right;
    private Font bold;
    private Font defFont;
    private Dimension dim = new Dimension(500, 24);

    public Renderer() {
        this.defFont = this.renderer.getFont();
        this.bold = this.defFont.deriveFont(1);
        this.right = new AbstractIcon("right", 20);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String desc;
        MenuItemData mid = (MenuItemData)value;
        Object bounds = null;
        TreePath path = tree.getPathForRow(row);
        if (!mid.isVisible()) {
            this.renderer.setEnabled(false);
        } else {
            this.renderer.setEnabled(true);
        }
        Font font = this.defFont;
        String type = null;
        String name = mid.getName();
        StringBuilder tt = new StringBuilder();
        Icon icon = null;
        icon = MenuItemData.getIcon(mid.getIconKey(), 20);
        if (mid._isValidated() && StringUtils.isNotEmpty((String)(desc = mid._getDescription()))) {
            if (tt.length() > 0) {
                tt.append("; ");
            }
            tt.append(desc);
        }
        if (mid instanceof MenuContainer) {
            type = _GUI.T.InfoPanel_update_submenu();
            font = this.bold;
        } else if (mid instanceof SeparatorData) {
            name = _GUI.T.Renderer_getTreeCellRendererComponent_separator();
        } else if (mid instanceof MenuLink) {
            type = _GUI.T.InfoPanel_update_link();
        } else {
            if (mid._isValidated()) {
                try {
                    CustomizableAppAction action = mid.createAction();
                    if (action instanceof CustomizableAppAction) {
                        action.requestUpdate(this);
                    }
                    if (StringUtils.isEmpty((String)name)) {
                        name = action.getName();
                    }
                    type = _GUI.T.InfoPanel_update_action();
                    if (icon == null) {
                        icon = action.getSmallIcon();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((String)name)) {
                name = mid.getActionData().getName();
            }
            if (icon == null && mid.getActionData().getIconKey() != null) {
                icon = NewTheme.I().getIcon(mid.getActionData().getIconKey(), 18);
            }
            if (MenuItemData.isEmptyValue(mid.getIconKey())) {
                icon = null;
            }
            if (StringUtils.isEmpty((String)name)) {
                name = mid.getActionData().getClazzName();
                name = name.substring(name.lastIndexOf(".") + 1);
            }
            if (MenuItemData.isEmptyValue(name)) {
                name = mid.getActionData().getClazzName();
                name = name.substring(name.lastIndexOf(".") + 1);
                name = "<EMPTY>(" + name + ")";
            }
        }
        if (tt.length() > 0) {
            name = name + " (Description: " + tt + ")";
        }
        if (mid != null && mid.getActionData() != null && StringUtils.isNotEmpty((String)mid.getActionData().getClazzName()) && mid.getActionData().getClazzName().contains("eventscripter")) {
            name = "EventTrigger -> " + name;
        }
        if (StringUtils.isNotEmpty((String)type)) {
            if (StringUtils.equals((String)_GUI.T.InfoPanel_update_action(), (String)type)) {
                this.renderer.setText(name);
            } else {
                this.renderer.setText(_GUI.T.InfoPanel_updateInfo_header_actionlabel(name, type));
            }
        } else {
            this.renderer.setText(name);
        }
        this.renderer.setFont(font);
        this.renderer.setIcon(icon);
        return this.renderer;
    }
}

