/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.ffmpeg;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import jd.http.Browser;
import jd.plugins.PluginProgress;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.resources.AWUTheme;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.net.httpserver.HttpServer;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.controlling.ffmpeg.FFMpegException;
import org.jdownloader.controlling.ffmpeg.FFMpegProgress;
import org.jdownloader.controlling.ffmpeg.FFmpegSetup;

public abstract class AbstractFFmpegBinary {
    protected final FFmpegSetup config = (FFmpegSetup)JsonConfig.create(FFmpegSetup.class);
    protected final Browser sourceBrowser;
    private String path;
    protected HttpServer server;
    protected long processID;
    private final AtomicLong lastUpdateTimeStamp = new AtomicLong(0L);
    private static final HashMap<String, String> DEFAULT_FORMAT_BY_EXTENSION = new HashMap();
    private static final AtomicBoolean ROSETTA_2_DIALOG_SHOWN;

    public abstract LogInterface getLogger();

    public Set<FLAG> getSupportedFlags() {
        LogInterface logger = this.getLogger();
        try {
            HashSet<FLAG> ret = null;
            for (FLAGTYPE flagType : FLAGTYPE.values()) {
                Set<FLAG> supported = this.getSupported(flagType);
                if (supported == null) continue;
                if (ret == null) {
                    ret = new HashSet<FLAG>();
                }
                ret.addAll(supported);
            }
            if (ret != null) {
                logger.info("ffmpeg: " + ret);
            }
            return ret;
        }
        catch (Throwable e) {
            logger.log(e);
            return null;
        }
    }

    public AbstractFFmpegBinary(Browser br) {
        this.sourceBrowser = br;
    }

    protected Set<FLAG> getSupported(FLAGTYPE flagType) throws InterruptedException, IOException {
        String fullPath = this.getFullPath();
        if (fullPath != null) {
            String[] ret;
            int timeout = 10000;
            File root = Application.getApplicationRoot();
            switch (flagType) {
                case CODEC: {
                    ret = this.execute(10000, null, root, fullPath, "-codecs");
                    break;
                }
                case FORMAT: {
                    ret = this.execute(10000, null, root, fullPath, "-formats");
                    break;
                }
                default: {
                    ret = this.execute(10000, null, root, fullPath);
                }
            }
            if (ret != null) {
                HashSet<FLAG> supported = new HashSet<FLAG>();
                block4: for (FLAG flag : FLAG.values()) {
                    if (flag.getType() != flagType) continue;
                    for (String output : ret) {
                        if (!flag.isSupported(output)) continue;
                        supported.add(flag);
                        continue block4;
                    }
                }
                return supported;
            }
        }
        return null;
    }

    protected Boolean isSupported(FLAG flag) throws InterruptedException, IOException {
        String fullPath = this.getFullPath();
        if (fullPath != null) {
            String[] ret;
            int timeout = 10000;
            File root = Application.getApplicationRoot();
            switch (flag.getType()) {
                case CODEC: {
                    ret = this.execute(10000, null, root, fullPath, "-codecs");
                    break;
                }
                case FORMAT: {
                    ret = this.execute(10000, null, root, fullPath, "-formats");
                    break;
                }
                default: {
                    ret = this.execute(10000, null, root, fullPath);
                }
            }
            if (ret != null) {
                for (String output : ret) {
                    if (!flag.isSupported(output)) continue;
                    return true;
                }
                return false;
            }
        }
        return null;
    }

    protected Browser getRequestBrowser() {
        Browser ret = this.sourceBrowser.cloneBrowser();
        ret.setConnectTimeout(30000);
        ret.setReadTimeout(30000);
        ret.setFollowRedirects(true);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] execute(final int timeout, PluginProgress progess, File runin, String ... cmds) throws InterruptedException, IOException {
        ProcessBuilder pb = ProcessBuilderFactory.create((String[])cmds);
        if (runin != null) {
            pb.directory(runin);
        }
        final Process process = pb.start();
        final AtomicBoolean processExitedFlag = new AtomicBoolean(false);
        final AccessibleByteArrayOutputStream stdout = new AccessibleByteArrayOutputStream();
        String[] stderr = new AccessibleByteArrayOutputStream();
        Thread stdoutThread = new Thread("ffmpegReader:stdout"){

            @Override
            public void run() {
                try {
                    AbstractFFmpegBinary.this.readInputStreamToString(stdout, processExitedFlag, process.getInputStream(), true);
                }
                catch (Throwable e) {
                    AbstractFFmpegBinary.this.getLogger().log(e);
                }
            }
        };
        Thread stderrThread = new Thread("ffmpegReader:stderr", (AccessibleByteArrayOutputStream)stderr, processExitedFlag, process){
            final /* synthetic */ AccessibleByteArrayOutputStream val$stderr;
            final /* synthetic */ AtomicBoolean val$processExitedFlag;
            final /* synthetic */ Process val$process;
            {
                this.val$stderr = accessibleByteArrayOutputStream;
                this.val$processExitedFlag = atomicBoolean;
                this.val$process = process;
                super(x0);
            }

            @Override
            public void run() {
                try {
                    AbstractFFmpegBinary.this.readInputStreamToString(this.val$stderr, this.val$processExitedFlag, this.val$process.getErrorStream(), false);
                }
                catch (Throwable e) {
                    AbstractFFmpegBinary.this.getLogger().log(e);
                }
            }
        };
        try {
            String lastStdout;
            stdoutThread.start();
            stderrThread.start();
            if (timeout > 0) {
                String lastStdout2;
                final AtomicBoolean timeoutReached = new AtomicBoolean(false);
                final AtomicBoolean processAlive = new AtomicBoolean(true);
                Thread timouter = new Thread("ffmpegReaderTimeout"){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(timeout);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (processAlive.compareAndSet(true, false)) {
                            timeoutReached.set(true);
                            process.destroy();
                        }
                    }
                };
                timouter.start();
                this.getLogger().info("ExitCode1: " + process.waitFor());
                processAlive.set(false);
                processExitedFlag.set(true);
                AtomicBoolean atomicBoolean = processExitedFlag;
                synchronized (atomicBoolean) {
                    processExitedFlag.notifyAll();
                }
                timouter.interrupt();
                if (timeoutReached.get()) {
                    throw new InterruptedException("Timeout!");
                }
                this.waitForReader(this.getLogger(), stdoutThread, 1000);
                this.waitForReader(this.getLogger(), stderrThread, 1000);
                AccessibleByteArrayOutputStream accessibleByteArrayOutputStream = stdout;
                synchronized (accessibleByteArrayOutputStream) {
                    lastStdout2 = stdout.toString("UTF-8");
                }
                String[] stringArray = stderr;
                synchronized (stderr) {
                    String lastStderr = stderr.toString("UTF-8");
                    // ** MonitorExit[var17_23] (shouldn't be in output)
                    stringArray = new String[]{lastStdout2, lastStderr};
                    return stringArray;
                }
            }
            this.getLogger().info("ExitCode2: " + process.waitFor());
            processExitedFlag.set(true);
            AtomicBoolean timeoutReached = processExitedFlag;
            synchronized (timeoutReached) {
                processExitedFlag.notifyAll();
            }
            this.waitForReader(this.getLogger(), stdoutThread, 1000);
            this.waitForReader(this.getLogger(), stderrThread, 1000);
            AccessibleByteArrayOutputStream processAlive = stdout;
            synchronized (processAlive) {
                lastStdout = stdout.toString("UTF-8");
            }
            String[] stringArray = stderr;
            synchronized (stderr) {
                String lastStderr = stderr.toString("UTF-8");
                // ** MonitorExit[var14_17] (shouldn't be in output)
                stringArray = new String[]{lastStdout, lastStderr};
                return stringArray;
            }
        }
        finally {
            processExitedFlag.set(true);
            AtomicBoolean atomicBoolean = processExitedFlag;
            synchronized (atomicBoolean) {
                processExitedFlag.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void readInputStreamToString(AccessibleByteArrayOutputStream bos, AtomicBoolean processExitedFlag, InputStream fis, boolean isStdout) throws IOException {
        block29: {
            logger = this.getLogger();
            size = 0L;
            try {
                buf = new byte[8192];
                isInstantFlush = logger != null && logger instanceof LogSource != false ? ((LogSource)logger).isInstantFlush() : false;
                lastReadPosition = 0;
                lastSize = 0;
                while (true) {
                    if (fis.available() <= 0 && !processExitedFlag.get()) ** GOTO lbl45
                    read = fis.read(buf);
                    if (read == -1) {
                        return;
                    }
                    if (read > 0) {
                        size += (long)read;
                        var13_15 = bos;
                        synchronized (var13_15) {
                            if (bos.size() < lastSize) {
                                lastReadPosition = 0;
                            }
                            bos.write(buf, 0, read);
                            lastSize = bos.size();
                            array = bos.getBuf();
                            for (index = lastReadPosition; index < bos.size(); ++index) {
                                if (array[index] != 10 && array[index] != 13) continue;
                                length = index - 1 - lastReadPosition;
                                if (length > 0) {
                                    line = new String(array, lastReadPosition, length, "UTF-8");
                                    if (isInstantFlush) {
                                        logger.info(isStdout + "|" + line);
                                    }
                                    this.parseLine(isStdout, line);
                                }
                                lastReadPosition = index + 1;
                            }
                            continue;
                        }
                    }
                    var13_15 = processExitedFlag;
                    synchronized (var13_15) {
                        if (!processExitedFlag.get()) {
                            processExitedFlag.wait(100L);
                        }
                        continue;
                    }
lbl45:
                    // 1 sources

                    var12_14 = processExitedFlag;
                    synchronized (var12_14) {
                        if (!processExitedFlag.get()) {
                            processExitedFlag.wait(100L);
                        }
                    }
                }
                catch (IOException e) {
                    if (!"Stream closed".equals(e.getMessage())) {
                        throw e;
                    }
                    break block29;
                }
                catch (Throwable e) {
                    throw new IOException(e);
                }
            }
            finally {
                if (isStdout) {
                    logger.info("Read(Stdout):" + size + "|Exited:" + processExitedFlag.get());
                } else {
                    logger.info("Read(Stderr):" + size + "|Exited:" + processExitedFlag.get());
                }
            }
        }
    }

    protected void parseLine(boolean isStdout, String line) {
    }

    protected String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isAvailable() {
        return this.getFullPath() != null;
    }

    public boolean isCompatible() {
        return true;
    }

    public String getFullPath() {
        try {
            String path = this.getPath();
            if (StringUtils.isEmpty((String)path)) {
                throw new Exception("path is empty!");
            }
            File file = new File(path);
            if (!file.isAbsolute()) {
                file = Application.getResource((String)path);
            }
            if (!file.exists()) {
                throw new Exception("doesn't exist" + file.getAbsolutePath());
            }
            if (!file.isFile()) {
                throw new Exception("not a file:" + file.getAbsolutePath());
            }
            if (Application.getJavaVersion() >= Application.JAVA16 && !file.canExecute()) {
                file.setExecutable(true);
            }
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            this.getLogger().log((Throwable)e);
            return null;
        }
    }

    public ArrayList<String> fillCommand(String out, String videoIn, String audioIn, HashMap<String, String[]> map, String ... mc) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getFullPath());
        if (CrossSystem.isWindows()) {
            if (videoIn != null && videoIn.length() > 259) {
                videoIn = "\\\\?\\" + videoIn;
            }
            if (audioIn != null && audioIn.length() > 259) {
                audioIn = "\\\\?\\" + audioIn;
            }
            if (out != null && out.length() > 259) {
                out = "\\\\?\\" + out;
            }
        }
        block0: for (int i = 0; i < mc.length; ++i) {
            String param = mc[i];
            param = param.replace("%video", videoIn == null ? "" : videoIn);
            param = param.replace("%audio", audioIn == null ? "" : audioIn);
            param = param.replace("%out", out);
            if (map != null) {
                for (Map.Entry<String, String[]> es : map.entrySet()) {
                    if (!param.equals(es.getKey())) continue;
                    for (String s : es.getValue()) {
                        commandLine.add(s);
                    }
                    continue block0;
                }
            }
            commandLine.add(param);
        }
        return commandLine;
    }

    protected void closePipe() {
        HttpServer server = this.server;
        this.server = null;
        if (server != null) {
            server.stop();
        }
    }

    public void updateLastUpdateTimestamp() {
        this.updateLastUpdateTimestamp(0L);
    }

    public void updateLastUpdateTimestamp(long add) {
        this.lastUpdateTimeStamp.set(System.currentTimeMillis() + Math.max(0L, add));
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimeStamp.get();
    }

    protected void initPipe(final String m3u8URL) throws IOException {
        if (this.sourceBrowser == null) {
            return;
        }
        this.server = new HttpServer(0);
        this.server.setLocalhostOnly(true);
        final HttpServer finalServer = this.server;
        this.server.start();
        final AtomicReference m3u8 = new AtomicReference();
        final LogInterface logger = this.getLogger();
        finalServer.registerRequestHandler(new HttpRequestHandler(){
            final byte[] readBuf = new byte[512];

            private final boolean validateID(HttpRequest request) throws IOException {
                String id = request.getParameterbyKey("id");
                if (id == null) {
                    return false;
                }
                return AbstractFFmpegBinary.this.processID == Long.parseLong(request.getParameterbyKey("id"));
            }

            public boolean onPostRequest(PostRequest request, HttpResponse response) {
                try {
                    logger.info(request.toString());
                    if (!this.validateID((HttpRequest)request)) {
                        return false;
                    }
                    if ("/progress".equals(request.getRequestedPath())) {
                        while (request.getInputStream().read(this.readBuf) != -1) {
                        }
                        response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
                        return true;
                    }
                }
                catch (Exception e) {
                    logger.log((Throwable)e);
                }
                return false;
            }

            /*
             * Exception decompiling
             */
            public boolean onGetRequest(GetRequest request, HttpResponse response) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[CATCHBLOCK]], but top level block is 14[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public boolean requiresAdtstoAsc(String format) {
        return "ipod".equalsIgnoreCase(format) || "mp4".equalsIgnoreCase(format) || "m4v".equalsIgnoreCase(format) || "m4a".equalsIgnoreCase(format) || "mov".equalsIgnoreCase(format) || "flv".equalsIgnoreCase(format);
    }

    public String getDefaultFormatByFileName(String fileName) {
        String checkForExtension = fileName;
        int dotIndex = checkForExtension.lastIndexOf(".");
        while (dotIndex > 0) {
            String ext = checkForExtension.substring(dotIndex, checkForExtension.length()).toLowerCase(Locale.ENGLISH);
            String format = DEFAULT_FORMAT_BY_EXTENSION.get(ext);
            if (format != null) {
                return format;
            }
            checkForExtension = checkForExtension.substring(0, dotIndex);
            dotIndex = checkForExtension.lastIndexOf(".");
        }
        return null;
    }

    private boolean isLocalhost(List<String> commandLine) {
        if (commandLine != null) {
            for (String cmd : commandLine) {
                if (StringUtils.containsIgnoreCase((String)cmd, (String)"127.0.0.1") || StringUtils.contains((String)cmd, (String)"[::1]") || StringUtils.contains((String)cmd, (String)"[0:0:0:0:0:0:0:1]")) {
                    return true;
                }
                if (!StringUtils.containsIgnoreCase((String)cmd, (String)"localhost")) continue;
                return true;
            }
        }
        return false;
    }

    public static void showRosetta2Dialog(final AbstractFFmpegBinary ffmpeg) throws InterruptedException {
        if (!ROSETTA_2_DIALOG_SHOWN.get()) {
            Thread thread = new Thread("RosettaDialog"){
                {
                    super(x0);
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    block7: {
                        if (ROSETTA_2_DIALOG_SHOWN.compareAndSet(false, true)) {
                            try {
                                try {
                                    Dialog.getInstance().showConfirmDialog(32, _AWU.T.DIALOG_MESSAGE_TITLE(), "Intel ffmpeg binary requires Rosetta 2 to be installed! Do you want to install Rosetta 2 now?", AWUTheme.I().getIcon(Dialog.ICON_WARNING, 32), null, null, "test3");
                                    ProcessBuilder pb = ProcessBuilderFactory.create(Arrays.asList("/usr/sbin/softwareupdate", "--install-rosetta", "--agree-to-license"));
                                    ProcessBuilderFactory.runCommand((ProcessBuilder)pb, (OutputStream)new NullOutputStream(), (OutputStream)new NullOutputStream());
                                }
                                catch (Exception e) {
                                    if (ffmpeg == null) {
                                        e.printStackTrace();
                                        break block7;
                                    }
                                    ffmpeg.getLogger().log((Throwable)e);
                                }
                            }
                            finally {
                                ROSETTA_2_DIALOG_SHOWN.compareAndSet(true, false);
                            }
                        }
                    }
                }
            };
            thread.start();
            thread.join();
        }
    }

    private void waitForReader(LogInterface logger, Thread thread, int waitTimeout) throws InterruptedException {
        if (thread.isAlive()) {
            logger.info("Wait for Reader:" + thread);
            thread.join(waitTimeout);
            logger.info("Reader:" + thread + " still alive?" + thread.isAlive());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runCommand(FFMpegProgress progress, ArrayList<String> commandLine) throws IOException, InterruptedException, FFMpegException {
        Process process;
        final LogInterface logger = this.getLogger();
        logger.info("runCommand(ProcessBuilderFactory):" + commandLine);
        ProcessBuilder pb = ProcessBuilderFactory.create(commandLine);
        Map<String, String> env = pb.environment();
        if (this.isLocalhost(commandLine) && env != null) {
            logger.info("unset SysEnv:https_proxy=" + env.remove("https_proxy"));
            logger.info("unset SysEnv:http_proxy=" + env.remove("http_proxy"));
        }
        logger.info("runCommand(ProcessBuilder):" + pb.command());
        try {
            process = pb.start();
        }
        catch (IOException e) {
            if (CrossSystem.isMac() && CrossSystem.ARCHFamily.ARM.equals((Object)CrossSystem.getARCHFamily()) && StringUtils.contains((String)e.getMessage(), (String)"Bad CPU type in executable")) {
                AbstractFFmpegBinary.showRosetta2Dialog(this);
                throw new FFMpegException("Rosetta required to use intel ffmpeg binary", e);
            }
            throw e;
        }
        final AccessibleByteArrayOutputStream stdout = new AccessibleByteArrayOutputStream();
        final AccessibleByteArrayOutputStream stderr = new AccessibleByteArrayOutputStream();
        final AtomicBoolean processExitedFlag = new AtomicBoolean(false);
        try {
            Thread stdoutThread = new Thread("ffmpegReader:stdout"){

                @Override
                public void run() {
                    try {
                        AbstractFFmpegBinary.this.readInputStreamToString(stdout, processExitedFlag, process.getInputStream(), true);
                    }
                    catch (Throwable e) {
                        logger.log(e);
                    }
                }
            };
            Thread stderrThread = new Thread("ffmpegReader:stderr"){

                @Override
                public void run() {
                    try {
                        AbstractFFmpegBinary.this.readInputStreamToString(stderr, processExitedFlag, process.getErrorStream(), false);
                    }
                    catch (Throwable e) {
                        logger.log(e);
                    }
                }
            };
            stdoutThread.start();
            stderrThread.start();
            this.updateLastUpdateTimestamp();
            long lastDuration = -1L;
            long lastRead = -1L;
            String lastNonEmptyStderr = null;
            while (true) {
                String[] times;
                String duration;
                String currentStderr;
                long read = 0L;
                AccessibleByteArrayOutputStream accessibleByteArrayOutputStream = stdout;
                synchronized (accessibleByteArrayOutputStream) {
                    read = stdout.size();
                }
                AccessibleByteArrayOutputStream accessibleByteArrayOutputStream2 = stderr;
                synchronized (accessibleByteArrayOutputStream2) {
                    read += (long)stderr.size();
                    int lastRN = 0;
                    byte[] array = stderr.getBuf();
                    for (int index = 0; index < stderr.size(); ++index) {
                        if (array[index] != 10 && array[index] != 13) continue;
                        lastRN = index;
                    }
                    if (lastRN > 0) {
                        this.updateLastUpdateTimestamp();
                        currentStderr = new String(array, 0, lastRN, "UTF-8");
                        int length = stderr.size() - lastRN - 1;
                        if (length == 0) {
                            stderr.reset();
                        } else {
                            byte[] tmpBuf = stderr.toByteArray();
                            stderr.reset();
                            stderr.write(tmpBuf, lastRN, length);
                        }
                    } else {
                        currentStderr = null;
                    }
                }
                if (StringUtils.isNotEmpty(currentStderr)) {
                    lastNonEmptyStderr = currentStderr;
                    this.updateLastUpdateTimestamp();
                }
                if (read != lastRead) {
                    this.updateLastUpdateTimestamp();
                    lastRead = read;
                }
                if ((duration = new Regex(currentStderr, "Duration\\: (.*?).?\\d*?\\, start").getMatch(0)) != null) {
                    lastDuration = AbstractFFmpegBinary.formatStringToMilliseconds(duration);
                }
                if (lastDuration > 0L && (times = new Regex(currentStderr, "time=(.*?).?\\d*? ").getColumn(0)) != null && times.length > 0) {
                    long msDone = AbstractFFmpegBinary.formatStringToMilliseconds(times[times.length - 1]);
                    if (progress != null) {
                        progress.updateValues(msDone, lastDuration);
                    }
                }
                try {
                    boolean okay;
                    int stdoutSize;
                    String lastStdout;
                    String lastStderr;
                    int stderrSize;
                    AccessibleByteArrayOutputStream accessibleByteArrayOutputStream3 = stderr;
                    synchronized (accessibleByteArrayOutputStream3) {
                        stderrSize = stderr.size();
                        lastStderr = lastNonEmptyStderr != null ? lastNonEmptyStderr + stderr.toString("UTF-8") : stderr.toString("UTF-8");
                    }
                    accessibleByteArrayOutputStream3 = stdout;
                    synchronized (accessibleByteArrayOutputStream3) {
                        lastStdout = stdout.toString("UTF-8");
                        stdoutSize = stdout.size();
                    }
                    int exitCode = this.exitProcess(process, lastStdout, lastStderr);
                    processExitedFlag.set(true);
                    Object object = processExitedFlag;
                    synchronized (object) {
                        processExitedFlag.notifyAll();
                    }
                    this.waitForReader(logger, stdoutThread, 1000);
                    object = stderr;
                    synchronized (object) {
                        stderrSize = stderr.size();
                        lastStderr = lastNonEmptyStderr != null ? lastNonEmptyStderr + stderr.toString("UTF-8") : stderr.toString("UTF-8");
                    }
                    object = stdout;
                    synchronized (object) {
                        lastStdout = stdout.toString("UTF-8");
                        stdoutSize = stdout.size();
                    }
                    logger.info("LastStdout(Exited):(" + stdoutSize + ")" + lastStdout);
                    logger.info("LastStderr(Exited):(" + stderrSize + ")" + lastStderr);
                    logger.info("ExitCode:" + exitCode);
                    boolean bl = okay = exitCode == 0;
                    if (!okay) {
                        if (StringUtils.containsIgnoreCase((String)lastStderr, (String)"No such file or directory") || StringUtils.containsIgnoreCase((String)lastStderr, (String)"Invalid argument")) {
                            throw new FFMpegException("FFmpeg Failed: path too long?", lastStdout, lastStderr, FFMpegException.ERROR.PATH_LENGTH);
                        }
                        if (StringUtils.containsIgnoreCase((String)lastStderr, (String)"Unrecognized option 'c:v'") || StringUtils.containsIgnoreCase((String)lastStderr, (String)"Unrecognized option '-c:v'")) {
                            throw new FFMpegException("FFmpeg Failed: version too old", lastStdout, lastStderr, FFMpegException.ERROR.TOO_OLD);
                        }
                        if (StringUtils.containsIgnoreCase((String)lastStderr, (String)"No space left on device") && StringUtils.containsIgnoreCase((String)lastStderr, (String)"Error writing")) {
                            throw new FFMpegException("FFmpeg Failed: disk full", lastStdout, lastStderr, FFMpegException.ERROR.DISK_FULL);
                        }
                        if (StringUtils.containsIgnoreCase((String)lastStderr, (String)": Protocol not found'") || StringUtils.containsIgnoreCase((String)lastStderr, (String)"Did you mean file:http")) {
                            throw new FFMpegException("FFmpeg Failed: version does not support http protocol", lastStdout, lastStderr, FFMpegException.ERROR.INCOMPATIBLE);
                        }
                        throw new FFMpegException("FFmpeg Failed", lastStdout, lastStderr);
                    }
                    String string = lastStdout;
                    return string;
                }
                catch (IllegalThreadStateException lastStderr) {
                    try {
                        if (System.currentTimeMillis() - this.getLastUpdateTimestamp() > this.getLastUpdateTimestampTimeout()) {
                            int stdoutSize;
                            String lastStdout;
                            String lastStderr2;
                            int stderrSize;
                            AccessibleByteArrayOutputStream stderrSize2 = stderr;
                            synchronized (stderrSize2) {
                                stderrSize = stderr.size();
                                lastStderr2 = lastNonEmptyStderr != null ? lastNonEmptyStderr + stderr.toString("UTF-8") : stderr.toString("UTF-8");
                            }
                            AccessibleByteArrayOutputStream accessibleByteArrayOutputStream4 = stdout;
                            synchronized (accessibleByteArrayOutputStream4) {
                                lastStdout = stdout.toString("UTF-8");
                                stdoutSize = stdout.size();
                            }
                            logger.info("LastStdout(Timeout):(" + stdoutSize + ")" + lastStdout);
                            logger.info("LastStderr(Timeout):(" + stderrSize + ")" + lastStderr2);
                            throw new InterruptedException("FFmpeg does not answer");
                        }
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.log((Throwable)e);
                        throw e;
                    }
                }
                break;
            }
        }
        finally {
            processExitedFlag.set(true);
            AtomicBoolean atomicBoolean = processExitedFlag;
            synchronized (atomicBoolean) {
                processExitedFlag.notifyAll();
            }
            if (process != null) {
                process.destroy();
            }
            stdout.close();
            stderr.close();
        }
    }

    protected int exitProcess(Process process, String stdout, String stderr) throws IllegalThreadStateException {
        return process.exitValue();
    }

    protected long getLastUpdateTimestampTimeout() {
        return 60000L;
    }

    public static long formatStringToMilliseconds(String text) {
        String[] found = new Regex(text, "(\\d+):(\\d+):(\\d+)").getRow(0);
        if (found == null) {
            return 0L;
        }
        int hours = Integer.parseInt(found[0]);
        int minutes = Integer.parseInt(found[1]);
        int seconds = Integer.parseInt(found[2]);
        return hours * 60 * 60 * 1000 + minutes * 60 * 1000 + seconds * 1000;
    }

    static {
        DEFAULT_FORMAT_BY_EXTENSION.put(".mp3", "mp3");
        DEFAULT_FORMAT_BY_EXTENSION.put(".mp4", "mp4");
        DEFAULT_FORMAT_BY_EXTENSION.put(".mpg", "mpeg");
        DEFAULT_FORMAT_BY_EXTENSION.put(".mov", "mov");
        DEFAULT_FORMAT_BY_EXTENSION.put(".avi", "avi");
        DEFAULT_FORMAT_BY_EXTENSION.put(".flv", "flv");
        DEFAULT_FORMAT_BY_EXTENSION.put(".ogg", "ogg");
        DEFAULT_FORMAT_BY_EXTENSION.put(".opus", "opus");
        DEFAULT_FORMAT_BY_EXTENSION.put(".mkv", "matroska");
        DEFAULT_FORMAT_BY_EXTENSION.put(".webm", "webm");
        DEFAULT_FORMAT_BY_EXTENSION.put(".mpeg", "mpeg");
        DEFAULT_FORMAT_BY_EXTENSION.put(".aac", "adts");
        DEFAULT_FORMAT_BY_EXTENSION.put(".wav", "wav");
        DEFAULT_FORMAT_BY_EXTENSION.put(".m4a", "ipod");
        DEFAULT_FORMAT_BY_EXTENSION.put(".m4v", "ipod");
        ROSETTA_2_DIALOG_SHOWN = new AtomicBoolean(false);
    }

    protected final class AccessibleByteArrayOutputStream
    extends ByteArrayOutputStream {
        public AccessibleByteArrayOutputStream(int size) {
            super(size);
        }

        public AccessibleByteArrayOutputStream() {
        }

        public final synchronized byte[] getBuf() {
            return this.buf;
        }
    }

    public static enum FLAG {
        OPUS(FLAGTYPE.CODEC, "D.A...\\s*opus"),
        VORBIS(FLAGTYPE.CODEC, "D.A...\\s*vorbis"),
        AV1(FLAGTYPE.CODEC, "D.V...\\s*av1"),
        WEBM(FLAGTYPE.FORMAT, "E\\s*(webm|matroska,webm)"),
        DASH(FLAGTYPE.FORMAT, "E\\s*dash"),
        HLS(FLAGTYPE.FORMAT, "D\\s*(hls|applehttp)");

        private final Pattern pattern;
        private final FLAGTYPE type;

        private FLAG(FLAGTYPE type, String pattern) {
            this.pattern = Pattern.compile(pattern);
            this.type = type;
        }

        public FLAGTYPE getType() {
            return this.type;
        }

        public boolean isSupported(String string) {
            return this.pattern.matcher(string).find();
        }
    }

    public static enum FLAGTYPE {
        LIB,
        FORMAT,
        CODEC;

    }
}

