/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.ffmpeg;

import java.io.File;
import java.util.Locale;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.ffmpeg.FFMpegInstallTypeChooserDialog;
import org.jdownloader.controlling.ffmpeg.FFmpegProvider;
import org.jdownloader.controlling.ffmpeg.FFmpegSetup;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.UpdateController;

public class FFMpegInstallThread
extends Thread {
    private final FFmpegProvider fFmpegProvider;
    private volatile long progress = -1L;
    private volatile boolean success = false;
    private final String task;

    public FFMpegInstallThread(FFmpegProvider fFmpegProvider, String task) {
        this.fFmpegProvider = fFmpegProvider;
        this.task = task;
    }

    public boolean isSuccessFul() {
        return this.success;
    }

    public long getProgress() {
        return this.progress;
    }

    private boolean isFile(File file) {
        if (CrossSystem.isMac()) {
            return file != null && file.exists() && !file.isDirectory();
        }
        return file != null && file.isFile();
    }

    public static String getFFmpegExtensionName() {
        ExtensionPackages extension = ExtensionPackages.getExtension();
        return extension != null ? extension.extensionID : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            File ffprobe;
            File ffmpeg;
            ExtensionPackages extension = ExtensionPackages.getExtension();
            File file = ffmpeg = extension != null ? extension.getBundledBinaryPath(BINARY.FFMPEG) : null;
            if (!this.isFile(ffmpeg)) {
                ffmpeg = null;
            }
            File file2 = ffprobe = extension != null ? extension.getBundledBinaryPath(BINARY.FFPROBE) : null;
            if (!this.isFile(ffprobe)) {
                ffprobe = null;
            }
            if ((ffmpeg == null || ffprobe == null) && extension != null) {
                ConfirmDialogInterface res;
                String extensionID;
                LogSource logger = LogController.CL();
                if (logger != null) {
                    logger.info("FFMpegInstallThread:" + (Object)((Object)extension) + "|ExtensionID:" + extension.extensionID + "|FFmpeg:" + ffmpeg + "|FFprobe:" + ffprobe);
                }
                if ((extensionID = extension.extensionID) != null && (res = (ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)new FFMpegInstallTypeChooserDialog(this.task))).getCloseReason() == CloseReason.OK) {
                    UpdateController.getInstance().setGuiVisible(true);
                    try {
                        if (UpdateController.getInstance().isExtensionInstalled(extensionID)) {
                            UpdateController.getInstance().runExtensionUnInstallation(extensionID);
                        }
                        UpdateController.getInstance().runExtensionInstallation(extensionID);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            File file3 = ffmpeg = extension != null ? extension.getBundledBinaryPath(BINARY.FFMPEG) : null;
            if (this.isFile(ffmpeg)) {
                ((FFmpegSetup)JsonConfig.create(FFmpegSetup.class)).setBinaryPath(ffmpeg.getAbsolutePath());
            } else {
                ffmpeg = null;
            }
            File file4 = ffprobe = extension != null ? extension.getBundledBinaryPath(BINARY.FFPROBE) : null;
            if (this.isFile(ffprobe)) {
                ((FFmpegSetup)JsonConfig.create(FFmpegSetup.class)).setBinaryPathProbe(ffprobe.getAbsolutePath());
            } else {
                ffprobe = null;
            }
            this.success = ffmpeg != null && ffprobe != null;
        }
        finally {
            if (this.fFmpegProvider != null) {
                FFmpegProvider fFmpegProvider = this.fFmpegProvider;
                synchronized (fFmpegProvider) {
                    this.fFmpegProvider.installThread = null;
                }
            }
        }
    }

    public static enum BINARY {
        FFMPEG,
        FFPROBE;

    }

    private static enum ExtensionPackages {
        MAC_BIG_SUR_AS("ffmpeg_as_11+"){

            @Override
            protected boolean isSupported() {
                return false;
            }

            @Override
            protected File getBundledBinaryPath(BINARY binary) {
                String binaryName = binary.name().toLowerCase(Locale.ENGLISH);
                return Application.getResource((String)("tools/mac/" + this.extensionID + "/" + binaryName));
            }
        }
        ,
        MAC_YOSEMITE("ffmpeg_10.10+"){

            @Override
            protected boolean isSupported() {
                return CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.MAC_YOSEMITE);
            }

            @Override
            protected File getBundledBinaryPath(BINARY binary) {
                String binaryName = binary.name().toLowerCase(Locale.ENGLISH);
                return Application.getResource((String)("tools/mac/" + this.extensionID + "/" + binaryName));
            }
        }
        ,
        MAC_SNOW_LEOPOARD("ffmpeg_10.6+"){

            @Override
            protected boolean isSupported() {
                return CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.MAC_SNOW_LEOPOARD);
            }

            @Override
            protected File getBundledBinaryPath(BINARY binary) {
                String binaryName = binary.name().toLowerCase(Locale.ENGLISH);
                return Application.getResource((String)("tools/mac/" + this.extensionID + "/" + binaryName));
            }
        }
        ,
        MAC_LEOPOARD("ffmpeg_10.5.x-"){

            @Override
            protected boolean isSupported() {
                return CrossSystem.isMac() && (!CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.MAC_SNOW_LEOPOARD) || !CrossSystem.is64BitOperatingSystem());
            }

            @Override
            protected File getBundledBinaryPath(BINARY binary) {
                String binaryName = binary.name().toLowerCase(Locale.ENGLISH);
                return Application.getResource((String)("tools/mac/" + this.extensionID + "/" + binaryName));
            }
        }
        ,
        LINUX("ffmpeg"){

            @Override
            protected boolean isSupported() {
                return CrossSystem.isLinux() && CrossSystem.ARCHFamily.X86.equals((Object)CrossSystem.getARCHFamily());
            }

            @Override
            protected File getBundledBinaryPath(BINARY binary) {
                return GENERIC.getBundledBinaryPath(binary);
            }
        }
        ,
        WINDOWS("ffmpeg"){

            @Override
            protected boolean isSupported() {
                return CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_VISTA);
            }

            @Override
            protected File getBundledBinaryPath(BINARY binary) {
                String binaryName = binary.name().toLowerCase(Locale.ENGLISH);
                switch (CrossSystem.getARCHFamily()) {
                    case X86: {
                        File x64Path;
                        if (CrossSystem.is64BitOperatingSystem() && (x64Path = Application.getResource((String)("tools/Windows/ffmpeg/x64/" + binaryName + ".exe"))).isFile()) {
                            return x64Path;
                        }
                        return Application.getResource((String)("tools/Windows/ffmpeg/i386/" + binaryName + ".exe"));
                    }
                }
                return null;
            }
        }
        ,
        WINDOWS_XP(null){

            @Override
            protected boolean isSupported() {
                return CrossSystem.getOS().equals((Object)CrossSystem.OperatingSystem.WINDOWS_XP);
            }

            @Override
            protected File getBundledBinaryPath(BINARY binary) {
                return WINDOWS.getBundledBinaryPath(binary);
            }
        }
        ,
        GENERIC(null){

            @Override
            protected boolean isSupported() {
                return CrossSystem.isLinux() || CrossSystem.isBSD();
            }

            @Override
            protected File getBundledBinaryPath(BINARY binary) {
                String binaryName = binary.name().toLowerCase(Locale.ENGLISH);
                if (CrossSystem.isLinux() || CrossSystem.isBSD()) {
                    String os = CrossSystem.isLinux() ? "linux" : "bsd";
                    switch (CrossSystem.getARCHFamily()) {
                        case X86: {
                            if (CrossSystem.is64BitOperatingSystem()) {
                                return Application.getResource((String)("tools/" + os + "/ffmpeg/x64/" + binaryName));
                            }
                            return Application.getResource((String)("tools/" + os + "/ffmpeg/i386/" + binaryName));
                        }
                        case ARM: {
                            if (CrossSystem.is64BitOperatingSystem()) {
                                return Application.getResource((String)("tools/" + os + "/ffmpeg/arm64/" + binaryName));
                            }
                            return Application.getResource((String)("tools/" + os + "/ffmpeg/arm/" + binaryName));
                        }
                        case PPC: {
                            if (CrossSystem.is64BitOperatingSystem()) {
                                return Application.getResource((String)("tools/" + os + "/ffmpeg/ppc64/" + binaryName));
                            }
                            return Application.getResource((String)("tools/" + os + "/ffmpeg/ppc/" + binaryName));
                        }
                        case RISCV: {
                            if (CrossSystem.is64BitOperatingSystem()) {
                                return Application.getResource((String)("tools/" + os + "/ffmpeg/riscv64/" + binaryName));
                            }
                            return Application.getResource((String)("tools/" + os + "/ffmpeg/riscv32/" + binaryName));
                        }
                    }
                    return null;
                }
                return null;
            }
        };

        protected final String extensionID;

        protected abstract boolean isSupported();

        protected abstract File getBundledBinaryPath(BINARY var1);

        public static ExtensionPackages getExtension() {
            for (ExtensionPackages extension : ExtensionPackages.values()) {
                if (!extension.isSupported()) continue;
                return extension;
            }
            return null;
        }

        private ExtensionPackages(String extensionID) {
            this.extensionID = extensionID;
        }
    }
}

