/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.ffmpeg;

import jd.controlling.downloadcontroller.DownloadWatchDog;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.controlling.ffmpeg.FFMpegInstallProgress;
import org.jdownloader.controlling.ffmpeg.FFMpegInstallThread;
import org.jdownloader.controlling.ffmpeg.FFmpeg;
import org.jdownloader.logging.LogController;

public class FFmpegProvider {
    public static final String FFMPEG_INSTALL_CHECK = "FFMPEG_INSTALL_CHECK";
    private static final FFmpegProvider INSTANCE = new FFmpegProvider();
    protected volatile FFMpegInstallThread installThread;
    private final LogSource logger = LogController.getInstance().getLogger(FFmpeg.class.getName());
    private static final Object LOCK = new Object();

    public static FFmpegProvider getInstance() {
        return INSTANCE;
    }

    private FFmpegProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(FFMpegInstallProgress progress, String task) throws InterruptedException {
        Object object = LOCK;
        synchronized (object) {
            if (DownloadWatchDog.getInstance().getSession().getBooleanProperty(FFMPEG_INSTALL_CHECK, false).booleanValue()) {
                return;
            }
            DownloadWatchDog.getInstance().getSession().setProperty(FFMPEG_INSTALL_CHECK, true);
            FFMpegInstallThread thread = this.installThread;
            if (thread == null || !thread.isAlive()) {
                this.installThread = thread = new FFMpegInstallThread(this, task);
                thread.start();
                this.logger.info("Started Install process");
            }
            while ((thread = this.installThread) != null && thread.isAlive()) {
                if (progress != null) {
                    progress.updateValues(thread.getProgress(), 100L);
                }
                Thread.sleep(1000L);
            }
            this.logger.info("Ended Install process");
        }
    }
}

