/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.ffmpeg;

import java.io.File;
import java.util.ArrayList;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpserver.HttpServer;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.ffmpeg.AbstractFFmpegBinary;
import org.jdownloader.controlling.ffmpeg.json.StreamInfo;

public abstract class FFprobe
extends AbstractFFmpegBinary {
    public FFprobe(Browser br) {
        super(br);
        String path = this.config.getBinaryPathProbe();
        this.setPath(path);
    }

    public FFprobe() {
        this(null);
    }

    @Override
    public boolean isCompatible() {
        String sha256;
        if (CrossSystem.isWindows() && !CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_7) && (StringUtils.equalsIgnoreCase((String)"d88cc4d2cf122c98e26a3cce9bb0457e97e6445da02b2874b8a407c5fe95c4b8", (String)(sha256 = Hash.getFileHash((File)new File(this.getFullPath()), (String)"SHA-256"))) || StringUtils.equalsIgnoreCase((String)"d740da4d80d7add22c3538918ab35f62725df920fa9631035678330ec6b9b31a", (String)sha256))) {
            this.getLogger().severe("ffprobe binary(" + this.getFullPath() + ") requires minimum Windows 7!");
            return false;
        }
        return super.isCompatible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamInfo getStreamInfo(String url) {
        try {
            StreamInfo data;
            if (!this.isAvailable() || !this.isCompatible()) {
                StreamInfo streamInfo = null;
                return streamInfo;
            }
            if (StringUtils.endsWithCaseInsensitive((String)url, (String)".m3u8")) {
                this.initPipe(url);
            } else {
                this.initPipe(null);
            }
            this.processID = new UniqueAlltimeID().getID();
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add(this.getFullPath());
            commandLine.add("-loglevel");
            commandLine.add("48");
            commandLine.add("-show_format");
            commandLine.add("-show_streams");
            commandLine.add("-analyzeduration");
            commandLine.add("15000000");
            commandLine.add("-of");
            commandLine.add("json");
            commandLine.add("-i");
            HttpServer server = this.server;
            if (server != null && server.isRunning()) {
                if (StringUtils.endsWithCaseInsensitive((String)url, (String)".m3u8")) {
                    commandLine.add("http://" + server.getServerAddress() + "/m3u8.m3u8?id=" + this.processID);
                } else {
                    commandLine.add("http://" + server.getServerAddress() + "/download.ts?id=" + this.processID + "&url=" + Encoding.urlEncode((String)url));
                }
            } else {
                commandLine.add(url);
            }
            String ret = this.runCommand(null, commandLine);
            StreamInfo streamInfo = data = (StreamInfo)JSonStorage.restoreFromString((String)ret, (TypeRef)new TypeRef<StreamInfo>(){});
            return streamInfo;
        }
        catch (Throwable e) {
            this.getLogger().log(e);
            StreamInfo streamInfo = null;
            return streamInfo;
        }
        finally {
            this.closePipe();
        }
    }

    public StreamInfo getStreamInfo(File dummy) {
        if (dummy != null) {
            return this.getStreamInfo(dummy.toString());
        }
        return null;
    }
}

