/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import jd.plugins.LinkInfo;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.controlling.filter.FiletypeFilter;
import org.jdownloader.controlling.filter.LinkgrabberFilterRuleWrapper;
import org.jdownloader.controlling.filter.RuleWrapper;
import org.jdownloader.gui.translate._GUI;

public class CompiledFiletypeFilter {
    private final Pattern[] list;
    private final ExtensionsFilterInterface[] filterInterfaces;
    private final FiletypeFilter.TypeMatchType matchType;
    private static List<CompiledFiletypeExtension> EXTENSIONSFILTERINTERFACES = CompiledFiletypeFilter.init();

    public FiletypeFilter.TypeMatchType getMatchType() {
        return this.matchType;
    }

    private static List<CompiledFiletypeExtension> init() {
        ArrayList<CompiledFiletypeExtension> ret = new ArrayList<CompiledFiletypeExtension>();
        ret.addAll(Arrays.asList(VideoExtensions.values()));
        ret.addAll(Arrays.asList(AudioExtensions.values()));
        ret.addAll(Arrays.asList(ExecutableExtensions.values()));
        ret.addAll(Arrays.asList(HashExtensions.values()));
        ret.addAll(Arrays.asList(DocumentExtensions.values()));
        ret.addAll(Arrays.asList(ImageExtensions.values()));
        ret.addAll(Arrays.asList(SubtitleExtensions.values()));
        ret.addAll(Arrays.asList(ArchiveExtensions.values()));
        return ret;
    }

    public static CompiledFiletypeExtension getExtensionsFilterInterface(String fileExtension) {
        if (fileExtension == null) {
            return null;
        }
        if (fileExtension.startsWith(".")) {
            fileExtension = fileExtension.substring(1);
        }
        for (CompiledFiletypeExtension extension : EXTENSIONSFILTERINTERFACES) {
            Pattern pattern = extension.getPattern();
            if (pattern == null || !pattern.matcher(fileExtension).matches()) continue;
            return extension;
        }
        return null;
    }

    public static List<CompiledFiletypeExtension> getByMimeType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        ArrayList<CompiledFiletypeExtension> ret = new ArrayList<CompiledFiletypeExtension>();
        for (CompiledFiletypeExtension extension : EXTENSIONSFILTERINTERFACES) {
            if (!extension.matchesMimeType(mimeType)) continue;
            ret.add(extension);
        }
        return ret;
    }

    private static String getExtensionFromMimeType(String mimeType, CompiledFiletypeExtension fileTypeExtension) {
        return fileTypeExtension.matchesMimeType(mimeType) ? fileTypeExtension.name().toLowerCase(Locale.ENGLISH) : null;
    }

    private static Boolean isValidExtension(String extension, CompiledFiletypeExtension fileTypeExtension) {
        if (extension != null) {
            return fileTypeExtension.getPattern().matcher(extension).matches();
        }
        return null;
    }

    private static Pattern compileAllPattern(ExtensionsFilterInterface[] filters) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean or = false;
        for (ExtensionsFilterInterface value : filters) {
            Pattern pattern;
            if (or) {
                sb.append("|");
            }
            if ((pattern = value.getPattern()) != null) {
                sb.append(pattern);
            }
            or = true;
        }
        sb.append(")");
        return Pattern.compile(sb.toString(), 34);
    }

    public CompiledFiletypeFilter(FiletypeFilter filetypeFilter) {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        ArrayList<Enum> filterInterfaces = new ArrayList<Enum>();
        if (filetypeFilter.isArchivesEnabled()) {
            filterInterfaces.add(ArchiveExtensions.ACE);
        }
        if (filetypeFilter.isHashEnabled()) {
            filterInterfaces.add(HashExtensions.MD5);
        }
        if (filetypeFilter.isAudioFilesEnabled()) {
            filterInterfaces.add(AudioExtensions.AAC);
        }
        if (filetypeFilter.isImagesEnabled()) {
            filterInterfaces.add(ImageExtensions.BMP);
        }
        if (filetypeFilter.isVideoFilesEnabled()) {
            filterInterfaces.add(VideoExtensions.ASF);
        }
        if (filetypeFilter.isDocFilesEnabled()) {
            filterInterfaces.add(DocumentExtensions.TXT);
        }
        if (filetypeFilter.isSubFilesEnabled()) {
            filterInterfaces.add(SubtitleExtensions.SRT);
        }
        if (filetypeFilter.isExeFilesEnabled()) {
            filterInterfaces.add(ExecutableExtensions.EXE);
        }
        this.matchType = filetypeFilter.getMatchType();
        try {
            if (filetypeFilter.getCustoms() != null) {
                if (filetypeFilter.isUseRegex()) {
                    list.add(Pattern.compile(filetypeFilter.getCustoms(), 34));
                } else {
                    for (String s : filetypeFilter.getCustoms().split("\\,")) {
                        list.add(LinkgrabberFilterRuleWrapper.createPattern(s, false, RuleWrapper.AUTO_PATTERN_MODE.MATCHES));
                    }
                }
            }
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        this.list = list.toArray(new Pattern[list.size()]);
        this.filterInterfaces = filterInterfaces.toArray(new ExtensionsFilterInterface[filterInterfaces.size()]);
    }

    public boolean matches(String extension, LinkInfo linkInfo) {
        boolean matches = false;
        String ext = StringUtils.isNotEmpty((String)extension) ? extension : linkInfo.getExtension().name();
        block8: for (ExtensionsFilterInterface filterInterfaces : this.filterInterfaces) {
            if (matches) break;
            if (linkInfo.getExtension().isSameExtensionGroup(filterInterfaces)) {
                matches = true;
                break;
            }
            for (ExtensionsFilterInterface filterInterface : filterInterfaces.listSameGroup()) {
                Pattern pattern = filterInterface.getPattern();
                try {
                    if (pattern == null || !pattern.matcher(ext).matches()) continue;
                    matches = true;
                    continue block8;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        if (!matches) {
            for (Pattern pattern : this.list) {
                try {
                    if (pattern == null || !pattern.matcher(ext).matches()) continue;
                    matches = true;
                    break;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        switch (this.matchType) {
            case IS: {
                return matches;
            }
            case IS_NOT: {
                return !matches;
            }
        }
        return false;
    }

    public Pattern[] getList() {
        ArrayList<Pattern> ret = new ArrayList<Pattern>();
        ret.addAll(Arrays.asList(this.list));
        for (ExtensionsFilterInterface filterInterfaces : this.filterInterfaces) {
            for (ExtensionsFilterInterface filterInterface : filterInterfaces.listSameGroup()) {
                Pattern pattern = filterInterface.getPattern();
                if (pattern == null) continue;
                ret.add(pattern);
            }
        }
        return ret.toArray(new Pattern[ret.size()]);
    }

    public static enum ImageExtensions implements CompiledFiletypeExtension
    {
        JPG("(jpe|jpe?g|jfif)"){
            private final Pattern pattern = Pattern.compile("(?i)image/jpe?g");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        JP2("(jp2|j2k|jpf|jpg2|jpx|jpm|mj2|mjp2)"),
        AVIF,
        GIF{
            private final Pattern pattern = Pattern.compile("(?i)image/gif");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        DNG,
        GPR,
        EPS,
        PNG{
            private final Pattern pattern = Pattern.compile("(?i)image/png");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        BMP{
            private final Pattern pattern = Pattern.compile("(?i)image/(bmp|x-bmp)");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        TIFF("tiff?"){
            private final Pattern pattern = Pattern.compile("(?i)image/tiff");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        RAW,
        SVG{
            private final Pattern pattern = Pattern.compile("(?i)image/svg\\+xml");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        ICO,
        CUR,
        WEBP{
            private final Pattern pattern = Pattern.compile("(?i)image/webp");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        MVIEW;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        private ImageExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private ImageExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_images();
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(ImageExtensions.values());
            }
            return allPattern;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return ImageExtensions.values();
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof ImageExtensions;
        }

        @Override
        public String getIconID() {
            return "image";
        }

        @Override
        public boolean matchesMimeType(String mimeType) {
            return false;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }
    }

    public static enum ArchiveExtensions implements CompiledFiletypeExtension
    {
        REV,
        RAR,
        ZIP{
            private final Pattern pattern = Pattern.compile("(?i)application/zip");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        R_NUM("[r-z]\\d{2}"),
        NUM("\\d{1,4}"),
        MultiZip("z\\d{1,4}"),
        ACE("(ace|c\\d{2,4})"){

            @Override
            public String getExtensionFromMimeType(String mimeType) {
                return this.matchesMimeType(mimeType) ? "ace" : null;
            }
        }
        ,
        TAR,
        GZ{
            private final Pattern pattern = Pattern.compile("(?i)application/gzip");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        AR,
        BZ2,
        ARJ,
        CPIO,
        SevenZ("(7z|7zip)"){
            private final Pattern pattern = Pattern.compile("(?i)application/x-7z-compressed");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }

            @Override
            public String getExtensionFromMimeType(String mimeType) {
                return this.matchesMimeType(mimeType) ? "7z" : null;
            }
        }
        ,
        S7Z,
        DMG,
        SFX,
        XZ{
            private final Pattern pattern = Pattern.compile("(?i)application/x-xz");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        TXZ,
        TGZ,
        LZH,
        LHA,
        AA("[a-z]{2}");

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private ArchiveExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private ArchiveExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_archives();
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(ArchiveExtensions.values());
            }
            return allPattern;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return ArchiveExtensions.values();
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof ArchiveExtensions;
        }

        @Override
        public String getIconID() {
            return "extract";
        }

        @Override
        public boolean matchesMimeType(String mimeType) {
            return false;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }
    }

    public static enum VideoExtensions implements CompiledFiletypeExtension
    {
        ThreeGP("3GP"){

            @Override
            public String getExtensionFromMimeType(String mimeType) {
                return this.matchesMimeType(mimeType) ? "3gp" : null;
            }
        }
        ,
        ASF,
        AVI,
        DIVX,
        XVID,
        FLV,
        MP4{
            private final Pattern pattern = Pattern.compile("(?i)video/mp4");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        H264,
        H265,
        M2TS("m2ts|m2t|mts"),
        MP2T("tsv|tsa|ts"),
        M4U,
        M4V,
        MOV,
        MKV,
        MPEG,
        MPEG4,
        MPG,
        OGM,
        OGV,
        VOB,
        WMV,
        GP3,
        WEBM{
            private final Pattern pattern = Pattern.compile("(?i)video/webm");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        APNG{
            private final Pattern pattern = Pattern.compile("(?i)image/apng");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        };

        private final Pattern pattern;
        private static Pattern allPattern;

        private VideoExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof VideoExtensions;
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        private VideoExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_video();
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(VideoExtensions.values());
            }
            return allPattern;
        }

        @Override
        public String getIconID() {
            return "video";
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return VideoExtensions.values();
        }

        @Override
        public boolean matchesMimeType(String mimeType) {
            return false;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }
    }

    public static enum AudioExtensions implements CompiledFiletypeExtension
    {
        AC3,
        MP3{
            private final Pattern pattern = Pattern.compile("(?i)audio/(mpeg|mp3)");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        MO3,
        WMA,
        AAC,
        WAV{
            private final Pattern pattern = Pattern.compile("(?i)audio/wav");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        FLAC{
            private final Pattern pattern = Pattern.compile("(?i)audio/x-flac");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        MID,
        MOD,
        OGG{
            private final Pattern pattern = Pattern.compile("(?i)audio/ogg");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }

            @Override
            public boolean isValidExtension(String extension) {
                return super.isValidExtension(extension) || CompiledFiletypeFilter.isValidExtension(extension, 4.OGA) != false;
            }
        }
        ,
        OGA{
            private final Pattern pattern = Pattern.compile("(?i)audio/ogg");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }

            @Override
            public boolean isValidExtension(String extension) {
                return super.isValidExtension(extension) || CompiledFiletypeFilter.isValidExtension(extension, 5.OGG) != false;
            }
        }
        ,
        OPUS{
            private final Pattern pattern = Pattern.compile("(?i)audio/opus");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        S3M,
        FourMP("4MP"){

            @Override
            public String getExtensionFromMimeType(String mimeType) {
                return this.matchesMimeType(mimeType) ? "4mp" : null;
            }
        }
        ,
        AIF,
        AIFF,
        AU,
        M3U,
        M4a{
            private final Pattern pattern = Pattern.compile("(?i)audio/(mp4|x-m4a)");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        M4b,
        M4P,
        MKA,
        MP1,
        MP2,
        MPA,
        MIDI("midi?"),
        OMG,
        OMF,
        SND,
        SPX,
        NSF;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private AudioExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private AudioExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_audio();
        }

        @Override
        public String getIconID() {
            return "audio";
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(AudioExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof AudioExtensions;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return AudioExtensions.values();
        }

        @Override
        public boolean matchesMimeType(String mimeType) {
            return false;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }
    }

    public static enum DocumentExtensions implements CompiledFiletypeExtension
    {
        CSS{
            private final Pattern pattern = Pattern.compile("(?i)text/css");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        TXT{
            private final Pattern pattern = Pattern.compile("(?i)text/plain");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        LOG,
        HTML("(html?)"){
            private final Pattern pattern = Pattern.compile("(?i)text/html");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        PHP,
        JSP,
        JAVA,
        JS{
            private final Pattern pattern = Pattern.compile("(?i)text/javascript");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        JSON{
            private final Pattern pattern = Pattern.compile("(?i)application/json");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        DOC("(doc(m)?|dot(x|m)?)"),
        DOCX{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.openxmlformats-officedocument.wordprocessingml.document");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        DOCM{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-word.document.macroEnabled.12");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }

            @Override
            public boolean isValidExtension(String extension) {
                return super.isValidExtension(extension) || CompiledFiletypeFilter.isValidExtension(extension, 7.DOC) != false;
            }
        }
        ,
        DOTX{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.openxmlformats-officedocument.wordprocessingml.template");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }

            @Override
            public boolean isValidExtension(String extension) {
                return super.isValidExtension(extension) || CompiledFiletypeFilter.isValidExtension(extension, 8.DOC) != false;
            }
        }
        ,
        DOCT{
            private final Pattern pattern = Pattern.compile("(?i)application/vnd.ms-word.template.macroEnabled.12");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        EPUB,
        PDB,
        README,
        MOBI("mobi|prc"),
        XML{
            private final Pattern pattern = Pattern.compile("(?i)(text/xml|application/xml)");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        CHM,
        CSV,
        RTF,
        PDF{
            private final Pattern pattern = Pattern.compile("(?i)application/pdf");

            @Override
            public boolean matchesMimeType(String mimeType) {
                return this.pattern.matcher(mimeType).find();
            }
        }
        ,
        NFO,
        USF;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private DocumentExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private DocumentExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_document();
        }

        @Override
        public String getIconID() {
            return "text";
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(DocumentExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof DocumentExtensions;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return DocumentExtensions.values();
        }

        @Override
        public boolean matchesMimeType(String mimeType) {
            return false;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }
    }

    public static enum SubtitleExtensions implements CompiledFiletypeExtension
    {
        SRT,
        SSF,
        SSA,
        ASS,
        IDX,
        TTXT,
        TTML,
        SMI,
        VTT,
        SUB;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private SubtitleExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private SubtitleExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_subtitle();
        }

        @Override
        public String getIconID() {
            return "language";
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(SubtitleExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof SubtitleExtensions;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return SubtitleExtensions.values();
        }

        @Override
        public boolean matchesMimeType(String mimeType) {
            return false;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }
    }

    public static enum ExecutableExtensions implements CompiledFiletypeExtension
    {
        BAT,
        EXE,
        MSI,
        JAR,
        VBS,
        APK,
        APP,
        BIN,
        RUN,
        PS1,
        CMD;

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private ExecutableExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private ExecutableExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_executable();
        }

        @Override
        public String getIconID() {
            return "desktop";
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(ExecutableExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof ExecutableExtensions;
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return ExecutableExtensions.values();
        }

        @Override
        public boolean matchesMimeType(String mimeType) {
            return false;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }
    }

    public static enum HashExtensions implements CompiledFiletypeExtension
    {
        SFV,
        MD5,
        SHA,
        SHA256,
        SHA512,
        PAR2("(vol\\d+\\.par2|vol\\d+\\+\\d+\\.par2|par2)"),
        PAR("(p\\d+|par)");

        private final Pattern pattern;
        private static Pattern allPattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public ExtensionsFilterInterface getSource() {
            return this;
        }

        private HashExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private HashExtensions(String id) {
            this.pattern = Pattern.compile(id, 34);
        }

        @Override
        public String getDesc() {
            return _GUI.T.FilterRuleDialog_createTypeFilter_mime_checksums();
        }

        @Override
        public String getIconID() {
            return "hashsum";
        }

        @Override
        public boolean isValidExtension(String extension) {
            return CompiledFiletypeFilter.isValidExtension(extension, this);
        }

        @Override
        public Pattern compiledAllPattern() {
            if (allPattern == null) {
                allPattern = CompiledFiletypeFilter.compileAllPattern(HashExtensions.values());
            }
            return allPattern;
        }

        @Override
        public boolean isSameExtensionGroup(ExtensionsFilterInterface extension) {
            return extension != null && extension instanceof HashExtensions;
        }

        @Override
        public ExtensionsFilterInterface[] listSameGroup() {
            return HashExtensions.values();
        }

        @Override
        public boolean matchesMimeType(String mimeType) {
            return false;
        }

        @Override
        public String getExtensionFromMimeType(String mimeType) {
            return CompiledFiletypeFilter.getExtensionFromMimeType(mimeType, this);
        }
    }

    public static interface ExtensionsFilterInterface {
        public Pattern compiledAllPattern();

        public String getDesc();

        public String getIconID();

        public Pattern getPattern();

        public String name();

        public boolean isSameExtensionGroup(ExtensionsFilterInterface var1);

        public ExtensionsFilterInterface[] listSameGroup();

        public ExtensionsFilterInterface getSource();
    }

    public static interface CompiledFiletypeExtension
    extends ExtensionsFilterInterface {
        public boolean matchesMimeType(String var1);

        public String getExtensionFromMimeType(String var1);

        public boolean isValidExtension(String var1);

        @Override
        public String name();
    }
}

