/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import jd.controlling.AccountController;
import jd.controlling.AccountFilter;
import jd.controlling.linkcrawler.CrawledLink;
import jd.gui.swing.jdgui.views.settings.panels.linkgrabberfilter.editdialog.PluginStatusFilter;
import jd.plugins.Account;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;

public class CompiledPluginStatusFilter
extends PluginStatusFilter
implements Storable {
    @StorableAllowPrivateAccessModifier
    private CompiledPluginStatusFilter() {
    }

    public CompiledPluginStatusFilter(PluginStatusFilter pluginStatusFilter) {
        super(pluginStatusFilter.getMatchType(), pluginStatusFilter.isEnabled(), pluginStatusFilter.getPluginStatus());
    }

    public boolean matches(CrawledLink link) {
        switch (this.getMatchType()) {
            case IS: {
                switch (this.getPluginStatus()) {
                    case PREMIUM: {
                        return this.VerifyPremium(link);
                    }
                    case ACCOUNT: {
                        return this.VerifyAccount(link);
                    }
                    case AUTOCAPTCHA: {
                        return link.hasAutoCaptcha() || !link.hasCaptcha(null);
                    }
                    case NO_DIRECT_HTTP: {
                        return !link.isDirectHTTP() && !link.isFTP();
                    }
                }
                break;
            }
            case ISNOT: {
                switch (this.getPluginStatus()) {
                    case PREMIUM: {
                        return !this.VerifyPremium(link);
                    }
                    case ACCOUNT: {
                        return !this.VerifyAccount(link);
                    }
                    case AUTOCAPTCHA: {
                        return !link.hasAutoCaptcha() && link.hasCaptcha(null);
                    }
                    case NO_DIRECT_HTTP: {
                        return link.isDirectHTTP() || link.isFTP();
                    }
                }
            }
        }
        return false;
    }

    private boolean VerifyAccount(CrawledLink link) {
        if (link.isDirectHTTP() || link.isFTP()) {
            return true;
        }
        if (AccountController.getInstance().listAccounts(new AccountFilter().setEnabled(true).setValid(true).setTemporarilyDisabled(false).setMaxResultsNum(1).setHosts(link.getHost())).size() > 0) {
            return true;
        }
        return AccountController.getInstance().listAccounts(new AccountFilter().setEnabled(true).setValid(true).setTemporarilyDisabled(false).setMaxResultsNum(1).setMultiHostSupported(link.getHost())).size() > 0;
    }

    private boolean VerifyPremium(CrawledLink link) {
        if (link.isDirectHTTP() || link.isFTP()) {
            return true;
        }
        if (AccountController.getInstance().listAccounts(new AccountFilter().setEnabled(true).setAccountTypes(Account.AccountType.PREMIUM, Account.AccountType.LIFETIME).setValid(true).setExpired(false).setTemporarilyDisabled(false).setMaxResultsNum(1).setHosts(link.getHost())).size() > 0) {
            return true;
        }
        return AccountController.getInstance().listAccounts(new AccountFilter().setEnabled(true).setAccountTypes(Account.AccountType.PREMIUM, Account.AccountType.LIFETIME).setValid(true).setExpired(false).setTemporarilyDisabled(false).setMaxResultsNum(1).setMultiHostSupported(link.getHost())).size() > 0;
    }
}

