/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.regex.Pattern;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.jdownloader.controlling.filter.RegexFilter;

public class CompiledRegexFilter
extends RegexFilter
implements Storable {
    private final Pattern pattern;

    @StorableAllowPrivateAccessModifier
    private CompiledRegexFilter() {
        this.pattern = null;
    }

    public CompiledRegexFilter(RegexFilter filter) {
        super(filter.enabled, filter.getMatchType(), filter.getRegex(), filter.isUseRegex());
        this.pattern = this.buildPattern();
    }

    public Pattern _getPattern() {
        return this.pattern;
    }

    public boolean matches(String string) {
        boolean ret;
        switch (this.getMatchType()) {
            case CONTAINS: {
                ret = this.pattern.matcher(string).find();
                break;
            }
            case EQUALS: {
                ret = this.pattern.matcher(string).matches();
                break;
            }
            case CONTAINS_NOT: {
                ret = !this.pattern.matcher(string).find();
                break;
            }
            case EQUALS_NOT: {
                ret = !this.pattern.matcher(string).matches();
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }
}

