/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.io.File;
import java.net.URL;
import java.util.regex.Pattern;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkOriginDetails;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.plugins.DownloadLink;
import jd.plugins.LinkInfo;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.filter.BooleanFilter;
import org.jdownloader.controlling.filter.CompiledConditionFilter;
import org.jdownloader.controlling.filter.CompiledFilesizeFilter;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.controlling.filter.CompiledOnlineStatusFiler;
import org.jdownloader.controlling.filter.CompiledOriginFilter;
import org.jdownloader.controlling.filter.CompiledPluginStatusFilter;
import org.jdownloader.controlling.filter.CompiledRegexFilter;
import org.jdownloader.controlling.filter.FilterRule;
import org.jdownloader.controlling.filter.RegexFilter;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;

public class RuleWrapper<T extends FilterRule> {
    private final CompiledRegexFilter fileNameRule;
    private final CompiledPluginStatusFilter pluginStatusFilter;
    private final BooleanFilter alwaysFilter;
    private final CompiledOriginFilter originFilter;
    private final CompiledRegexFilter packageNameRule;
    private final CompiledConditionFilter conditionFilter;
    private final boolean requiresHoster;
    private final CompiledRegexFilter hosterRule;
    private final CompiledRegexFilter sourceRule;
    private final CompiledFilesizeFilter filesizeRule;
    private final CompiledFiletypeFilter filetypeFilter;
    private final T rule;
    private final CompiledOnlineStatusFiler onlineStatusFilter;

    public CompiledPluginStatusFilter getPluginStatusFilter() {
        return this.pluginStatusFilter;
    }

    public RuleWrapper(T rule2) {
        this.rule = rule2;
        boolean requiresHoster = false;
        if (((FilterRule)this.rule).getPluginStatusFilter().isEnabled()) {
            this.pluginStatusFilter = new CompiledPluginStatusFilter(((FilterRule)this.rule).getPluginStatusFilter());
            requiresHoster = true;
        } else {
            this.pluginStatusFilter = null;
        }
        this.onlineStatusFilter = ((FilterRule)this.rule).getOnlineStatusFilter().isEnabled() ? new CompiledOnlineStatusFiler(((FilterRule)this.rule).getOnlineStatusFilter()) : null;
        this.fileNameRule = ((FilterRule)this.rule).getFilenameFilter().isEnabled() ? new CompiledRegexFilter(((FilterRule)this.rule).getFilenameFilter()) : null;
        this.packageNameRule = ((FilterRule)this.rule).getPackagenameFilter().isEnabled() ? new CompiledRegexFilter(((FilterRule)this.rule).getPackagenameFilter()) : null;
        this.filesizeRule = ((FilterRule)this.rule).getFilesizeFilter().isEnabled() ? new CompiledFilesizeFilter(((FilterRule)this.rule).getFilesizeFilter()) : null;
        this.filetypeFilter = ((FilterRule)this.rule).getFiletypeFilter().isEnabled() ? new CompiledFiletypeFilter(((FilterRule)this.rule).getFiletypeFilter()) : null;
        if (((FilterRule)this.rule).getHosterURLFilter().isEnabled()) {
            this.hosterRule = new CompiledRegexFilter(((FilterRule)this.rule).getHosterURLFilter());
            requiresHoster = true;
        } else {
            this.hosterRule = null;
        }
        this.sourceRule = ((FilterRule)this.rule).getSourceURLFilter().isEnabled() ? new CompiledRegexFilter(((FilterRule)this.rule).getSourceURLFilter()) : null;
        this.originFilter = ((FilterRule)this.rule).getOriginFilter().isEnabled() ? new CompiledOriginFilter(((FilterRule)this.rule).getOriginFilter()) : null;
        this.conditionFilter = ((FilterRule)this.rule).getConditionFilter().isEnabled() ? new CompiledConditionFilter(((FilterRule)this.rule).getConditionFilter()) : null;
        if (((FilterRule)this.rule).getMatchAlwaysFilter().isEnabled()) {
            this.alwaysFilter = ((FilterRule)this.rule).getMatchAlwaysFilter();
            requiresHoster = false;
        } else {
            this.alwaysFilter = null;
        }
        this.requiresHoster = requiresHoster;
    }

    public CompiledConditionFilter getConditionFilter() {
        return this.conditionFilter;
    }

    public CompiledOriginFilter getOriginFilter() {
        return this.originFilter;
    }

    public BooleanFilter getAlwaysFilter() {
        return this.alwaysFilter;
    }

    public CompiledRegexFilter getFileNameRule() {
        return this.fileNameRule;
    }

    public CompiledRegexFilter getPackageNameRule() {
        return this.packageNameRule;
    }

    public boolean isRequiresHoster() {
        return this.requiresHoster;
    }

    public CompiledRegexFilter getHosterRule() {
        return this.hosterRule;
    }

    public CompiledRegexFilter getSourceRule() {
        return this.sourceRule;
    }

    public CompiledFilesizeFilter getFilesizeRule() {
        return this.filesizeRule;
    }

    public CompiledFiletypeFilter getFiletypeFilter() {
        return this.filetypeFilter;
    }

    public T getRule() {
        return this.rule;
    }

    public CompiledOnlineStatusFiler getOnlineStatusFilter() {
        return this.onlineStatusFilter;
    }

    public static Pattern createPattern(String regex, boolean useRegex, AUTO_PATTERN_MODE mode) {
        if (useRegex) {
            int flags = 0;
            if (regex != null && !regex.contains("(?i)") && !regex.contains("(?-i)")) {
                flags |= 2;
            }
            if (regex != null && !regex.contains("(?s)") && !regex.contains("(?-s)")) {
                flags |= 0x20;
            }
            return Pattern.compile(regex, flags);
        }
        String[] parts = regex.split("\\*+");
        StringBuilder sb = new StringBuilder();
        boolean containsWildcard = false;
        boolean containsQuestionMark = false;
        if (regex.startsWith("*")) {
            containsWildcard = true;
            sb.append("(.*)");
        }
        int nonEmptyParts = 0;
        StringBuilder partSb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].length() == 0) continue;
            if (nonEmptyParts > 0) {
                containsWildcard = true;
                sb.append("(.*?)");
            }
            String part = parts[i];
            for (int index = 0; index < part.length(); ++index) {
                char c = part.charAt(index);
                if (c == '?') {
                    if (partSb.length() > 0) {
                        sb.append(Pattern.quote(partSb.toString()));
                        partSb.setLength(0);
                    }
                    containsQuestionMark = true;
                    sb.append(".");
                    continue;
                }
                partSb.append(c);
            }
            if (partSb.length() > 0) {
                sb.append(Pattern.quote(partSb.toString()));
                partSb.setLength(0);
            }
            ++nonEmptyParts;
        }
        if (sb.length() == 0) {
            sb.append("(.*)");
        } else if (nonEmptyParts > 0) {
            if (regex.endsWith("?")) {
                // empty if block
            }
            if (regex.endsWith("*")) {
                containsWildcard = true;
                sb.append("(.*)");
            }
            if (AUTO_PATTERN_MODE.MATCHES.equals((Object)mode)) {
                sb.insert(0, "^");
                sb.append("$");
            } else if ((containsWildcard || containsQuestionMark) && AUTO_PATTERN_MODE.WILDCARD.equals((Object)mode)) {
                sb.insert(0, "^");
                sb.append("$");
            }
        }
        return Pattern.compile(sb.toString(), 34);
    }

    public boolean checkFileType(CrawledLink link) {
        CompiledFiletypeFilter filetypeFilter = this.getFiletypeFilter();
        if (filetypeFilter != null) {
            String url = link.getURL();
            DownloadLink downloadLink = link.getDownloadLink();
            if (downloadLink != null) {
                LinkInfo linkInfo = link.getLinkInfo();
                if (downloadLink.getFinalFileName() != null || downloadLink.getForcedFileName() != null) {
                    return filetypeFilter.matches(linkInfo.getExtension().name(), linkInfo);
                }
                if (link.getLinkState() == AvailableLinkState.ONLINE) {
                    return filetypeFilter.matches(linkInfo.getExtension().name(), linkInfo);
                }
                if (this.checkOnlineStatus(link)) {
                    return filetypeFilter.matches(linkInfo.getExtension().name(), linkInfo);
                }
                return false;
            }
            if (StringUtils.startsWithCaseInsensitive((String)url, (String)"file:")) {
                try {
                    File file = new File(new URL(url).toURI());
                    LinkInfo linkInfo = LinkInfo.getLinkInfo(file);
                    return filetypeFilter.matches(linkInfo.getExtension().name(), linkInfo);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public boolean checkFileSize(CrawledLink link) {
        CompiledFilesizeFilter fileSizeRule = this.getFilesizeRule();
        if (fileSizeRule != null) {
            String url = link.getURL();
            DownloadLink downloadLink = link.getDownloadLink();
            if (downloadLink != null) {
                if (downloadLink.getVerifiedFileSize() >= 0L) {
                    return fileSizeRule.matches(downloadLink.getVerifiedFileSize());
                }
                if (link.getLinkState() == AvailableLinkState.ONLINE) {
                    return fileSizeRule.matches(link.getSize());
                }
                if (this.checkOnlineStatus(link)) {
                    return fileSizeRule.matches(link.getSize());
                }
                return false;
            }
            if (StringUtils.startsWithCaseInsensitive((String)url, (String)"file:")) {
                try {
                    File file = new File(new URL(url).toURI());
                    return fileSizeRule.matches(file.length());
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public boolean checkPackageName(CrawledLink link) {
        CompiledRegexFilter packageNameRule = this.getPackageNameRule();
        if (packageNameRule != null) {
            String packagename = null;
            if (link != null) {
                if (link.getParentNode() != null) {
                    packagename = link.getParentNode().getName();
                }
                if (StringUtils.isEmpty(packagename) && link.getDesiredPackageInfo() != null) {
                    packagename = link.getDesiredPackageInfo().getName();
                }
            }
            if (StringUtils.isEmpty(packagename)) {
                return false;
            }
            return packageNameRule.matches(packagename);
        }
        return true;
    }

    public boolean checkFileName(CrawledLink link) {
        CompiledRegexFilter fileNameRule = this.getFileNameRule();
        if (fileNameRule != null) {
            String url = link.getURL();
            DownloadLink downloadLink = link.getDownloadLink();
            if (downloadLink != null) {
                if (downloadLink.getFinalFileName() != null || downloadLink.getForcedFileName() != null) {
                    return fileNameRule.matches(link.getName());
                }
                if (link.getLinkState() == AvailableLinkState.ONLINE) {
                    return fileNameRule.matches(link.getName());
                }
                if (this.checkOnlineStatus(link)) {
                    return fileNameRule.matches(link.getName());
                }
                return false;
            }
            if (StringUtils.startsWithCaseInsensitive((String)url, (String)"file:")) {
                try {
                    File file = new File(new URL(url).toURI());
                    return fileNameRule.matches(file.getName());
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public boolean checkHoster(CrawledLink link) {
        CompiledRegexFilter hosterRule = this.getHosterRule();
        if (hosterRule != null) {
            DownloadLink dlLink = link.getDownloadLink();
            if (dlLink == null || link.gethPlugin() == null) {
                return false;
            }
            String host = dlLink.getServiceHost(true);
            switch (hosterRule.getMatchType()) {
                case CONTAINS: 
                case EQUALS: {
                    return host != null && hosterRule.matches(host) || hosterRule.matches(dlLink.getContentUrlOrPatternMatcher());
                }
                case CONTAINS_NOT: 
                case EQUALS_NOT: {
                    return (host == null || hosterRule.matches(host)) && hosterRule.matches(dlLink.getContentUrlOrPatternMatcher());
                }
            }
            return false;
        }
        return true;
    }

    public boolean checkSource(CrawledLink link) {
        block13: {
            int j;
            boolean inverted;
            CompiledRegexFilter sourceRule = this.getSourceRule();
            if (sourceRule == null) break block13;
            String[] sources = link.getSourceUrls();
            int i = 1;
            String pattern = sourceRule._getPattern().pattern();
            boolean indexed = pattern.matches("^\\-?\\d+\\\\\\. .+");
            boolean bl = inverted = indexed && pattern.startsWith("-");
            if (sources == null || sources.length == 0) {
                sources = new String[2];
                sources[0] = LinkCrawler.cleanURL(link.getURL());
                LinkCollectingJob job = link.getSourceJob();
                if (job != null) {
                    sources[1] = LinkCrawler.cleanURL(job.getCustomSourceUrl());
                }
            }
            RegexFilter.MatchType matchType = sourceRule.getMatchType();
            Boolean matches = null;
            int n = j = inverted ? 0 : sources.length - 1;
            while (inverted ? j < sources.length : j >= 0) {
                block14: {
                    String toMatch;
                    block15: {
                        String url = sources[j];
                        if (url == null) break block14;
                        String string = indexed ? (inverted ? "-" : "") + i++ + ". " + url : (toMatch = url);
                        if (!indexed) break block15;
                        switch (sourceRule.getMatchType()) {
                            case EQUALS: 
                            case EQUALS_NOT: {
                                if (sourceRule.matches(url)) {
                                    return true;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block14;
                    }
                    boolean match = sourceRule.matches(toMatch);
                    switch (matchType) {
                        case CONTAINS: {
                            if (!match) break;
                            return true;
                        }
                        case EQUALS: {
                            return match;
                        }
                        case CONTAINS_NOT: 
                        case EQUALS_NOT: {
                            matches = matches == null ? Boolean.valueOf(match) : Boolean.valueOf(matches != false && match);
                        }
                    }
                }
                j = inverted ? j + 1 : j - 1;
            }
            if (matches != null) {
                return matches;
            }
            return false;
        }
        return true;
    }

    public boolean checkOnlineStatus(CrawledLink link) {
        CompiledOnlineStatusFiler onlineStatusFilter = this.getOnlineStatusFilter();
        if (onlineStatusFilter != null) {
            AvailableLinkState linkState = link.getLinkState();
            return onlineStatusFilter.matches(linkState);
        }
        return true;
    }

    public boolean checkConditions(CrawledLink link) {
        CompiledConditionFilter conditionFiler = this.getConditionFilter();
        if (conditionFiler != null) {
            return conditionFiler.matches(link);
        }
        return true;
    }

    public boolean checkOrigin(CrawledLink link) {
        CompiledOriginFilter originFiler = this.getOriginFilter();
        if (originFiler != null) {
            LinkOriginDetails origin = link.getOrigin();
            if (origin == null) {
                return false;
            }
            return originFiler.matches(origin.getOrigin(), link);
        }
        return true;
    }

    public boolean checkPluginStatus(CrawledLink link) {
        CompiledPluginStatusFilter pluginStatusFilter = this.getPluginStatusFilter();
        if (pluginStatusFilter != null) {
            if (link.getDownloadLink() == null || link.gethPlugin() == null) {
                return false;
            }
            return pluginStatusFilter.matches(link);
        }
        return true;
    }

    public String getName() {
        return ((FilterRule)this.rule).getName();
    }

    public boolean isEnabled() {
        return ((FilterRule)this.rule).isEnabled();
    }

    public static enum AUTO_PATTERN_MODE {
        FINDS,
        MATCHES,
        WILDCARD;

    }
}

