/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.hosterrule;

import java.util.ArrayList;
import java.util.List;
import jd.plugins.Account;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.jdownloader.controlling.hosterrule.AccountGroup;
import org.jdownloader.controlling.hosterrule.AccountGroupStorable;
import org.jdownloader.controlling.hosterrule.AccountUsageRule;

public class AccountRuleStorable
implements Storable {
    private String hoster;
    private boolean enabled;
    private ArrayList<AccountGroupStorable> accounts;

    public String getHoster() {
        return this.hoster;
    }

    public void setHoster(String hoster) {
        this.hoster = hoster;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ArrayList<AccountGroupStorable> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(ArrayList<AccountGroupStorable> accounts) {
        this.accounts = accounts;
    }

    @StorableAllowPrivateAccessModifier
    private AccountRuleStorable() {
    }

    public AccountRuleStorable(AccountUsageRule hr) {
        this.hoster = hr.getHoster();
        this.enabled = hr.isEnabled();
        this.accounts = new ArrayList();
        for (AccountGroup ag : hr.getAccounts()) {
            this.accounts.add(new AccountGroupStorable(ag));
        }
    }

    public AccountUsageRule restore(List<Account> availableAccounts) {
        AccountUsageRule ret = new AccountUsageRule(this.getHoster());
        ArrayList<AccountGroup> list = new ArrayList<AccountGroup>(this.accounts.size());
        for (AccountGroupStorable ags : this.accounts) {
            AccountGroup ag = ags.restore(this.getHoster(), availableAccounts);
            if (ag == null) continue;
            list.add(ag);
        }
        ret.set(this.isEnabled(), list);
        return ret;
    }
}

