/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.hosterrule;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.hosterrule.AccountGroup;
import org.jdownloader.controlling.hosterrule.HosterRuleController;

public class AccountUsageRule {
    private boolean enabled;
    private String hoster;
    private List<AccountGroup> accounts;
    private HosterRuleController owner;
    private DomainInfo domainInfo = null;

    public AccountUsageRule(String tld) {
        this.setHoster(tld);
        this.accounts = new CopyOnWriteArrayList<AccountGroup>();
    }

    public void setHoster(String hoster) {
        this.hoster = hoster;
        this.domainInfo = null;
    }

    public DomainInfo getDomainInfo() {
        DomainInfo ret = this.domainInfo;
        if (ret != null) {
            return ret;
        }
        this.domainInfo = ret = DomainInfo.getInstance(this.getHoster());
        return ret;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        HosterRuleController lowner = this.owner;
        if (lowner != null) {
            lowner.fireUpdate(this);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHoster() {
        return this.hoster;
    }

    public List<AccountGroup> getAccounts() {
        return this.accounts;
    }

    public void setOwner(HosterRuleController controller) {
        this.owner = controller;
    }

    public void set(boolean enabledState, List<AccountGroup> list) {
        if (list == null || list.isEmpty()) {
            list = new ArrayList<AccountGroup>(1);
            enabledState = false;
        }
        this.enabled = enabledState;
        this.accounts = new CopyOnWriteArrayList<AccountGroup>(list);
        HosterRuleController lowner = this.owner;
        if (lowner != null) {
            lowner.fireUpdate(this);
        }
    }
}

