/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.crosssystem.macos;

import java.awt.Desktop;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.List;
import jd.SecondLevelLaunch;
import jd.controlling.TaskQueue;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.gui.swing.dialog.AboutDialog;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.JDownloaderMainFrame;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.views.settings.ConfigurationView;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.JavaVersion;
import org.appwork.utils.JavaVersionInterface;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.crosssystem.macos.MacOSDockAdapter;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.SmartRlyExitRequest;

public class AWTMacOSApplicationAdapter {
    public static void main(String[] args) {
        Application.setApplication((String)".test");
        AWTMacOSApplicationAdapter.enableMacSpecial();
    }

    public static void enableMacSpecial() {
        Desktop desktop = Desktop.getDesktop();
        if (desktop != null && JVMVersion.getVersion().isMinimum((JavaVersionInterface)JavaVersion.JVM_9_0)) {
            AWTMacOSApplicationAdapter adapter = new AWTMacOSApplicationAdapter();
            adapter.setAboutHandler(desktop);
            adapter.setPreferencesHandler(desktop);
            adapter.setQuitHandler(desktop);
            adapter.setOpenFileHandler(desktop);
            adapter.setOpenURIHandler(desktop);
            adapter.addAppReopenedListener(desktop);
            MacOSDockAdapter.init();
        }
    }

    private void setQuitHandler(Desktop desktop) {
        if (desktop != null) {
            try {
                Method setQuitHandler = this.getMethod(desktop.getClass(), "setQuitHandler");
                Object quitHandler = Proxy.newProxyInstance(desktop.getClass().getClassLoader(), new Class[]{setQuitHandler.getParameterTypes()[0]}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                        System.out.println(method.getName());
                        Thread thread = new Thread("java.awt.desktop.QuitHandler"){

                            @Override
                            public void run() {
                                System.out.println(method.getName());
                                RestartController.getInstance().exitAsynch((ShutdownRequest)new SmartRlyExitRequest(){

                                    public void onShutdown() {
                                        new Thread("QuitResponse:performQuit"){

                                            @Override
                                            public void run() {
                                                try {
                                                    Object quitResponse = args[1];
                                                    Method performQuit = quitResponse.getClass().getMethod("performQuit\u200b", new Class[0]);
                                                    performQuit.invoke(quitResponse, new Object[0]);
                                                }
                                                catch (Throwable e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        }.start();
                                    }

                                    public void onShutdownVeto() {
                                        new Thread("QuitResponse:cancelQuit"){

                                            @Override
                                            public void run() {
                                                try {
                                                    Object quitResponse = args[1];
                                                    Method cancelQuit = quitResponse.getClass().getMethod("cancelQuit\u200b\u200b", new Class[0]);
                                                    cancelQuit.invoke(quitResponse, new Object[0]);
                                                }
                                                catch (Throwable e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        }.start();
                                    }
                                });
                            }
                        };
                        thread.setDaemon(true);
                        thread.start();
                        return null;
                    }
                });
                try {
                    setQuitHandler.invoke((Object)desktop, quitHandler);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (UnsupportedOperationException ignore) {
                LoggerFactory.getDefaultLogger().log((Throwable)ignore);
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    private void setOpenURIHandler(Desktop desktop) {
        if (desktop != null) {
            try {
                Method setOpenURIHandler = this.getMethod(desktop.getClass(), "setOpenURIHandler");
                Object openURIHandler = Proxy.newProxyInstance(desktop.getClass().getClassLoader(), new Class[]{setOpenURIHandler.getParameterTypes()[0]}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
                        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                            protected Void run() throws RuntimeException {
                                try {
                                    AWTMacOSApplicationAdapter.this.appReOpened();
                                    Object openURIEvent = args[0];
                                    Method getURI = openURIEvent.getClass().getMethod("getURI\u200b", new Class[0]);
                                    URI uri = (URI)getURI.invoke(openURIEvent, new Object[0]);
                                    final String links = uri.toString();
                                    SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

                                        @Override
                                        public void run() {
                                            LoggerFactory.getDefaultLogger().info("Distribute links: " + links);
                                            LinkCollector.getInstance().addCrawlerJob(new LinkCollectingJob(LinkOrigin.MAC_DOCK.getLinkOriginDetails(), links));
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    LoggerFactory.getDefaultLogger().log(e);
                                }
                                return null;
                            }
                        });
                        return null;
                    }
                });
                try {
                    setOpenURIHandler.invoke((Object)desktop, openURIHandler);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (UnsupportedOperationException ignore) {
                LoggerFactory.getDefaultLogger().log((Throwable)ignore);
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    private final Method getMethod(Class clz, String name) throws NoSuchMethodException {
        if (clz != null && name != null) {
            for (Method method : clz.getMethods()) {
                if (!name.equals(method.getName())) continue;
                return method;
            }
        }
        throw new NoSuchMethodException(name);
    }

    private void setOpenFileHandler(Desktop desktop) {
        if (desktop != null) {
            try {
                Method setOpenFileHandler = this.getMethod(desktop.getClass(), "setOpenFileHandler");
                Object openFileHandler = Proxy.newProxyInstance(desktop.getClass().getClassLoader(), new Class[]{setOpenFileHandler.getParameterTypes()[0]}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
                        TaskQueue.getQueue().enqueue((QueueAction)new QueueAction<Void, RuntimeException>(){

                            protected Void run() throws RuntimeException {
                                try {
                                    AWTMacOSApplicationAdapter.this.appReOpened();
                                    Object openFilesEvent = args[0];
                                    Method getFiles = openFilesEvent.getClass().getMethod("getFiles", new Class[0]);
                                    List files = (List)getFiles.invoke(openFilesEvent, new Object[0]);
                                    LoggerFactory.getDefaultLogger().info("Handle open files from Dock " + files.toString());
                                    StringBuilder sb = new StringBuilder();
                                    for (File file : files) {
                                        if (sb.length() > 0) {
                                            sb.append("\r\n");
                                        }
                                        sb.append(file.toURI().toString());
                                    }
                                    final String links = sb.toString();
                                    SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

                                        @Override
                                        public void run() {
                                            LoggerFactory.getDefaultLogger().info("Distribute links: " + links);
                                            LinkCollector.getInstance().addCrawlerJob(new LinkCollectingJob(LinkOrigin.MAC_DOCK.getLinkOriginDetails(), links));
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    LoggerFactory.getDefaultLogger().log(e);
                                }
                                return null;
                            }
                        });
                        return null;
                    }
                });
                try {
                    setOpenFileHandler.invoke((Object)desktop, openFileHandler);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (UnsupportedOperationException ignore) {
                LoggerFactory.getDefaultLogger().log((Throwable)ignore);
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    private void setPreferencesHandler(Desktop desktop) {
        if (desktop != null) {
            try {
                Method setPreferencesHandler = this.getMethod(desktop.getClass(), "setPreferencesHandler");
                Object preferencesHandler = Proxy.newProxyInstance(desktop.getClass().getClassLoader(), new Class[]{setPreferencesHandler.getParameterTypes()[0]}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        System.out.println(method.getName());
                        TaskQueue.getQueue().addAsynch((QueueAction)new QueueAction<Void, RuntimeException>(){

                            protected boolean allowAsync() {
                                return true;
                            }

                            protected Void run() throws RuntimeException {
                                new EDTRunner(){

                                    protected void runInEDT() {
                                        try {
                                            AWTMacOSApplicationAdapter.this.appReOpened();
                                            ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setConfigViewVisible(true);
                                            JDGui.getInstance().setContent((View)ConfigurationView.getInstance(), true);
                                        }
                                        catch (Throwable e) {
                                            LoggerFactory.getDefaultLogger().log(e);
                                        }
                                    }
                                };
                                return null;
                            }
                        });
                        return null;
                    }
                });
                try {
                    setPreferencesHandler.invoke((Object)desktop, preferencesHandler);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (UnsupportedOperationException ignore) {
                LoggerFactory.getDefaultLogger().log((Throwable)ignore);
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    private void appReOpened() {
        new EDTRunner(){

            protected void runInEDT() {
                JDGui swingGui = JDGui.getInstance();
                if (swingGui == null || swingGui.getMainFrame() == null) {
                    return;
                }
                JDownloaderMainFrame mainFrame = swingGui.getMainFrame();
                if (!mainFrame.isVisible()) {
                    WindowManager.getInstance().setVisible((Window)mainFrame, true, WindowManager.FrameState.OS_DEFAULT);
                }
            }
        };
    }

    private void addAppReopenedListener(Desktop desktop) {
        if (desktop != null) {
            try {
                Method addAppEventListener = this.getMethod(desktop.getClass(), "addAppEventListener");
                Object appEventListener = Proxy.newProxyInstance(desktop.getClass().getClassLoader(), new Class[]{Class.forName("java.awt.desktop.AppReopenedListener")}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if ("appReopened".equals(method.getName())) {
                            AWTMacOSApplicationAdapter.this.appReOpened();
                        }
                        return null;
                    }
                });
                try {
                    addAppEventListener.invoke((Object)desktop, appEventListener);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (UnsupportedOperationException ignore) {
                LoggerFactory.getDefaultLogger().log((Throwable)ignore);
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    private void setAboutHandler(Desktop desktop) {
        if (desktop != null) {
            try {
                Method setAboutHandler = this.getMethod(desktop.getClass(), "setAboutHandler");
                Object aboutHandler = Proxy.newProxyInstance(desktop.getClass().getClassLoader(), new Class[]{setAboutHandler.getParameterTypes()[0]}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        AboutDialog.showNonBlocking();
                        return null;
                    }
                });
                try {
                    setAboutHandler.invoke((Object)desktop, aboutHandler);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (UnsupportedOperationException ignore) {
                LoggerFactory.getDefaultLogger().log((Throwable)ignore);
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }
}

