/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.dlc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.http.Browser;
import jd.plugins.DownloadLink;
import org.appwork.uio.CloseReason;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;
import org.appwork.utils.swing.dialog.MessageDialogImpl;
import org.jdownloader.container.D;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class DLCFactory
extends D {
    public String encryptDLC(String xml) {
        String[] encrypt = this.encrypt(xml);
        if (encrypt == null) {
            this.logger.severe("Container Encryption failed.");
            return null;
        }
        String key = encrypt[1];
        xml = encrypt[0];
        String service = "https://service.jdownloader.org/dlcrypt/service.php";
        try {
            String dlcKey = this.callService("https://service.jdownloader.org/dlcrypt/service.php", key);
            if (dlcKey == null) {
                return null;
            }
            return xml + dlcKey;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            return null;
        }
    }

    private String callService(String service, String key) throws Exception {
        this.logger.finer("Call " + service);
        Browser br = new Browser();
        br.postPage(service, "jd=1&srcType=plain&data=" + key);
        this.logger.info("Call re: " + br.toString());
        if (!br.getHttpConnection().isOK() || !br.containsHTML("<rc>")) {
            return null;
        }
        String dlcKey = br.getRegex("<rc>(.*?)</rc>").getMatch(0);
        if (dlcKey.trim().length() < 80) {
            return null;
        }
        return dlcKey;
    }

    public void createDLC(List<DownloadLink> links) {
        try {
            String xml = this.createContainerStringByLinks(links);
            this.encryptAndWriteXML(xml, this.getPreSetFolder(links), this.getPreSetFileName(links));
        }
        catch (DialogCanceledException xml) {
        }
        catch (DialogClosedException xml) {
        }
        catch (IOException e) {
            Dialog.getInstance().showExceptionDialog("DLC Error", e.getMessage(), (Throwable)e);
        }
    }

    private String getPreSetFileName(List<? extends AbstractPackageChildrenNode<?>> nodes) {
        if (nodes != null && nodes.size() > 0) {
            if (nodes.size() == 1) {
                String name = nodes.get(0).getName();
                return LinknameCleaner.cleanFilename(name) + ".dlc";
            }
            for (AbstractPackageChildrenNode<?> node : nodes) {
                AbstractPackageNode parent = (AbstractPackageNode)nodes.get(0).getParentNode();
                if (parent == null) continue;
                return parent.getName() + ".dlc";
            }
        }
        return null;
    }

    private File getPreSetFolder(List<? extends AbstractPackageChildrenNode<?>> nodes) {
        if (nodes != null && nodes.size() > 0) {
            for (AbstractPackageChildrenNode<?> node : nodes) {
                AbstractPackageNode parent = (AbstractPackageNode)nodes.get(0).getParentNode();
                if (parent == null) continue;
                return LinkTreeUtils.getDownloadDirectory(parent);
            }
        }
        return null;
    }

    public void createDLCByCrawledLinks(List<CrawledLink> links) {
        try {
            String xml = this.createContainerStringByLinks(links);
            this.encryptAndWriteXML(xml, this.getPreSetFolder(links), this.getPreSetFileName(links));
        }
        catch (DialogCanceledException xml) {
        }
        catch (DialogClosedException xml) {
        }
        catch (Exception e) {
            Dialog.getInstance().showExceptionDialog("DLC Error", e.getMessage(), (Throwable)e);
        }
    }

    protected void encryptAndWriteXML(String xml, final File preSetFolder, final String preSetFilename) throws DialogClosedException, DialogCanceledException, IOException {
        ExtFileChooserDialog d = new ExtFileChooserDialog(0, _GUI.T.CreateDLCAction_actionPerformed_title_(), null, null){
            {
                super(x0, x1, x2, x3);
                if (preSetFolder != null && preSetFolder.isDirectory()) {
                    this.setPreSelection(preSetFolder);
                }
            }

            public JComponent layoutDialogContent() {
                JComponent ret = super.layoutDialogContent();
                File parent = this.fc.getCurrentDirectory();
                if (parent != null && StringUtils.isNotEmpty((String)preSetFilename)) {
                    this.fc.setSelectedFile(new File(parent, CrossSystem.alleviatePathParts((String)preSetFilename)));
                }
                return ret;
            }
        };
        d.setFileSelectionMode(FileChooserSelectionMode.FILES_ONLY);
        d.setFileFilter(new FileFilter[]{new FileFilter(){

            @Override
            public String getDescription() {
                return "*.dlc (DownloadLinkContainer)";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".dlc");
            }
        }});
        d.setType(FileChooserType.SAVE_DIALOG);
        d.setMultiSelection(false);
        Dialog.I().showDialog((AbstractDialog)d);
        File file = d.getSelectedFile();
        if (file == null) {
            new MessageDialogImpl(0, _GUI.T.DLCFactory_createDLCByCrawledLinks_nofile_title(), _GUI.T.DLCFactory_createDLCByCrawledLinks_nofile_msg(), NewTheme.I().getIcon("warning", 32), null).show();
            return;
        }
        String fileName = CrossSystem.alleviatePathParts((String)file.getName());
        if (!StringUtils.endsWithCaseInsensitive((String)fileName, (String)".dlc")) {
            fileName = fileName + ".dlc";
        }
        if (!this.writeDLC(file = new File(file.getParentFile(), fileName), xml)) {
            this.logger.severe("Container creation failed");
            Dialog.getInstance().showErrorDialog("Container encryption failed");
        }
    }

    protected boolean writeDLC(File file, String xml) throws DialogClosedException, DialogCanceledException, IOException {
        String cipher;
        if (xml != null && (cipher = this.encryptDLC(xml)) != null) {
            if (file.exists()) {
                new ConfirmDialog(0, _GUI.T.lit_file_exists(), _GUI.T.lit_file_already_exists_overwrite_question(file.getAbsolutePath())).show().throwCloseExceptions();
                FileCreationManager.getInstance().delete(file, null);
            }
            IO.writeStringToFile((File)file, (String)cipher);
            if (new ConfirmDialog(32, _GUI.T.DLCFactory_writeDLC_success_ok(), _GUI.T.DLCFactory_createDLC_created_(file.getAbsolutePath()), NewTheme.I().getIcon("logo/dlc", 32), _GUI.T.DLCFactory_writeDLC_showpath(), _GUI.T.lit_close()){

                public String getDontShowAgainKey() {
                    return "createDLC";
                }
            }.show().getCloseReason() == CloseReason.OK && !Application.isHeadless() && CFG_GUI.CFG.isContainerExportOpenExplorer()) {
                CrossSystem.showInExplorer((File)file);
            }
            return true;
        }
        return false;
    }
}

