/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.Icon;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DevConfig;
import org.appwork.storage.config.events.ConfigEventListener;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.Header;
import org.jdownloader.gui.settings.AbstractConfigPanel;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.advanced.AdvancedConfigEntry;

public abstract class ExtensionConfigPanel<T extends AbstractExtension>
extends AbstractConfigPanel
implements ConfigEventListener {
    private static final long serialVersionUID = 1L;
    protected T extension;
    private BooleanKeyHandler keyHandlerEnabled;

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }

    @Override
    public String getPanelID() {
        return this.getExtension().getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AdvancedConfigEntry> register() {
        ArrayList<AdvancedConfigEntry> configInterfaces = new ArrayList<AdvancedConfigEntry>();
        for (KeyHandler m : ((AbstractExtension)this.getExtension()).getSettings()._getStorageHandler().getKeyHandler()) {
            if (m.getAnnotation(AboutConfig.class) == null || m.getAnnotation(DevConfig.class) != null && Application.isJared(null)) continue;
            if (m.getGetMethod() == null) {
                throw new RuntimeException("Getter for " + m.getKey() + " missing");
            }
            if (m.getSetMethod() == null && m.getAnnotation(StorableValidatorIgnoresMissingSetter.class) == null) {
                throw new RuntimeException("Setter for " + m.getKey() + " missing");
            }
            ArrayList<AdvancedConfigEntry> arrayList = configInterfaces;
            synchronized (arrayList) {
                configInterfaces.add(new AdvancedConfigEntry((ConfigInterface)((AbstractExtension)this.getExtension()).getSettings(), (KeyHandler<?>)m));
            }
        }
        return configInterfaces;
    }

    protected String getHeaderName(T plg) {
        return ((AbstractExtension)plg).getName();
    }

    public ExtensionConfigPanel(T plg, boolean clean) {
        this.extension = plg;
        this.keyHandlerEnabled = (BooleanKeyHandler)((AbstractExtension)plg).getSettings()._getStorageHandler().getKeyHandler("enabled", BooleanKeyHandler.class);
        ((AbstractExtension)plg).getSettings()._getStorageHandler().getEventSender().addListener((EventListener)((Object)this));
        if (!clean) {
            final Header header = new Header(this.getHeaderName(plg), NewTheme.I().getIcon(((AbstractExtension)this.extension).getIconKey(), 32), this.keyHandlerEnabled, ((AbstractExtension)this.extension).getVersion());
            this.add(header, "spanx,growx,pushx");
            header.setEnabled(((AbstractExtension)plg).isEnabled());
            if (((AbstractExtension)plg).getDescription() != null) {
                this.addDescription(((AbstractExtension)plg).getDescription());
            }
            this.keyHandlerEnabled.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

                public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                    try {
                        ((AbstractExtension)ExtensionConfigPanel.this.extension).setEnabled(header.isHeaderEnabled());
                        ExtensionConfigPanel.this.updateHeaders(header.isHeaderEnabled());
                    }
                    catch (Exception e1) {
                        LoggerFactory.getDefaultLogger().log((Throwable)e1);
                        Dialog.getInstance().showExceptionDialog("Error", e1.getMessage(), (Throwable)e1);
                    }
                }

                public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
                }
            });
        }
    }

    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
    }

    public ExtensionConfigPanel(T plg) {
        this(plg, false);
    }

    @Override
    protected void onShow() {
        super.onShow();
        this.updateHeaders(((AbstractExtension)this.extension).isEnabled());
    }

    private void updateHeaders(boolean b) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof Header)) continue;
            ((Header)c).setHeaderEnabled(b);
        }
    }

    @Override
    public Icon getIcon() {
        return NewTheme.I().getIcon(((AbstractExtension)this.extension).getIconKey(), 32);
    }

    @Override
    public String getTitle() {
        return ((AbstractExtension)this.extension).getName();
    }

    public T getExtension() {
        return this.extension;
    }
}

